//LabPlot : GraphList.cc

#include <stdio.h>
#include <iostream>
#include <kdebug.h>
#include "GraphList.h"

using namespace std;

GraphList::GraphList() {
	kdDebug()<<"GraphList()"<<endl;
	clear();
}

void GraphList::clear() {
//	kdDebug()<<"GraphList::clear()"<<endl;
	nr2D = nr3D = nrM = nr4D = nrIMAGE = nrL = 0;
	for (int i=0;i<NR_TYPES*MAX_NR;i++)
		id[i]=-1;
	for (int i=0;i<MAX_NR;i++) {
		list2D[i]=0;
		list3D[i]=0;
		listM[i]=0;
		list4D[i]=0;
		listIMAGE[i]=0;
		listL[i]=0;
	}
	// TODO : free deleted graphs ?
}

void GraphList::saveXML(QDomDocument doc, QDomElement root) {
	kdDebug()<<"GraphList::saveXML()"<<endl;
	for (unsigned int i=0;i < Number();i++) {
		kdDebug()<<"	saving graph "<<i<<endl;
		QDomElement tag = getGraph(i)->saveGraphXML(doc,getType(i));
   		root.appendChild( tag );
	}
}

/*void GraphList::openXML(QDomNode node, int type) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		// TODO : open graphs
		if(e.tagName() == "Graph")
			kdDebug()<<" GOT A GRAPH"<<endl;

		node = node.nextSibling();
	}
}*/

int GraphList::addGraph2D(Graph2D *g) {
//	kdDebug()<<"GraphList::addGraphX  Name = "<<g->Name()<<endl;
//	kdDebug()<<"GraphList::addGraphX : isNotFull() = "<<isNotFull()<<endl;
//	kdDebug()<<"GraphList::addGraphX : nr(2D,3D,M,GRASS,4D,IMAGE) = "<<endl;
//	kdDebug()<<nr2D<<' '<<nr3D<<' '<<nrM<<' '<<nrGRASS<<' '<<nr4D<<' '<<nrIMAGE<<endl;

	if(isNotFull() && nr2D<MAX_NR) {
		id[nr2D] = Number();
		list2D[nr2D++] = g;

		//kdDebug()<<"GraphList::addGraph2D : nr2D = "<<nr2D<<endl;
		return 1;
	}
	return 0;
}

int GraphList::addGraph3D(Graph3D *g) {
	if(isNotFull() && nr3D<MAX_NR) {
		id[MAX_NR+nr3D] = Number();
		list3D[nr3D++] = g;

		kdDebug()<<"GraphList::addGraph3D : id["<<MAX_NR+nr3D-1<<"] = "<<endl;
		kdDebug()<<id[MAX_NR+nr3D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list3D[nr3D-1]->Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphM(GraphM *g) {
	if(isNotFull() && nrM<MAX_NR) {
		id[2*MAX_NR+nrM] = Number();
		listM[nrM++] = g;

		kdDebug()<<"GraphList::addGraphM : id["<<2*MAX_NR+nrM-1<<"] = "<<id[2*MAX_NR+nrM-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listM[nrM-1]->Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraph4D(Graph4D *g) {
	if(isNotFull() && nr4D<MAX_NR) {
		id[5*MAX_NR+nr4D] = Number();
		list4D[nr4D++] = g;

		kdDebug()<<"GraphList::addGraph4D : id["<<5*MAX_NR+nr4D-1<<"] = "<<endl;
		kdDebug()<<id[5*MAX_NR+nr4D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list4D[nr4D-1]->Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphIMAGE(GraphIMAGE *g) {
	if(isNotFull() && nrIMAGE<MAX_NR) {
		id[6*MAX_NR+nrIMAGE] = Number();
		listIMAGE[nrIMAGE++] = g;

		kdDebug()<<"GraphList::addGraphIMAGE : id["<<6*MAX_NR+nrIMAGE-1<<"] = "<<endl;
		kdDebug()<<id[6*MAX_NR+nrIMAGE-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listIMAGE[nrIMAGE-1]->Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphL(GraphL *g) {
	if(isNotFull() && nrL < MAX_NR) {
		id[7*MAX_NR+nr4D] = Number();
		listL[nrL++] = g;

		kdDebug()<<"GraphList::addGraphL : id["<<7*MAX_NR+nrL-1<<"] = "<<endl;
		kdDebug()<<id[7*MAX_NR+nrL-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listL[nrL-1]->Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::delGraph(unsigned int index) {
	kdDebug()<<"GraphList::delGraph()"<<endl;
	unsigned int i=Index(index);
	kdDebug()<<"	deleting graph "<<index<<" (index "<<i<<" in listX[])"<<endl;

	if(index <= Number()) {
		GRAPHType s = getType(index);
		kdDebug()<<"	GraphType = "<<s<<endl;
		switch (s) {
		case GRAPH2D:
			delete list2D[i];
			while (i<nr2D) {
				list2D[i] = list2D[i+1];
				id[i] = id[i+1];
				i++;
			}
			nr2D--;
			break;
		case GRAPH3D:
			delete list3D[i];
			while (i<nr3D) {
				list3D[i] = list3D[i+1];
				id[MAX_NR+i] = id[MAX_NR+i+1];
				i++;
			}
			nr3D--;
			break;
		case GRAPHM:
			delete listM[i];
			while (i<nrM) {
				listM[i] = listM[i+1];
				id[2*MAX_NR+i] = id[2*MAX_NR+i+1];
				i++;
			}
			nrM--;
			break;
		case GRAPH4D:
			delete list4D[i];
			while (i<nr4D) {
				list4D[i] = list4D[i+1];
				id[5*MAX_NR+i] = id[5*MAX_NR+i+1];
				i++;
			}
			nr4D--;
			break;
		case GRAPHIMAGE:
			delete listIMAGE[i];
			while (i<nrIMAGE) {
				listIMAGE[i] = listIMAGE[i+1];
				id[6*MAX_NR+i] = id[6*MAX_NR+i+1];
				i++;
			}
			nrIMAGE--;
			break;
		case GRAPHL:
			delete listL[i];
			while (i<nrL) {
				listL[i] = listL[i+1];
				id[7*MAX_NR+i] = id[7*MAX_NR+i+1];
				i++;
			}
			nrL--;
			break;
		default:
			break;
		}

		// decrement all id values above
		for(int j=0;j<MAX_NR*NR_TYPES;j++) {
			// cast to int! id[] is signed.
			if(id[j] > (int) index)
				id[j] -= 1;
		}

		kdDebug()<<"GraphList::delGraph : nr(2D,3D,M,4D,IMAGE) = "<<endl;
		kdDebug()<<nr2D<<' '<<nr3D<<' '<<nrM<<' '<<nr4D<<' '<<nrIMAGE<<endl;
		for(int k=0;k<NR_TYPES;k++) {
			//for(int j=0;j<MAX_NR;j++)
			for(int j=0;j<10;j++)
				printf(" id[%d] = %d",k*MAX_NR+j,id[k*MAX_NR+j]);
			printf("\n");
		}

		return 1;
	}

	return 0;
}

GRAPHType GraphList::getType(int index) {
	for(int i=0;i<MAX_NR;i++) {
		//printf("\ti=%d, id[i]=%d,id[i+MAX_NR]=%d,id[i+2*MAX_NR]=%d\n",
		//		i,id[i],id[i+MAX_NR],id[i+2*MAX_NR]);

		if (id[i] == index) {
			return GRAPH2D;
		}
		else if (id[MAX_NR+i] == index) {
			return GRAPH3D;
		}
		else if (id[2*MAX_NR+i] == index) {
			return GRAPHM;
		}
		else if (id[3*MAX_NR+i] == index) {
			return GRAPH2D;	// was GRASS
		}
		else if (id[4*MAX_NR+i] == index) {
			return GRAPH2D;	// was VTK
		}
		else if (id[5*MAX_NR+i] == index) {
			return GRAPH4D;
		}
		else if (id[6*MAX_NR+i] == index) {
			return GRAPHIMAGE;
		}
		else if (id[7*MAX_NR+i] == index) {
			return GRAPHL;
		}
	}
	return GRAPH2D;	//default return
}

// return index in listX[] from graph index
int GraphList::Index(int index) {
//	kdDebug()<<"GraphList::Index("<<index<<")"<<endl;
	for(int i=0;i<MAX_NR;i++) {
		for(int j=0;j<NR_TYPES;j++) {
			if(id[j*MAX_NR+i] == index)
				return i;
		}
	}
	return 0;
}

Graph *GraphList::getGraph(unsigned int i) {
	kdDebug()<<"GraphList::getGraph("<<i<<")"<<endl;
	if(i <= Number()) {
		GRAPHType gtype = getType(i);
		kdDebug()<<"Graph Type = "<<gtype<<endl;
		kdDebug()<<"Index = "<<Index(i)<<endl;
		switch (gtype) {
		case GRAPH2D: return (Graph *) list2D[Index(i)]; break;
		case GRAPH3D: return (Graph *) list3D[Index(i)]; break;
		case GRAPHM: return (Graph *) listM[Index(i)]; break;
		case GRAPH4D: return (Graph *) list4D[Index(i)]; break;
		case GRAPHIMAGE: return (Graph *) listIMAGE[Index(i)]; break;
		case GRAPHL: return (Graph *) listL[Index(i)]; break;
		default: break;
		}
	}
	return 0;
}

Graph2D *GraphList::getGraph2D(int i) {
	kdDebug()<<"GraphList::getGraph2D("<<i<<")"<<endl;
	if (i >= Index(i))
		return list2D[Index(i)];
	return 0;
}

Graph3D *GraphList::getGraph3D(int i) {
	if (i >= Index(i))
		return list3D[Index(i)];
	return 0;
}

GraphM *GraphList::getGraphM(int i) {
	if (i >= Index(i))
		return listM[Index(i)];
	return 0;
}

Graph4D *GraphList::getGraph4D(int i) {
	if (i >= Index(i))
		return list4D[Index(i)];
	return 0;
}

GraphIMAGE *GraphList::getGraphIMAGE(int i) {
	if (i >= Index(i))
		return listIMAGE[Index(i)];
	return 0;
}

GraphL *GraphList::getGraphL(int i) {
	if (i >= Index(i))
		return listL[Index(i)];
	return 0;
}

