/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSVectorLayer.cpp,v 1.9 2002/12/03 08:24:44 com Exp $
*/

#include <GRASSVectorLayer.h>
#include <GRASSPainter.h>
#include <qpainter.h>

//int const GRASSVectorLayer::GRASSVectorLayerID = 1;


GRASSVectorLayer::GRASSVectorLayer(GRASSPainter* painter, 
				   char* name,
				   char* mapset_) 
  : 
  _painter(painter), _penColor(Qt::red), _fillColor(Qt::white),
  _drawMode(line)
{
  _name = name;
  
  char buf[256];
  char* mapset = G_find_file2 ("dig", name, "") ;
  if (mapset == NULL) {
    sprintf(buf,"Vector file [%s] not available", name);
    G_fatal_error(buf) ;
    //exit(-1);
  }

  _mapSet = mapset;

  
  if (2 > Vect_open_old (&P_map, name, mapset)) {
    fprintf (stderr, "\nWARNING: vector file [%s] - Could not open Level 2\n",
	     name);
  }

  _points = Vect_new_line_struct ();
}


GRASSVectorLayer::~GRASSVectorLayer() {
  Vect_destroy_line_struct (_points);
}


void GRASSVectorLayer::draw(QPainter* p) {
  switch(_drawMode)
    {
    case line:
      linePlot(p);
      break;
    case fill:
      polyPlot(p);
      break;
    default:
      break;
    } /* end of switch(_drawMode) */
  
}

void GRASSVectorLayer::linePlot(QPainter* p) {
  int nlines = V2_num_lines (&P_map);
  
  p->setPen(_penColor);
  
  Vect_set_constraint_region (&P_map, _painter->grassRegion().north,
			      _painter->grassRegion().south, 
			      _painter->grassRegion().east, 
			      _painter->grassRegion().west);
  
  Vect_rewind(&P_map);

  while (1) {
    int ret;
    if (0 > (ret = Vect_read_next_line (&P_map, _points))) {
      if (ret == -1)
	G_warning ("Read error\n");
      break;
    }
    int np = _points->n_points;
//      cerr << "GRASSVectorLayer::linePlot read " << np << " points" << endl;
    double* x  = _points->x;
    double* y =  _points->y;
    for (int i=1; i < np; i++) {
//        cerr << "[" << x[0] << "," << y[0] << "] -> [" << x[1] << "," 
//  	   << y[1] << "]" << endl;
      plot_line (x[0], y[0], x[1], y[1], p);
      x++;
      y++;
    }
  }
}

//  //#define X(e) (left + xconv * ((e) - window.west))
//  #define X(e) (0 + xconv * ((e) - _painter->grassRegion().west))
//  //#define Y(n) (top + yconv * (_painter->_grassRegion().north - (n)))
//  #define Y(n) (0 + yconv * (_painter->grassRegion().north - (n)))



#define X(e) (_painter->D.D_u_to_d_col(e))
#define Y(n) (_painter->D.D_u_to_d_row(n))


int GRASSVectorLayer::plot_line(double east1,double north1,
				double east2,double north2, QPainter* p) 
{
    double x1,x2,y1,y2;

    int xconv = _painter->D.D_get_u_to_d_xconv();
    // (right-left)/(_painter->D..east-window.west);
    int yconv =  _painter->D.D_get_u_to_d_yconv();
    //(bottom-top)/(window.north-window.south);


    y1 = Y(north1);
    y2 = Y(north2);

    if (_painter->grassRegion().proj == PROJECTION_LL)
    {
	if (east1 > east2)
	    while ((east1-east2) > 180)
		east2 += 360;
	else if (east2 > east1)
	    while ((east2-east1) > 180)
		east1 += 360;
	while (east1 > _painter->grassRegion().east)
	{
	    east1 -= 360.0;
	    east2 -= 360.0;
	}
	while (east1 < _painter->grassRegion().west)
	{
	    east1 += 360.0;
	    east2 += 360.0;
	}
	x1 = X(east1);
	x2 = X(east2);

	p->moveTo(x1, y1);
	p->lineTo(x2, y2);

	if (east2 > _painter->grassRegion().east || east2 < _painter->grassRegion().west)
	{
	    while (east2 > _painter->grassRegion().east)
	    {
		east1 -= 360.0;
		east2 -= 360.0;
	    }
	    while (east2 < _painter->grassRegion().west)
	    {
		east1 += 360.0;
		east2 += 360.0;
	    }
	    x1 = X(east1);
	    x2 = X(east2);
	    p->moveTo(x1, y1);
	    p->lineTo(x2, y2);
	}
    }
    else
    {
	x1 = X(east1);
	x2 = X(east2);
	p->moveTo(x1, y1);
	p->lineTo(x2, y2);
    }

    return 0;
}


extern "C" {
#include "screenpoly.h"
}
/* ripped from plot1 in d.area plot.c */

void GRASSVectorLayer::polyPlot(QPainter* p) {
  int i;
  int nisles;
  int* x_screen; int* y_screen;
  P_AREA* pa;

  int t = _painter->D.D_get_d_north();
  int b = _painter->D.D_get_d_south();
  int l = _painter->D.D_get_d_west();
  int r = _painter->D.D_get_d_east();
  
  p->setBrush(_fillColor);



  if ( ! _penColor.isValid() ) {
    p->setPen(Qt::NoPen) ;
//      cerr << "polyPlot invalid pen\n";
  } else 
    p->setPen(_penColor);

  Vect_set_constraint_region (&P_map, _painter->grassRegion().north,
			      _painter->grassRegion().south, 
			      _painter->grassRegion().east, 
			      _painter->grassRegion().west);

  Vect_rewind(&P_map);
  
  /* TODO: Not working yet */
  SCREENPOLY* spClip = ScreenPolyNew (4);
  ScreenPolyAddPoint (spClip, l, t);
  ScreenPolyAddPoint (spClip, r, t);
  ScreenPolyAddPoint (spClip, r, b);
  ScreenPolyAddPoint (spClip, l, b);

//   fprintf (stderr,"GRASSVectorLayer::polyPlot Plotting ... "); fflush (stderr);
  int nlines = V2_num_areas(&P_map);
  for (int line = 1;line <= nlines; line++)
    {
//        /* Percentages */
//        G_percent (line, nlines, 5);

      //int dofill = V2_area_att (&P_map, line); /* Returns 0 if area is unlabelled */
      int dofill = 1;//V2_area_att (&P_map, line); /* Returns 0 if area is unlabelled */

      /* Skip areas that we wont fill or draw outlines for */
      //if (!dofill && /*linecolor*/ _penColor == Qt::white)
      if (!dofill && ! _penColor.isValid() )
	continue;
        
      switch (Vect_get_area_points(&P_map, line, _points))
	{
	case -1:
	  Vect_close (&P_map);
	  //fprintf (stderr, "\nERROR: vector file [%s] - can't read\n", name);
	  //fprintf (stderr, "\nERROR: vector file [no NAME!!!] - can't read\n");
	  return ;
	  break;
	case -2:
	  //fprintf (stdout,"Done\n");
	  Vect_close (&P_map);
	  return;
	  break;
	}

      double N, S, E, W;
      V2_get_area_bbox(&P_map, line, &N, &S, &E, &W);
      if ( S > _painter->grassRegion().north || 
	   N <  _painter->grassRegion().south || 
	   W > _painter->grassRegion().east || 
	   E <  _painter->grassRegion().west )
	continue;

      /* Get a SCREENPOLY type for the polygon line */
      SCREENPOLY* spLine = ScreenPolyNew(_points->n_points);

      for(i=0; i < _points->n_points; i++)
	{
	  /* Populate the SCREENPOLY type with screen coordinates */
	  ScreenPolyAddPoint (
			      spLine,
			      (int) (_painter->D.D_u_to_d_col(_points->x[i])),
			      (int) (_painter->D.D_u_to_d_row(_points->y[i]))
			      );
	}
        
      /* Clip lines to screen window 
       * TODO: Not working yet.
       *********
       spTmp = ScreenPolyClip (spLine, spClip);
       ScreenPolyDestroy (spLine);
       if (spTmp == NULL)
       continue;
       spLine = spTmp;
      *******/

      /* Are we filling this poly */
      if (dofill)
        {
	  /* Make copy of polygon */
	  SCREENPOLY* spArea = ScreenPolyNew (spLine->count);
	  ScreenPolyCopy (spLine, spArea);

	  /* Need to do extra work to handle islands */
	  V2_get_area (&P_map, line, &pa);
	  if ((nisles = pa->n_isles) > 0)
            {
	      /* Then we need to "merge" in island polys */
	      for (i = 0; i < nisles ; i++)
                {
		  struct line_pnts* Isle = Vect_new_line_struct();
		  Vect_get_isle_points (&P_map, pa->isles[i], Isle);
		  SCREENPOLY* spIsle = ScreenPolyNew(Isle->n_points);
		  for (int j = 0; j < Isle->n_points; j++)
		    ScreenPolyAddPoint (
					spIsle, 
					(int) (_painter->D.D_u_to_d_col (Isle->x[j])),
					(int) (_painter->D.D_u_to_d_row (Isle->y[j]))
					);
		  Vect_destroy_line_struct (Isle);
		  /* TODO: Not working yet.
	   *********
	   spTmp = ScreenPolyClip (spIsle, spClip);
	   ScreenPolyDestroy (spIsle);
	   if (spTmp == NULL)
	   continue;
	   spIsle = spTmp;
		  **********/
		  SCREENPOLY* spTmp = ScreenPolyMerge (spArea, spIsle);
		  ScreenPolyDestroy (spIsle);
		  ScreenPolyDestroy (spArea);
		  if (spTmp == NULL)
		    G_fatal_error ("Failed to merge islands with outer poly");
		  spArea = spTmp;
                }
                    
            }
           
	  i = ScreenPolyToArrays (spArea, &x_screen, &y_screen);
	  ScreenPolyDestroy (spArea);

	  if (i == 0)
            {
	      /* G_warning ("No points in point struct ??"); */
	      continue;
            }
	  else if (i < 0)
	    G_fatal_error ("Converting ScreenPoly to Arrays");
	  else
            {
	      //R_standard_color(fillcolor);
	      //R_polygon_abs(x_screen, y_screen, i);
	      QPointArray points(i);
	      for (int j = 0; j < i; j++) {
//  		cerr <<  x_screen[j] << "," <<  y_screen[j];
		//points.setPoint(j, x_screen[j], y_screen[j]);
		points[j] = QPoint(x_screen[j], y_screen[j]);
	      }
	      //xcerr << endl;
// 	      QColor c; c.setRgb(random()%256, random()%256, random()%256);
// 	      p->setBrush(c); // hack to test reomve!!!
	      p->drawPolygon(points);
// 	      char buf[256];
// 	      sprintf(buf, "P#: %d", line);
// 	      p->drawText(points[0].x(), points[0].y(), buf);

            }
	  G_free (x_screen);
	  G_free (y_screen);
            
        }

      /* Are we drawing poly outlines ? */
      //if (_penColor != Qt::white)
      if ( _penColor.isValid() )
	{
	  i = ScreenPolyToArrays (spLine, &x_screen, &y_screen);   
	  if (i > 0)
            {
	      //R_standard_color(linecolor);
	      //R_polyline_abs(x_screen,y_screen, i);
	      QPointArray points(i);
	      for (int j = 0; j < i; j++) {
		points[j] = QPoint(x_screen[j], y_screen[j]);
		//points.setPoint(j, x_screen[j], y_screen[j]);
	      }
	      p->drawPolyline(points);
	      G_free(x_screen);
	      G_free(y_screen);
            }
	  else if (i < 0)
	    G_fatal_error ("Converting ScreenPoly to Arrays");
	}
      ScreenPolyDestroy (spLine);

    }
  /* do newline */
  //fprintf (stderr, "\n");

  /* TODO: Clipping not yet functional */
  /* ScreenPolyDestroy (spClip); */

  ScreenPolyDestroy (spClip); 
  return;
}







GRASSVectorLayer::GRASSVectorLayer(const GRASSVectorLayer& rhs) {}

GRASSVectorLayer& GRASSVectorLayer::operator=(const GRASSVectorLayer& rhs) {
  return *this;
}



