/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSRasterColorMap.h,v 1.3 2002/04/23 09:28:18 com Exp $
*/

#ifndef GRASSRASTERCOLORMAP_H
#define GRASSRASTERCOLORMAP_H


extern "C" {
#include <gis.h>
}

/**
 *
 *
 **/

class GRASSRasterColorMap {
public:
  

  GRASSRasterColorMap();

  ///the default constructor
  GRASSRasterColorMap(struct Colors* colors);

  ///the destructor
  virtual ~GRASSRasterColorMap();


  void setColors(struct Colors* colors);
  
  //protected:
  
  //private:

  ///the copy constructor
  GRASSRasterColorMap(const GRASSRasterColorMap& rhs);

  
  ///the assignment operator
  GRASSRasterColorMap& operator=(const GRASSRasterColorMap& rhs);

  int is_grey_scale(/*struct Colors *colors*/);

  int check_colormap_size (CELL min,CELL max, int *ncolors);

  int allocate_colors(int ncolors);

  void lookup_raster_colors(void* raster, int ncols, RASTER_MAP_TYPE data_type);

  struct Colors* colors;

  int
  _RED[256],
    _GRN[256],
    _BLU[256],
    fixed;

  unsigned char  *red,
    *grn,
    *blu,
    *set;
  
  CELL cmin, cmax;
  
  int nalloc;
  int color_buf_size;
  int *color_buf;

};	// end of class GRASSRasterColorMap


#endif /* GRASSRASTERCOLORMAP_H */
















