/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSPainter.h,v 1.6 2002/04/23 09:28:18 com Exp $
*/

#ifndef GRASSPAINTER_H
#define GRASSPAINTER_H

extern "C" {
#include <gis.h>
}

#include <string>
#include <vector>

#include <GeoXY.h>

class GRASSLayer;
using namespace std;

typedef vector<GRASSLayer*> LayerVector;
typedef LayerVector::iterator LayerVectorIter;


/**
 *
 *
 **/




class GRASSPainter {
public:
  
  GRASSPainter(char* location);

  virtual ~GRASSPainter();
  
  void addLayer(GRASSLayer* layer);

  void removeLayer(GRASSLayer* layer);  

  void paint(QRect& area, QPainter* painter);

  string xYToLatLong(int x, int y);

  void zoom(QRect& zoomRect);

  void unZoom(double magnify=1.00000);

  void pan(int x, int y, double magnify=1.000000);

  void useDefaultRegion();

  struct Cell_head const & grassRegion() { return _grassRegion; }

  LayerVectorIter begin() { return _layers.begin(); }
  
  LayerVectorIter end() { return _layers.end(); }

  string location();

  void changeBrilliance(int v);

  int *D_to_A_tab;
  int D_x_beg, D_y_beg, D_x_end, D_y_end ;
  GeoXY D;  
protected:
  
private:

  GRASSPainter(const GRASSPainter& rhs);

  GRASSPainter& operator=(const GRASSPainter& rhs);

  struct Cell_head _grassRegion;

  string _location;


  LayerVector _layers;

};



#endif /* GRASSPAINTER_H */
