/***************************************************************************
 *
 *  $Id: kzentageditor.h,v 1.6 2005/06/02 07:09:01 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENTAGEDITOR_H
#define KZENTAGEDITOR_H

#include <kdialogbase.h>

#include <qvariant.h>
#include <qptrlist.h>
#include <qbitarray.h>

#include "kzentrack.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class KComboBox;
class KIntNumInput;
class QCheckBox;
class QLabel;
class KIntSpinBox;
class KLineEdit;
class KZenRatingWidget;
class KPushButton;

class KZenTagEditor : public KDialogBase
{
  Q_OBJECT
    
 public:
 
  KZenTagEditor(QWidget* parent = 0, 
		const char* name = 0);
  virtual ~KZenTagEditor();
  
  void                        setup(QPtrList<KZenTrack> * tracks);

  void                        setTrackList(QPtrList<KZenTrackItem> & tracks);

  bool                        isArtistChecked();
  bool                        isAlbumChecked();
  bool                        isTitleChecked();
  bool                        isGenreChecked();
  bool                        isTrackNumberChecked();
  bool                        isYearChecked();
  bool                        isRatingChecked();
  bool                        isCategoryChecked();

  void                        checkAll(bool);

  const char *                getArtist();
  const char *                getAlbum();
  const char *                getTitle();
  const char *                getGenre();
  uint                        getTrackNumber();
  uint                        getYear();
  uint                        getRating();
  const QBitArray &           getCategories();
  
 protected:
  
  void                        accept();

  QLabel                     *fArtistLabel;
  KComboBox                  *fArtistCombo;
  QCheckBox                  *fArtistCheck;

  QLabel                     *fAlbumLabel;
  KComboBox                  *fAlbumCombo;
  QCheckBox                  *fAlbumCheck;
  
  QLabel                     *fTitleLabel;
  KLineEdit                  *fTitleEdit;
  QCheckBox                  *fTitleCheck;

  QLabel                     *fGenreLabel;
  KComboBox                  *fGenreCombo;
  QCheckBox                  *fGenreCheck;
  
  QLabel                     *fTrackLabel;
  KIntSpinBox                *fTrackEdit;
  QCheckBox                  *fTrackCheck;
  QLabel                     *fYearLabel;
  KIntSpinBox                *fYearEdit;
  QCheckBox                  *fYearCheck;
  QLabel                     *fRatingLabel;
  KZenRatingWidget           *fRatingInput;
  QCheckBox                  *fRatingCheck;

  QCheckBox                  *fCategoryCheck;
  KPushButton                *fCategoryPush;
  QLabel                     *fCategoryLabel;
  QBitArray                   fCategories;

  QHBoxLayout                *fTopLayout;
  QGridLayout                *fGridLayout;
  QSpacerItem                *fSpacer1;
  QSpacerItem                *fSpacer2;

 protected slots:
  
  void                        languageChange();
  
  void                        slotArtistCheck_clicked();
  void                        slotAlbumCheck_clicked();
  void                        slotTitleCheck_clicked();
  void                        slotGenreCheck_clicked();
  void                        slotTrackCheck_clicked();
  void                        slotYearCheck_clicked();
  void                        slotRatingCheck_clicked();
  void                        slotCategoryCheck_clicked();
  void                        slotSelectCategory();
};

#endif
