/***************************************************************************
 *
 *  $Id: kzenplaylist.h,v 1.7 2005/06/04 10:22:21 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENPLAYLIST_H
#define KZENPLAYLIST_H

#include <libnjb.h>

#include <qptrlist.h>

#include "kzenitem.h"

class QPainter;

class KZenTrack;
class KZenPlayListItem;

/**
@author Andreas Mussgiller
*/
class KZenPlayList
{
 
 public:
 
  KZenPlayList();
  KZenPlayList(const char * name);
  KZenPlayList(njb_playlist_t * pl, QPtrList<KZenTrack> * tracks);
  virtual ~KZenPlayList();

  const QString &             getName() { return fName; }
  void                        setName(const char * name);

  int                         getID() { return fID; }
  void                        setID(int id) { fID = id; }

  virtual void                addTrack(KZenTrack *);
  QPtrList<KZenTrack> *       getTrackList() { return fTracks; }

  bool                        isModified() { return fModified; }
  static int                  getNModified() { return fNModified; }
  void                        setModified(bool m);

  void                        shuffle();

  KZenPlayListItem *          getItem() { return fItem; }
  void                        setItem(KZenPlayListItem * i) { fItem = i; }

  uint                        getTrackCount();
  uint                        getLength();

 protected:

  QString                     fName;
  int                         fID;
  bool                        fModified;
  static int                  fNModified;

  KZenPlayListItem           *fItem;

  QPtrList<KZenTrack>        *fTracks;
};

class KZenPlayListItem : public KZenItem
{
 public:

  KZenPlayListItem(QListView * parent, KZenPlayList * PlayList);
  ~KZenPlayListItem();

  KZenPlayList *              getPlayList() { return fPlayList; }

  virtual void                setSortColumn(int) { }

  void                        paintCell(QPainter*, const QColorGroup&, int, int, int);

 protected:
  
  KZenPlayList               *fPlayList;
};

#endif
