
#include "configuration.h"
#include "kipsettingsdlg.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <kmessagebox.h>

KIpSettingsDlg::KIpSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KIpSettings(parent,name, modal,fl)
{
}

KIpSettingsDlg::~KIpSettingsDlg()
{
}

/*$SPECIALIZATION$*/
void KIpSettingsDlg::setSsid(QString ssid)
{
    QString ipaddress, netmask,gateway,dns1,dns2,domain;
    bool useDhcp, dontOverrideIp,dontOverrideDns;
    if (ssid.isEmpty()) return;
    txtSsid->setText(ssid);
    Config().readIpSettings(ssid,useDhcp, ipaddress, netmask, gateway, dns1, dns2,domain,dontOverrideIp,dontOverrideDns);
    cbDhcp->setChecked(useDhcp);
    leIpAddress->setText(ipaddress);
    leNetmask->setText(netmask);
    leGateway->setText(gateway);
    leDns1->setText(dns1);
    leDns2->setText(dns2);
    leDomain->setText(domain);
    cbOverrideIp->setChecked(dontOverrideIp);
    cbOverrideDns->setChecked(dontOverrideDns);
}

void KIpSettingsDlg::dhcpChanged(int state)
{
    state = !state;
    leIpAddress->setEnabled(state);
    leNetmask->setEnabled(state);
    leGateway->setEnabled(state);
    leDns1->setEnabled(state);
    leDns2->setEnabled(state);
    leDomain->setEnabled(state);
    cbOverrideDns->setEnabled(state);
    cbOverrideIp->setEnabled(state);
}

void KIpSettingsDlg::setEncrypted(bool encrypted)
{
    m_encrypted = encrypted;
}

void KIpSettingsDlg::Cancel()
{
    close();
}

void KIpSettingsDlg::Ok()
{
    int ret;
    ret = Config().writeIpSettings(txtSsid->text(),cbDhcp->isChecked(), leIpAddress->text(), leNetmask->text(), leGateway->text(), leDns1->text(), leDns2->text(), leDomain->text(),cbOverrideIp->isChecked(), cbOverrideDns->isChecked();
    if  (ret !=0) KMessageBox::sorry(this,"Could not write IP Settings");
    close();
}



#include "kipsettingsdlg.moc"

