/***************************************************************************
                          reportview.cpp  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "reportview.h"
#include <qregexp.h>
#include <qlayout.h>

#include <kstddirs.h>
#include <khtml_part.h>

reportView::reportView(QWidget *parent,const char *name) : QDialog(parent,name,true,WDestructiveClose) {
	QHBoxLayout *layout = new QHBoxLayout(this);
	theReport = new KHTMLPart(this, "Form1");
	theReport->widget()->resize(320,480);
	layout->addWidget(theReport->widget());
}
reportView::~reportView(){
}
/**  */
void reportView::setTemp( QString theTemp){
	currentTemp = theTemp;
}
/** Render the document */
void reportView::render(){
	theReportText ="<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\""
	               " \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"
	               "<html><head><title>Weather Report</title></head><body>"
	               "<h2> Weather Report as of $Current_Date </h2><hr />"
	               "<table><tr><th colspan=\"2\">Current Conditions:</th></tr>"
				   "<tr><td><img src=\"$Current_Icon\" /></td><td>$Current_Weather</td></tr>"
	               "<tr><th>Temperature:</th><td>$Current_Temp</td></tr>"
	               "<tr><th>Air Pressure:</th><td>$Current_Pressure</td></tr>"
	               "<tr><th>WindSpeed:</th><td>$Current_Wind</td></tr></table>"
	               "<hr /></body></html>";
	theReportText.replace( QRegExp("$Current_Icon"), KURL(locate("data", "kweather/" + currentIcon + ".png")).url());
	theReportText = theReportText.replace( QRegExp("$Current_Temp"), currentTemp );
	theReportText = theReportText.replace( QRegExp("$Current_Time"), currentTime );
	theReportText = theReportText.replace( QRegExp("$Current_Pressure"), currentPressure );
	theReportText = theReportText.replace( QRegExp("$Current_Wind"), currentWind );
	theReportText = theReportText.replace( QRegExp("$Current_Date"), currentDate );
	theReportText = theReportText.replace( QRegExp("$Current_Clouds"), currentClouds );
	theReportText = theReportText.replace( QRegExp("$Current_Weather"), currentWeather );
	theReport->begin();
	theReport->write( theReportText );
	theReport->end();
}
/**  */
void reportView::setWindData( QString data){
	currentWind = data;
}
/**  */
void reportView::setTime( QString data ){
	currentTime = data;
}
/**  */
void reportView::setPressure( QString data ){
	currentPressure = data;
}
/**  */
void reportView::setDate( QString data ){
	currentDate = data;
}
/** the current weather */
void reportView::setCurrent(QString text){
	if (text.isEmpty())
		currentWeather = " clear sky. ";
	else
		currentWeather = text;
	
}
void reportView::setIcon( const QString &icon )
{
	currentIcon = icon;
}
/**  */
void reportView::setOffset( int offset ){
		
}
#include "reportview.moc"
