//===============================================================================
//
//   File : setupwizard.cpp
//   Creation date : Sat Oct  6 02:06:53 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//==============================================================================


#include "setupwizard.h"

#include "kvi_app.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"
#include "kvi_defaults.h"
#include "kvi_msgbox.h"
#include "kvi_tal_filedialog.h"
#include "kvi_qstring.h"
#include "kvi_env.h"

#include <qtextedit.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qvalidator.h>
#include <qtextcodec.h>
#include <qhbox.h> 

#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>
	#include <winnls.h>  // for MultiByteToWideChar
	#include <objbase.h> // CoCreateInstance , CoInitialize & CO.
	#include <shlobj.h>  // IShellLink IPersistFile & CO.
#else
	#include <unistd.h>  // for symlink()
#endif

// libkvisetup.cpp
extern KviStr g_szChoosenIncomingDirectory;
extern int g_iThemeToApply;
extern QString g_szChoosenDefaultNick;


#ifdef COMPILE_ON_WINDOWS
	#define KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME "KVIrc"
#else
	#define KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME ".kvirc"
#endif

KviSetupPage::KviSetupPage(KviSetupWizard * w)
: QHBox(w)
{
	// we need this to set localized text on buttons (see QT doc/ QWizard class)

	w->QWizard::backButton()->setText(__tr2qs("< &Back"));
	w->QWizard::nextButton()->setText(__tr2qs("&Next >"));
	w->QWizard::finishButton()->setText(__tr2qs("Finish"));
	w->QWizard::cancelButton()->setText(__tr2qs("Cancel"));
	//w->QWizard::helpButton()->setText(__tr2qs("Help"));
     
	setSpacing(8);

	m_pPixmapLabel = new QLabel(this);

	m_pPixmapLabel->setPixmap(*(w->m_pLabelPixmap));
	m_pPixmapLabel->setFixedSize(w->m_pLabelPixmap->size());
	m_pPixmapLabel->setFrameStyle(QFrame::Sunken | QFrame::StyledPanel);
	m_pPixmapLabel->setMargin(0);

	m_pVBox = new QVBox(this);
	m_pVBox->setSpacing(8);

	QLabel * l = new QLabel(m_pVBox);
	l->setAlignment(Qt::AlignAuto | Qt::AlignTop);
	QString szHeader = "<table width=\"100%\"><tr><td bgcolor=\"#303030\">" \
			"<h1><font color=\"#FFFFFF\">KVIrc " KVI_VERSION "</font></h1>" \
			"</td></tr></table>";
	l->setText(szHeader);

	m_pTextLabel = new QLabel(m_pVBox);
	m_pTextLabel->setAlignment(Qt::AlignJustify | Qt::AlignVCenter);
	m_pVBox->setStretchFactor(m_pTextLabel,1);
}

KviSetupPage::~KviSetupPage()
{
}


KviSetupWizard::KviSetupWizard()
: QWizard(0,0,true)
{
	QString szLabelText;

	KviStr szImagePath;
	g_pApp->getGlobalKvircDirectory(szImagePath,KviApp::Pics,"kvi_setup_label.png");

	m_pLabelPixmap = new QPixmap(szImagePath.ptr());
	if(m_pLabelPixmap->isNull())
	{
		delete m_pLabelPixmap;
		m_pLabelPixmap = new QPixmap(180,400);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Welcome

	m_pWelcome = new KviSetupPage(this);

	// here we go...
	QString szText  = __tr2qs("<p>" \
			"<h2>Welcome :)</h2>" \
			"This is your first time running this version of KVIrc.<br>" \
			"This wizard will guide you through the few steps " \
			"required to complete the setup.<br><br>" \
			"If you had a previous version of KVIrc installed, no worries. You will " \
			"have a chance to preserve the old configuration." \
			"</p>" \
			"<p>Click \"<b>Next</b>\" to proceed.</p>");

	m_pWelcome->m_pTextLabel->setText(szText);

	addPage(m_pWelcome,__tr2qs("Welcome to KVIrc"));

	setBackEnabled(m_pWelcome,false);
	setHelpEnabled(m_pWelcome,false);



	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// License
#ifndef COMPILE_ON_WINDOWS //it have been already shown by installer
	KviSetupPage * m_pLicense = new KviSetupPage(this);
	m_pLicense->m_pTextLabel->setText(__tr2qs( \
			"<p>All of the files in this distribution are covered by the GPL. " \
			"In human terms this can be read as follows:<br>" \
			"<ul>" \
			"<li><b>KVIrc is free</b>, use it, have fun! <b>:)</b></li>" \
			"<li>If you use <b>any</b> part of KVIrc in your own project, you <b>must</b> release that project under the same license.</li>" \
			"</ul></p>" \
			"<p>The \"legalese\" version of the license is shown in the box below.</p>"));

	QTextEdit * ed = new QTextEdit(m_pLicense->m_pVBox);
	ed->setReadOnly(true);
	ed->setWordWrap(QTextEdit::NoWrap);
	KviStr szLicense;
	KviStr szLicensePath;
	g_pApp->getGlobalKvircDirectory(szLicensePath,KviApp::License,"COPYING");
	QString buf;
	if(!KviFileUtils::loadFile(szLicensePath.ptr(),buf))
	{
		szLicense = __tr("Oops... can't find the license file.\n" \
						"It MUST be included in the distribution...\n" \
						"Please report to <pragma at kvirc dot net>");
	}
	szLicense=buf;
	ed->setText(szLicense.ptr());
	
	m_pLicense->m_pVBox->setStretchFactor(ed,1);

	addPage(m_pLicense,__tr2qs("Dreaded License Agreement"));

	setHelpEnabled(m_pLicense,false);

	setCaption(__tr2qs("KVIrc Setup"));
#else
	m_pLicense = 0;
#endif
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Identity

	m_pIdentity = new KviSetupPage(this);

	m_pIdentity->m_pTextLabel->setText(__tr2qs("Please choose a Nickname.<br><br>" \
		"Your nickname is the name that other IRC users will know you by. " \
		"It can't contain spaces or punctuation. Some IRC networks will shorten your nickname if it is more than 32 characters " \
		"long.<br><br>"
		"If in doubt, just enter the first nick that comes to mind. " \
		"You will be able to change it later in the Identity properties, or with the /NICK command."));

	QHBox * hbbb = new QHBox(m_pIdentity->m_pVBox);

	QLabel * l = new QLabel(hbbb);
	l->setText(__tr2qs("<b>Nickname:</b>"));

	m_pNickEdit = new QLineEdit(hbbb);
	QValidator * v = new QRegExpValidator(QRegExp("[^-0-9 ][^ ]*"),hbbb);
	m_pNickEdit->setValidator(v);
	
	QString nick;
	char * nnn = kvi_getenv("USER");
	if(nnn)nick = nnn;
	else nick = "newbie";
	if(nick.isEmpty())nick = "newbie";
	if(nick == "root")nick = "newbie";

	m_pNickEdit->setText(nick);

	addPage(m_pIdentity,__tr2qs("Identity"));

	l = new QLabel(m_pIdentity->m_pVBox,"<b> </b>");

	setHelpEnabled(m_pIdentity,false);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Directories

	m_pDirectory = new KviSetupPage(this);


	m_pDirectory->m_pTextLabel->setText(__tr2qs("<p>Please choose a folder for " \
		"KVIrc to store its settings and other data, and another for downloaded files. " \
		"Make sure that you have permission to write to both folders.<br><br>" \
		"The suggested locations are fine in most cases, so if you don't know what " \
		"is this about, just click \"<b>Next</b>\".<br><br>" \
		"If you had a previous version of KVIrc installed, you can choose " \
		"the existing directory for the settings, and your configuration " \
		"will be preserved." \
		"</p>"));

	addPage(m_pDirectory,__tr2qs("Application Folders"));

	QString tmp;

	l = new QLabel(m_pDirectory->m_pVBox);
	l->setText(__tr2qs("<b>Store configuration in folder:</b>"));

	QHBox * hb = new QHBox(m_pDirectory->m_pVBox);

	m_pDataPathEdit = new QLineEdit(hb);

	QPushButton * pb = new QPushButton(__tr2qs("&Browse..."),hb);
	connect(pb,SIGNAL(clicked()),this,SLOT(chooseDataPath()));

	hb->setSpacing(3);
	hb->setStretchFactor(m_pDataPathEdit,1);

#ifdef COMPILE_ON_WINDOWS
	tmp = QTextCodec::codecForLocale()->toUnicode(getenv( "APPDATA" ));
	if(tmp.isEmpty())
		tmp = QDir::homeDirPath();
#else 
	tmp = QDir::homeDirPath();
#endif //COMPILE_ON_WINDOWS
	KviQString::ensureLastCharIs(tmp,KVI_PATH_SEPARATOR_CHAR);
	tmp.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
	KviFileUtils::adjustFilePath(tmp);
	m_pDataPathEdit->setText(tmp);



	l = new QLabel(m_pDirectory->m_pVBox);
	l->setText(__tr2qs("<b>Download files to folder:</b>"));


	hb = new QHBox(m_pDirectory->m_pVBox);

	m_pIncomingPathEdit = new QLineEdit(hb);

	pb = new QPushButton(__tr2qs("&Browse..."),hb);
	connect(pb,SIGNAL(clicked()),this,SLOT(chooseIncomingPath()));

	hb->setSpacing(3);
	hb->setStretchFactor(m_pIncomingPathEdit,1);

	tmp = QDir::homeDirPath();
	KviQString::ensureLastCharIs(tmp,KVI_PATH_SEPARATOR_CHAR);
	tmp.append(KVI_DEFAULT_INCOMING_SUBDIRECTORY_NAME);
	KviFileUtils::adjustFilePath(tmp);
	m_pIncomingPathEdit->setText(tmp);

	l = new QLabel(m_pDirectory->m_pVBox,"<b> </b>");

	m_pDirectory->m_pVBox->setStretchFactor(m_pDirectory->m_pTextLabel,1);

	setHelpEnabled(m_pDirectory,false);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Default theme
	m_pTheme = new KviSetupPage(this);
	m_pTheme->m_pTextLabel->setText(__tr2qs( \
		"<p>Here you can choose the default appearance of KVIrc.<br><br>" \
		"The Fancy Theme uses icons, a transparent background and a lot of colors. " \
		"The Minimalist Theme is designed for low-color displays " \
		"or for \"console\" extremists; it's more or less white text on a black background.<br><br>" \
		"If you had a previous version of KVIrc installed, you can choose to not apply any theme " \
		"in order to preserve your current visual settings.<br><br>" \
		"If you don't know what to choose, just use the default.</p>"));

	m_pThemeButtonGroup = new QVButtonGroup(m_pTheme->m_pVBox);
	
	QHBox* pThemesHb = new QHBox(m_pThemeButtonGroup);

	QVBox* pThemesVb = new QVBox(pThemesHb);
	
	QString szThemeImagePath;
	g_pApp->getGlobalKvircDirectory(szThemeImagePath,KviApp::Pics,"kvi_setup_theme_hires.png");
	
	QPixmap* pHiResPixmap = new QPixmap(szThemeImagePath);
	if(pHiResPixmap->isNull())
	{
		delete pHiResPixmap;
		pHiResPixmap= new QPixmap(250,200);
	}
	
	QLabel* pPixmapLabelHiRes = new QLabel(pThemesVb);

	pPixmapLabelHiRes->setPixmap(*pHiResPixmap);
	pPixmapLabelHiRes->setFixedSize(pHiResPixmap->size());
	pPixmapLabelHiRes->setFrameStyle(QFrame::Sunken | QFrame::StyledPanel);
	pPixmapLabelHiRes->setMargin(0);
	
	m_pThemeHiRes = new QRadioButton(__tr2qs("&Fancy Theme"),pThemesVb);
	
	pThemesVb = new QVBox(pThemesHb);
	g_pApp->getGlobalKvircDirectory(szThemeImagePath,KviApp::Pics,"kvi_setup_theme_lowres.png");
	QPixmap* pLowResPixmap = new QPixmap(szThemeImagePath);
	if(pLowResPixmap->isNull())
	{
		delete pLowResPixmap;
		pLowResPixmap= new QPixmap(250,200);
	}
	
	QLabel* pPixmapLabelLowRes = new QLabel(pThemesVb);

	pPixmapLabelLowRes->setPixmap(*pLowResPixmap);
	pPixmapLabelLowRes->setFixedSize(pLowResPixmap->size());
	pPixmapLabelLowRes->setFrameStyle(QFrame::Sunken | QFrame::StyledPanel);
	pPixmapLabelLowRes->setMargin(0);
	
	m_pThemeLoRes  = new QRadioButton(__tr2qs("&Minimalist Theme"),pThemesVb);
	m_pThemeNone = new QRadioButton(__tr2qs("&Don't apply any theme"),m_pThemeButtonGroup);
	m_pThemeButtonGroup->insert(m_pThemeHiRes);
	m_pThemeButtonGroup->insert(m_pThemeLoRes);
	
	m_pThemeHiRes->setChecked(true);

	addPage(m_pTheme,__tr2qs("Default Theme"));

	setHelpEnabled(m_pTheme,false);

#ifdef COMPILE_KDE_SUPPORT
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Link
	m_pLink = new KviSetupPage(this);

	szLabelText = __tr2qs( \
		"<p>Setup can make a shortcut to the KVIrc program on " \
			"your desktop, so you can access it quickly.</p>" \
			"<p>Do you want this shortcut to be created?</p>");

	szLabelText += __tr2qs("<p>If you're unsure just say \"Yes\"</p>");

	m_pLink->m_pTextLabel->setText(szLabelText);

	m_pLinkButtonGroup = new QVButtonGroup(m_pLink->m_pVBox);

	m_pLinkYes = new QRadioButton(__tr2qs("&Yes"),m_pLinkButtonGroup);
	m_pLinkNo  = new QRadioButton(__tr2qs("&No"),m_pLinkButtonGroup);
	
	m_pLinkYes->setChecked(true);

	addPage(m_pLink,__tr2qs("Desktop Shortcut"));

	setHelpEnabled(m_pLink,false);
#else
	m_pLink = 0;
#endif

#ifdef COMPILE_ON_WINDOWS
	m_pUrlHandlers = new KviSetupPage(this);

	szLabelText = __tr2qs( \
			"<p>Setup can now set KVIrc as default application " \
			"for the irc:// and irc6:// urls.</p>" \
			"<p>Do you want these settings to be applied?</p>");

	szLabelText += __tr2qs("<p>If you're unsure just say \"Yes\"</p>");

	m_pUrlHandlers->m_pTextLabel->setText(szLabelText);

	m_pUrlHandlersButtonGroup = new QVButtonGroup(m_pUrlHandlers->m_pVBox);

	m_pUrlHandlersYes = new QRadioButton(__tr2qs("&Yes"),m_pUrlHandlersButtonGroup);
	m_pUrlHandlersNo  = new QRadioButton(__tr2qs("&No"),m_pUrlHandlersButtonGroup);
	
	m_pUrlHandlersYes->setChecked(true);

	addPage(m_pUrlHandlers,__tr2qs("URL Handlers"));

	setHelpEnabled(m_pUrlHandlers,false);
#else
	m_pUrlHandlers = 0;
#endif

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Finish
	m_pFinish = new KviSetupPage(this);

	m_pFinish->m_pTextLabel->setText(__tr2qs( \
			"<p><h2>Setup Complete</h2>" \
			"Setup now has all the necessary information to configure KVIrc.</p>" \
			"<p>Please click the \"<b>Finish</b>\" button to save your choices and start KVIrc.</p>"));

	addPage(m_pFinish,__tr2qs("Finish Setup"));

	setFinishEnabled(m_pFinish,true);
	setHelpEnabled(m_pFinish,false);
}


KviSetupWizard::~KviSetupWizard()
{
	delete m_pLabelPixmap;
}


void KviSetupWizard::chooseDataPath()
{
	QString szBuffer = KviTalFileDialog::getExistingDirectoryPath(m_pDataPathEdit->text(),__tr2qs("Choose a Configuration Folder - KVIrc Setup"),0);
	if(!szBuffer.isEmpty())
	{
		KviQString::ensureLastCharIs(szBuffer,KVI_PATH_SEPARATOR_CHAR);
		szBuffer.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
		m_pDataPathEdit->setText(szBuffer);
	}
}

void KviSetupWizard::chooseIncomingPath()
{
	//QString szBuffer = QFileDialog::getExistingDirectory(m_pIncomingPathEdit->text(),0,0,__tr2qs("Choose the download folder"));
	QString szBuffer = KviTalFileDialog::getExistingDirectoryPath(m_pIncomingPathEdit->text(),__tr2qs("Choose a Download Folder - KVIrc Setup"),0);
	if(!szBuffer.isEmpty())
	{
		m_pIncomingPathEdit->setText(szBuffer);
	}
}

/*
void KviSetupWizard::directorySelected(const QString &szDir)
{
	KviStr szDirectory = szDir;
	kvi_adjustFilePath(szDirectory);
	szDirectory.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	szDirectory.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
	szDirectory.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	kvi_adjustFilePath(szDirectory);
	m_pDirectoryEdit->setText(szDirectory.ptr());
}
*/

void KviSetupWizard::makeLink()
{
#ifdef COMPILE_ON_WINDOWS
	// Let's make a link on the desktop :)
	// You need this horrible snippet of code to create a shortcut!!!!
	//
	// you have to:
	// - dig in the registry , 
	// - trigger the entire COM subsystem
	// - bring up a couple of OLE interfaces....
	// - use some obscure functions like MultiByteToWideChar
	// - and the finally drop the entire OLE+COM interface in the garbadge
	// ...
	// Isn't this horrible ? (compared to symlink()!)
	//

	// Well..let's go (please note that we don't handle most possible errors!
	// otherwise there would be 150 lines for a stupid symlink!)

	HKEY hCU;
    DWORD lpType;
    ULONG ulSize = MAX_PATH;
	char szLink[MAX_PATH];

	// Dig in the registry looking up the Desktop path
    if(RegOpenKeyEx(HKEY_CURRENT_USER,
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", 
		0,KEY_QUERY_VALUE,&hCU) == ERROR_SUCCESS)
	{
		RegQueryValueEx(hCU,"Desktop",NULL,&lpType,
        (unsigned char *)&szLink,&ulSize);
		RegCloseKey(hCU);
    }

	// Build our paths
	QString szLinkTarget = szLink;
	szLinkTarget.append("\\kvirc.lnk");

	QString szKvircExec = g_pApp->m_szGlobalKvircDir;
	szKvircExec.append("\\kvirc.exe");

	// Trigger a horrible machinery
	CoInitialize(NULL); // we need COM+OLE

	// Fiddle with an obscure shell interface
	IShellLink* psl;

    // Get a pointer to the IShellLink interface: this is kinda ugly :)
    if(CoCreateInstance(CLSID_ShellLink,NULL,CLSCTX_INPROC_SERVER,
				IID_IShellLink,(void **)&psl) == S_OK)
	{
		// just for fun , lookup another shell interface

		IPersistFile* ppf;

		// Query IShellLink for the IPersistFile interface for 
		// saving the shell link in persistent storage.
		if(psl->QueryInterface(IID_IPersistFile,(void **)&ppf) == S_OK)
		{
			WORD wsz[MAX_PATH];
			// Set the path to the shell link target.
			psl->SetPath(QTextCodec::codecForLocale()->fromUnicode(szKvircExec).data());
			// Set the description of the shell link.
			psl->SetDescription("kvirc");
	        // Ensure string is ANSI.
			MultiByteToWideChar(CP_ACP,0,QTextCodec::codecForLocale()->fromUnicode(szLinkTarget).data(),-1,(LPWSTR)wsz,MAX_PATH);
			// Save the link via the IPersistFile::Save method.
			ppf->Save((LPCOLESTR)wsz,true);    
			ppf->Release();
		}
		psl->Release();
	}
	// And throw OLE & Co. in the garbadge
	CoUninitialize();
#endif //COMPILE_ON_WINDOWS

#ifdef COMPILE_KDE_SUPPORT
	QString tmp = QDir::homeDirPath();
	KviQString::ensureLastCharIs(tmp,KVI_PATH_SEPARATOR_CHAR);
	tmp.append("Desktop");
	KviQString::ensureLastCharIs(tmp,KVI_PATH_SEPARATOR_CHAR);
	tmp.append("kvirc.desktop");

	QString contents = "[Desktop Entry]\n" \
		"GenericName=IRC Client\n" \
		"Comment=Connect to Internet Relay Chat\n" \
		"Exec=kvirc -m %u\n" \
		"Icon=kvirc\n" \
		"MapNotify=true\n" \
		"Name=KVIrc 3\n" \
		"Terminal=false\n" \
		"Type=Application\n" \
		"X-KDE-SubstituteUID=false\n";

	KviFileUtils::writeFile(tmp,contents,false);
#endif //COMPILE_KDE_SUPPORT

}

void KviSetupWizard::setUrlHandlers()
{
#ifdef COMPILE_ON_WINDOWS
	QString szReg = "REGEDIT4\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc]\r\n" \
		"@=\"URL:IRC Protocol\"\r\n" \
		"\"IRC Protocol\"=\"http://www.kvirc.net/\"\r\n" \
		"\"EditFlags\"=hex:02,00,00,00\r\n" \
		"\"URL Protocol\"=""\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc\\DefaultIcon]\r\n" \
		"@=\"\\\"@KVIRCEXECUTABLE@\\\"\"\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc\\shell]\r\n" \
		"@=\"\"\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc\\shell\\open]\r\n" \
		"\"EditFlags\"=hex:01,00,00,00\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc\\shell\\open\\command]\r\n" \
		"@=\"\\\"@KVIRCEXECUTABLE@\\\" %1\"\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc6]\r\n" \
		"@=\"URL:IRC6 Protocol\"\r\n" \
		"\"IRC6 Protocol\"=\"http://www.kvirc.net/\"\r\n" \
		"\"EditFlags\"=hex:02,00,00,00\r\n" \
		"\"URL Protocol\"=""\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc6\\DefaultIcon]\r\n" \
		"@=\"\\\"@KVIRCEXECUTABLE@\\\"\"\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc6\\shell]\r\n" \
		"@=\"\"\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc6\\shell\\open]\r\n" \
		"\"EditFlags\"=hex:01,00,00,00\r\n" \
		"\r\n" \
		"[HKEY_CLASSES_ROOT\\irc6\\shell\\open\\command]\r\n" \
		"@=\"\\\"@KVIRCEXECUTABLE@\\\" %1\"\r\n";

	QString szKvircExec = g_pApp->m_szGlobalKvircDir;
	szKvircExec.append("\\kvirc.exe");
	szKvircExec.replace("\\","\\\\");

	szReg.replace("@KVIRCEXECUTABLE@",QTextCodec::codecForLocale()->fromUnicode(szKvircExec));

	QString szRegFile = g_pApp->m_szGlobalKvircDir;
	szRegFile.append("\\kvirc.reg");

	KviFileUtils::writeFile(szRegFile,szReg,false);

	QString szCmd = "regedit /S \"";
	szCmd += szRegFile;
	szCmd += "\"";

	WinExec(QTextCodec::codecForLocale()->fromUnicode(szCmd).data(),SW_SHOW);
#endif
}

void KviSetupWizard::reject()
{
	if(QMessageBox::warning(this,__tr2qs("Abort Setup - KVIrc Setup"),
		__tr2qs("You have chosen to abort the setup.<br>KVIrc cannot run until you complete this procedure.<br><br>Do you really wish to abort?"),
		QMessageBox::Yes,QMessageBox::No|QMessageBox::Default|QMessageBox::Escape) != QMessageBox::Yes)return;

	QWizard::reject();
}

void KviSetupWizard::accept()
{
	QString szDir = m_pDataPathEdit->text();
	KviFileUtils::adjustFilePath(szDir);
	if(!KviFileUtils::directoryExists(szDir))
	{
		if(!KviFileUtils::makeDir(szDir))
		{
			KviMessageBox::warning(__tr("Cannot create directory %s.\n" \
				"You may not have write permission " \
				"for that path. Please go back and choose another directory."));
			showPage(m_pDirectory);
			return;
		}
	} /*else {
		kvi_infoBox(__tr("Kvirc setup"),
			__tr("The directory '%s' already exists.\n" \
			"(maybe from a previous Kvirc installation)\n"\
			"If you experience any problems try deleting the old directory:\n" \
			"the setup program will be started automatically again."),szDir.ptr());
	}*/

	g_pApp->m_szLocalKvircDir = szDir;
	KviFileUtils::adjustFilePath(g_pApp->m_szLocalKvircDir);

	szDir = m_pIncomingPathEdit->text();
	KviFileUtils::adjustFilePath(szDir);
	if(!KviFileUtils::directoryExists(szDir))
	{
		if(!KviFileUtils::makeDir(szDir))
		{
			KviMessageBox::warning(__tr("Cannot create directory %s.\n" \
				"You may not have write permission " \
				"for that path. Please go back and choose another directory."));
			showPage(m_pDirectory);
			return;
		}
	}

	g_szChoosenIncomingDirectory = szDir;

#ifndef COMPILE_ON_WINDOWS
	// Make local->global link
	QString localPath = QString("%1/global").arg(g_pApp->m_szLocalKvircDir);
	unlink(QTextCodec::codecForLocale()->fromUnicode(localPath).data());
	symlink(QTextCodec::codecForLocale()->fromUnicode(g_pApp->m_szGlobalKvircDir).data(),QTextCodec::codecForLocale()->fromUnicode(localPath).data());
#endif

	if(m_pLink)
	{
		if(m_pLinkButtonGroup->selected() == m_pLinkYes)
			makeLink();
	}

	if(m_pUrlHandlers)
	{
		if(m_pUrlHandlersButtonGroup->selected() == m_pUrlHandlersYes)
			setUrlHandlers();
	}

	if(m_pTheme)
	{
		if(m_pThemeButtonGroup->selected() == m_pThemeHiRes)
		{
			g_iThemeToApply = THEME_APPLY_HIRES;
		} else if(m_pThemeButtonGroup->selected() == m_pThemeLoRes)
		{
			g_iThemeToApply = THEME_APPLY_LORES;
		} else {
			g_iThemeToApply = THEME_APPLY_NONE;
		}
	}
	
	if(m_pIdentity)
	{
		g_szChoosenDefaultNick = m_pNickEdit->text();
	}

	QWizard::accept();
}

#include "setupwizard.moc"
