// =============================================================================
//
//      --- kvi_optiontables.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionTables"

#define _KVI_OPTIONS_CPP_

#include "kvi_options.h"

/**
 * ============ KviOptions ============
 * Static stuff declarations
 */
KviStr KviOptions::m_szUserName("");
KviStr KviOptions::m_szRealName("");
KviStr KviOptions::m_szNickName1("");
KviStr KviOptions::m_szNickName2("");
KviStr KviOptions::m_szPartMessage("");
KviStr KviOptions::m_szKickMessage("");
KviStr KviOptions::m_szQuitMessage("");
KviStr KviOptions::m_szCaptionMessage("");
KviStr KviOptions::m_szCtcpVersionAppendix("");
KviStr KviOptions::m_szCtcpUserinfoAppendix("");
KviStr KviOptions::m_szCtcpClientinfoAppendix("");
KviStr KviOptions::m_szCtcpSourceAppendix("");
KviStr KviOptions::m_szCtcpFingerReply("");
bool   KviOptions::m_bModeWOnConnect = false;
bool   KviOptions::m_bModeIOnConnect = false;
bool   KviOptions::m_bModeSOnConnect = false;

QColor KviOptions::m_clrMdiCaptionActiveBack  (0, 0, 0);
QColor KviOptions::m_clrMdiCaptionActiveFore  (0, 0, 0);
QColor KviOptions::m_clrMdiCaptionInactiveBack(0, 0, 0);
QColor KviOptions::m_clrMdiCaptionInactiveFore(0, 0, 0);
QColor KviOptions::m_clrMdiBack               (0, 0, 0);
QFont  KviOptions::m_fntMdiCaption(KVI_DEFAULT_FONT);
KviStr KviOptions::m_szMdiBack("");

KviStr KviOptions::m_szLocalHostIp("127.0.0.1");

QColor KviOptions::m_clrListBoxOwner   (0, 0, 0);
QColor KviOptions::m_clrListBoxOp      (0, 0, 0);
QColor KviOptions::m_clrListBoxHalfOp  (0, 0, 0);
QColor KviOptions::m_clrListBoxVoice   (0, 0, 0);
QColor KviOptions::m_clrListBoxUserOp  (0, 0, 0);
QColor KviOptions::m_clrListBoxNormal  (0, 0, 0);
QColor KviOptions::m_clrListBoxSeleBack(0, 0, 0);
QColor KviOptions::m_clrListBoxSeleFore(0, 0, 0);
QColor KviOptions::m_clrListBoxBack    (0, 0, 0);
QFont  KviOptions::m_fntListBox(KVI_DEFAULT_FONT);
KviStr KviOptions::m_szListBoxBack("");
bool   KviOptions::m_bListBoxShowImages = false;

QColor KviOptions::m_clrInputBack    (0, 0, 0);
QColor KviOptions::m_clrInputFore    (0, 0, 0);
QColor KviOptions::m_clrInputSeleBack(0, 0, 0);
QColor KviOptions::m_clrInputSeleFore(0, 0, 0);
QColor KviOptions::m_clrInputCursor  (0, 0, 0);
QFont  KviOptions::m_fntInput(KVI_DEFAULT_FONT);
KviStr KviOptions::m_szInputBack("");

KviStr KviOptions::m_szLabelsBack("");
QColor KviOptions::m_clrLabelsBack        (0, 0, 0);
QColor KviOptions::m_clrLabelsActiveFore  (0, 0, 0);
QColor KviOptions::m_clrLabelsInactiveFore(0, 0, 0);
QFont  KviOptions::m_fntLabels            (0, 0, 0);

QColor KviOptions::m_clrHelpBack    (0, 0, 0);
QColor KviOptions::m_clrHelpFore    (0, 0, 0);
QColor KviOptions::m_clrHelpTitle   (0, 0, 0);
QColor KviOptions::m_clrHelpSubtitle(0, 0, 0);
QColor KviOptions::m_clrHelpExample (0, 0, 0);
QFont  KviOptions::m_fntHelpNormal(KVI_DEFAULT_FONT);
QFont  KviOptions::m_fntHelpFixed(KVI_DEFAULT_FIXED_FONT);

QFont  KviOptions::m_fntSysTray(KVI_DEFAULT_FONT);
QColor KviOptions::m_clrSysTrayBack(0, 0, 0);
QColor KviOptions::m_clrSysTrayFore(0, 0, 0);

KviStr KviOptions::m_szViewBack("");
QColor KviOptions::m_clrViewBack(0, 0, 0);
QFont  KviOptions::m_fntView(KVI_DEFAULT_FONT);
bool   KviOptions::m_bShowImages = false;
bool   KviOptions::m_bWrapMargin = false;
bool   KviOptions::m_bTimestamp  = false;

bool   KviOptions::m_bSetGlobalPaletteAtStartup = false;
QColor KviOptions::m_clrNormalGlobalForeground  (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalButton      (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalLight       (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalDark        (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalMid         (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalText        (0, 0, 0);
QColor KviOptions::m_clrNormalGlobalBase        (0, 0, 0);
QColor KviOptions::m_clrDisabledGlobalForeground(0, 0, 0);
QColor KviOptions::m_clrDisabledGlobalText      (0, 0, 0);
QColor KviOptions::m_clrDisabledGlobalBase      (0, 0, 0);

QFont  KviOptions::m_fntApplication(KVI_DEFAULT_FONT);
KviStr KviOptions::m_szApplicationGUIStyle("default");
QColor *KviOptions::m_pMircColor[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

bool KviOptions::m_bUseBigToolbarPixmaps      = false;
bool KviOptions::m_bUseBigUserToolbarPixmaps  = false;
bool KviOptions::m_bUseTextToolbarComment     = false;
bool KviOptions::m_bUseThemeMenubarBackground = false;

bool KviOptions::m_bMdiOpaqueMove   = false;
bool KviOptions::m_bMdiOpaqueResize = false;

KviStr KviOptions::m_szLastScriptPath("");

bool KviOptions::m_bRejoinChannelsOnReconnect = false;

unsigned char KviOptions::m_cViewOutSeleBack = 0;
unsigned char KviOptions::m_cViewOutSeleFore = 0;
unsigned char KviOptions::m_cViewOutUrlFore  = 0;
unsigned char KviOptions::m_cViewOutTypeBack[KVI_OUT_NUM_IMAGES] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0
};

unsigned char KviOptions::m_cViewOutTypeFore[KVI_OUT_NUM_IMAGES] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0
};

bool KviOptions::m_bJoinMsgsToConsole                 = 0;
bool KviOptions::m_bPartMsgsToConsole                 = 0;
bool KviOptions::m_bKickMsgsToConsole                 = 0;
bool KviOptions::m_bQuitMsgsToConsole                 = 0;
bool KviOptions::m_bNickMsgsToConsole                 = 0;
bool KviOptions::m_bTopicMsgsToConsole                = 0;
bool KviOptions::m_bDesyncMsgsToConsole               = 0;
bool KviOptions::m_bServerInfoToConsole               = 0;
bool KviOptions::m_bSplitWarningsToConsole            = 0;
bool KviOptions::m_bUnhandledServerErrorsToConsole    = 0;
bool KviOptions::m_bUnhandledNumericsToConsole        = 0;
bool KviOptions::m_bUnhandledLiteralsToConsole        = 0;
bool KviOptions::m_bNicknameErrorsToConsole           = 0;
bool KviOptions::m_bNamesReplyToConsole               = 0;
bool KviOptions::m_bWallopsToConsole                  = 0;
bool KviOptions::m_bUserModeChangesToConsole          = 0;
bool KviOptions::m_bChannelModeChangesToConsole       = 0;
bool KviOptions::m_bWhoMsgsToConsole                  = 0;
bool KviOptions::m_bBanAndExceptionListToConsole      = 0;
bool KviOptions::m_bServerNoticesToConsole            = 0;
bool KviOptions::m_bWhoisRepliesToConsole             = 0;
bool KviOptions::m_bDnsResultsToConsole               = 0;
bool KviOptions::m_bInviteMessagesToConsole           = 0;
bool KviOptions::m_bNotifyListChangesToConsole        = 0;
bool KviOptions::m_bProcessOutputToConsole            = 0;
bool KviOptions::m_bOffChannelNoticesToConsole        = 0;
bool KviOptions::m_bCtcpRequestsToConsole             = 0;
bool KviOptions::m_bChannelCtcpRequestsToConsole      = 0;
bool KviOptions::m_bCtcpRepliesToConsole              = 0;
bool KviOptions::m_bCtcpFloodWarningsToConsole        = 0;
bool KviOptions::m_bReplyErrmsgOnUnknownCtcp          = 0;
bool KviOptions::m_bIgnoreCtcpPingRequests            = 0;
bool KviOptions::m_bIgnoreCtcpVersionRequests         = 0;
bool KviOptions::m_bIgnoreCtcpTimeRequests            = 0;
bool KviOptions::m_bIgnoreCtcpUserinfoRequests        = 0;
bool KviOptions::m_bIgnoreCtcpClientinfoRequests      = 0;
bool KviOptions::m_bIgnoreCtcpSourceRequests          = 0;
bool KviOptions::m_bIgnoreCtcpFingerRequests          = 0;
bool KviOptions::m_bUseAntiCtcpFlood                  = 0;
bool KviOptions::m_bAppendRealUsernameToUserinfoReply = 0;
bool KviOptions::m_bAppendUnameToClientinfoReply      = 0;
int KviOptions::m_iMaxCtcpCount                       = 0;
int KviOptions::m_iMaxCtcpTime                        = 0;
bool KviOptions::m_bShowPingPong                      = 0;
bool KviOptions::m_bShowOwnParts                      = 0;
bool KviOptions::m_bShowOwnNickChanges                = 0;
bool KviOptions::m_bSkipMotd                          = 0;
bool KviOptions::m_bBrutalQuit                        = 0;
bool KviOptions::m_bAutoRejoinOnKick                  = 0;
bool KviOptions::m_bDumpChannelOnKick                 = 0;
bool KviOptions::m_bRequestBanExceptionListOnJoin     = 0;
bool KviOptions::m_bRequestWhoAfterEndOfNames         = 0;
bool KviOptions::m_bShowInternalWhoMessages           = 0;
bool KviOptions::m_bShowBanAndExceptionList           = 0;
bool KviOptions::m_bCreateQueryOnPrivmsg              = 0;
bool KviOptions::m_bCreateQueryOnNotice               = 0;
bool KviOptions::m_bCreateIconifiedQuery              = 0;
bool KviOptions::m_bUseSmallAntispamOnPrivmsg         = 0;
bool KviOptions::m_bUseAntiQueryFlood                 = 0;
bool KviOptions::m_bQueryFloodWarningsToConsole       = 0;
int KviOptions::m_iMaxTotalQueries                    = 0;
int KviOptions::m_iMaxQueryCount                      = 0;
int KviOptions::m_iMaxQueryTime                       = 0;
bool KviOptions::m_bUrlHighlighting                   = 0;
bool KviOptions::m_bUseKsircControlCodes              = 0;
bool KviOptions::m_bAutoJoinChanOnInvite              = 0;
bool KviOptions::m_bShowExtendedServerInfo            = 0;
bool KviOptions::m_bPrivmsgFormatNickIsALink          = 0;
bool KviOptions::m_bUseExtendedPrivmsgView            = 0;
bool KviOptions::m_bEnableNickModePrefix              = 0;
bool KviOptions::m_bShowUserAndHostInPrivmsgs         = 0;
bool KviOptions::m_bUseStringSubstitution             = 0;
bool KviOptions::m_bUseUserDefinedIpForDccRequests    = 0;
int KviOptions::m_iOnIdleAfter                        = 60;
KviStr KviOptions::m_szPrivmsgFormatNickLinkCommand("");
KviStr KviOptions::m_szExtPrivmsgPrefix("");
KviStr KviOptions::m_szExtPrivmsgPostfix("");
KviStr KviOptions::m_szLocalIncomingDirectory("");
KviStr KviOptions::m_szSoundDevice("");
KviStr KviOptions::m_szDccLocalIpAddress("");

/**
 * Table of user options
 */
KviOptionEntry KviOptions::optBoolTable[] =
{
	{
		"bJoinMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bJoinMsgsToConsole)
	}, {
		"bPartMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bPartMsgsToConsole)
	}, {
		"bKickMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bKickMsgsToConsole)
	}, {
		"bQuitMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bQuitMsgsToConsole)
	}, {
		"bNickMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bNickMsgsToConsole)
	}, {
		"bTopicMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bTopicMsgsToConsole)
	}, {
		"bDesyncMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bDesyncMsgsToConsole)
	}, {
		"bServerInfoToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bServerInfoToConsole)
	}, {
		"bSplitWarningsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bSplitWarningsToConsole)
	}, {
		"bUnhandledServerErrorsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bUnhandledServerErrorsToConsole)
	}, {
		"bUnhandledNumericsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bUnhandledNumericsToConsole)
	}, {
		"bUnhandledLiteralsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bUnhandledLiteralsToConsole)
	}, {
		"bNicknameErrorsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bNicknameErrorsToConsole)
	}, {
		"bNamesReplyToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bNamesReplyToConsole)
	}, {
		"bUserModeChangesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bUserModeChangesToConsole)
	}, {
		"bChannelModeChangesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bChannelModeChangesToConsole)
	}, {
		"bWhoMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bWhoMsgsToConsole)
	}, { // @opt: True if ban and exception list replies should be redirected to the console window
		"bBanAndExceptionListToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bBanAndExceptionListToConsole)
	}, { // @opt: True if server notices should be redirected to the console window
		"bServerNoticesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bServerNoticesToConsole)
	}, { // @opt: True if /WHOIS reply messages should be redirected to the console window
		"bWhoisRepliesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bWhoisRepliesToConsole)
	}, { // @opt: True if the /DNS result messages should be redirected to the console window
		"bDnsResultsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bDnsResultsToConsole)
	}, {
		"bWallopsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bWallopsToConsole)
	}, { // @opt: True if the /INVITE messages should be redirected to the console window
		"bInviteMsgsToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bInviteMessagesToConsole)
	}, { // @opt: True if the notify list changes should be redirected to the console window
		"bNotifyListChangesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bNotifyListChangesToConsole)
	}, { // @opt: True if the external processes output should be redirected to the console window
		"bProcessOutputToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR,
		(void *) &(KviOptions::m_bProcessOutputToConsole)
	}, { // @opt: True if the notices from off-channel users should be redirected to the console window
		"bOffChannelNoticesToConsole",
		KVI_OPT_BOOL | KVI_OPT_REDIR, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bOffChannelNoticesToConsole)
	}, { // @opt: True if the CTCP request notifications should be redirected to the console window
		"bCtcpRequestsToConsole",
		KVI_OPT_BOOL | KVI_OPT_CTCP, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bCtcpRequestsToConsole)
	}, { // @opt: True if channel CTCP request notifications should be redirected to the console window
		"bChannelCtcpRequestsToConsole",
		KVI_OPT_BOOL | KVI_OPT_CTCP, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bChannelCtcpRequestsToConsole)
	}, { // @opt: True if the CTCP replies should be redirected to the console window
		"bCtcpRepliesToConsole",
		KVI_OPT_BOOL | KVI_OPT_CTCP, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bCtcpRepliesToConsole)
	}, { // @opt: True if the flood warning messages should be redirected to the console window
		"bCtcpFloodWarningsToConsole",
		KVI_OPT_BOOL | KVI_OPT_CTCP, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bCtcpFloodWarningsToConsole)
	}, {
		"bReplyErrmsgOnUnknownCtcp",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bReplyErrmsgOnUnknownCtcp)
	}, {
		"bIgnoreCtcpPingRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpPingRequests)
	}, {
		"bIgnoreCtcpVersionRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpVersionRequests)
	}, {
		"bIgnoreCtcpTimeRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpTimeRequests)
	}, {
		"bIgnoreCtcpUserinforequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpUserinfoRequests)
	}, {
		"bIgnoreCtcpClientinfoRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpClientinfoRequests)
	}, {
		"bIgnoreCtcpSourceRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpSourceRequests)
	}, {
		"bIgnoreCtcpFingerRequests",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bIgnoreCtcpFingerRequests)
	}, {
		"bUseAntiCtcpFlood",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bUseAntiCtcpFlood)
	}, {
		"bAppendRealUsernameToUserinfoReply",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bAppendRealUsernameToUserinfoReply)
	}, {
		"bAppendUnameToClientinfoReply",
		KVI_OPT_BOOL | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_bAppendUnameToClientinfoReply)
	}, {
		"bModeWOnConnect",
		KVI_OPT_BOOL,
		(void *) &(KviOptions::m_bModeWOnConnect)
	}, {
		"bModeIOnConnect",
		KVI_OPT_BOOL,
		(void *) &(KviOptions::m_bModeIOnConnect)
	}, {
		"bModeSOnConnect",
		KVI_OPT_BOOL,
		(void *) &(KviOptions::m_bModeSOnConnect)
	}, {
		"bMdiOpaqueMove",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bMdiOpaqueMove)
	}, {
		"bMdiOpaqueResize",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bMdiOpaqueResize)
	}, {
		"bListBoxShowImages",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bListBoxShowImages)
	}, {
		"bShowImages",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bShowImages)
	}, {
		"bWrapMargin",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bWrapMargin)
	}, {
		"bTimestamp",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bTimestamp)
	}, {
		"bSetGlobalPaletteAtStartup",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bSetGlobalPaletteAtStartup)
	}, {
		"bUseBigToolbarPixmaps",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bUseBigToolbarPixmaps)
	}, {
		"bUseBigUserToolbarPixmaps",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bUseBigUserToolbarPixmaps)
	}, {
		"bUseTextToolbarComment",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bUseTextToolbarComment)
	}, {
		"bUseThemeMenubarBackground",
		KVI_OPT_BOOL | KVI_OPT_GUI,
		(void *) &(KviOptions::m_bUseThemeMenubarBackground)
	}, {
		"bShowPingPong",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowPingPong)
	}, {
		"bShowOwnParts",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowOwnParts)
	}, {
		"bShowOwnNickChanges",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowOwnNickChanges)
	}, {
		"bSkipMotd",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bSkipMotd)
	}, {
		"bBrutalQuit",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bBrutalQuit)
	}, {
		"bAutoRejoinOnKick",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bAutoRejoinOnKick)
	}, {
		"bDumpChannelOnKick",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bDumpChannelOnKick)
	}, {
		"bRequestBanExceptionListOnJoin",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bRequestBanExceptionListOnJoin)
	}, {
		"bRequestWhoAfterEndOfNames",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bRequestWhoAfterEndOfNames)
	}, {
		"bShowInternalWhoMessages",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowInternalWhoMessages)
	}, {
		"bShowBanAndExceptionList",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowBanAndExceptionList)
	}, {
		"bCreateQueryOnPrivmsg",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bCreateQueryOnPrivmsg)
	}, {
		"bCreateQueryOnNotice",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bCreateQueryOnNotice)
	}, {
		"bCreateIconifiedQuery",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bCreateIconifiedQuery)
	}, {
		"bUseSmallAntispamOnPrivmsg",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bUseSmallAntispamOnPrivmsg)
	}, {
		"bUseAntiQueryFlood",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bUseAntiQueryFlood)
	}, {
		"bQueryFloodWarningsToConsole",
		KVI_OPT_BOOL | KVI_OPT_IRCENG, // TODO: KVI_OPT_REDIR?
		(void *) &(KviOptions::m_bQueryFloodWarningsToConsole)
	}, {
		"bUrlHighlighting",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bUrlHighlighting)
	}, {
		"bAutoJoinChanOnInvite",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bAutoJoinChanOnInvite)
	}, {
		"bShowExtendedServerInfo",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_bShowExtendedServerInfo)
	}, {
		"bUseExtendedPrivmsgView",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(m_bUseExtendedPrivmsgView)
	}, {
		"bShowUserAndHostInPrivmsgs",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(m_bShowUserAndHostInPrivmsgs)
	}, {
		"bUseStringSubstitution",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(m_bUseStringSubstitution)
	}, {
		"bUseUserDefinedIpForDccRequests",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(m_bUseUserDefinedIpForDccRequests)
	}, {
		"bRejoinChannelsOnReconnect",
		KVI_OPT_BOOL | KVI_OPT_IRCENG,
		(void *) &(m_bRejoinChannelsOnReconnect)
	}, {
		0, 0, 0
	}
};

KviOptionEntry KviOptions::optIntTable[] =
{
	{
		"iMaxCtcpCount",
		KVI_OPT_INT | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_iMaxCtcpCount)
	}, {
		"iMaxCtcpTime",
		KVI_OPT_INT | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_iMaxCtcpTime)
	}, {
		"iMaxTotalQueries",
		KVI_OPT_INT | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_iMaxTotalQueries)
	}, {
		"iMaxQueryCount",
		KVI_OPT_INT | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_iMaxQueryCount)
	}, {
		"iMaxQueryTime",
		KVI_OPT_INT | KVI_OPT_CTCP,
		(void *) &(KviOptions::m_iMaxQueryTime)
	}, {
		"iOnIdleAfter",
		KVI_OPT_INT | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_iOnIdleAfter)
	}, {
		0, 0, 0
	}
};

KviOptionEntry KviOptions::optFontsTable[] =
{
	{
		"fntMdiCaption",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntMdiCaption)
	}, {
		"fntListBox",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntListBox)
	}, {
		"fntInput",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntInput)
	}, {
		"fntLabels",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntLabels)
	}, {
		"fntHelpNormal",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntHelpNormal)
	}, {
		"fntHelpFixed",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntHelpFixed)
	}, {
		"fntSysTray",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntSysTray)
	}, {
		"fntView",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntView)
	}, {
		"fntApplication",
		KVI_OPT_FNT | KVI_OPT_GUI,
		(void *) &(KviOptions::m_fntApplication)
	}, {
		0, 0, 0
	}
};

KviOptionEntry KviOptions::optTextTable[] =
{
	{
		"txtSelectionBack",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutSeleBack)
	}, {
		"txtSelectionFore",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutSeleFore)
	}, {
		"txtUrlFore",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutUrlFore)
	}, {
		"txtBack0",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[0])
	}, {
		"txtBack1",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[1])
	}, {
		"txtBack2",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[2])
	}, {
		"txtBack3",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[3])
	}, {
		"txtBack4",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[4])
	}, {
		"txtBack5",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[5])
	}, {
		"txtBack6",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[6])
	}, {
		"txtBack7",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[7])
	}, {
		"txtBack8",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[8])
	}, {
		"txtBack9",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[9])
	}, {
		"txtBack10",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[10])
	}, {
		"txtBack11",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[11])
	}, {
		"txtBack12",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[12])
	}, {
		"txtBack13",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[13])
	}, {
		"txtBack14",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[14])
	}, {
		"txtBack15",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[15])
	}, {
		"txtBack16",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[16])
	}, {
		"txtBack17",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[17])
	}, {
		"txtBack18",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[18])
	}, {
		"txtBack19",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[19])
	}, {
		"txtBack20",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[20])
	}, {
		"txtBack21",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[21])
	}, {
		"txtBack22",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[22])
	}, {
		"txtBack23",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[23])
	}, {
		"txtBack24",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[24])
	}, {
		"txtBack25",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[25])
	}, {
		"txtBack26",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[26])
	}, {
		"txtBack27",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[27])
	}, {
		"txtBack28",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[28])
	}, {
		"txtBack29",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[29])
	}, {
		"txtBack30",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[30])
	}, {
		"txtBack31",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[31])
	}, {
		"txtBack32",
		KVI_OPT_TXTB, (
		void *) &(KviOptions::m_cViewOutTypeBack[32])
	}, {
		"txtBack33",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[33])
	}, {
		"txtBack34",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[34])
	}, {
		"txtBack35",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[35])
	}, {
		"txtBack36",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[36])
	}, {
		"txtBack37",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[37])
	}, {
		"txtBack38",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[38])
	}, {
		"txtBack39",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[39])
	}, {
		"txtBack40",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[40])
	}, {
		"txtBack41",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[41])
	}, {
		"txtBack42",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[42])
	}, {
		"txtBack43",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[43])
	}, {
		"txtBack44",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[44])
	}, {
		"txtBack45",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[45])
	}, {
		"txtBack46",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[46])
	}, {
		"txtBack47",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[47])
	}, {
		"txtBack48",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[48])
	}, {
		"txtBack49",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[49])
	}, {
		"txtBack50",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[50])
	}, {
		"txtBack51",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[51])
	}, {
		"txtBack52",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[52])
	}, {
		"txtBack53",
		KVI_OPT_TXTB,
		(void *) &(KviOptions::m_cViewOutTypeBack[53])
	}, {
		"txtFore0" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[0])
	}, {
		"txtFore1" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[1])
	}, {
		"txtFore2" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[2])
	}, {
		"txtFore3" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[3])
	}, {
		"txtFore4" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[4])
	}, {
		"txtFore5" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[5])
	}, {
		"txtFore6" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[6])
	}, {
		"txtFore7" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[7])
	}, {
		"txtFore8" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[8])
	}, {
		"txtFore9" ,
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[9])
	}, {
		"txtFore10",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[10])
	}, {
		"txtFore11",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[11])
	}, {
		"txtFore12",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[12])
	}, {
		"txtFore13",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[13])
	}, {
		"txtFore14",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[14])
	}, {
		"txtFore15",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[15])
	}, {
		"txtFore16",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[16])
	}, {
		"txtFore17",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[17])
	}, {
		"txtFore18",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[18])
	}, {
		"txtFore19",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[19])
	}, {
		"txtFore20",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[20])
	}, {
		"txtFore21",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[21])
	}, {
		"txtFore22",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[22])
	}, {
		"txtFore23",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[23])
	}, {
		"txtFore24",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[24])
	}, {
		"txtFore25",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[25])
	}, {
		"txtFore26",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[26])
	}, {
		"txtFore27",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[27])
	}, {
		"txtFore28",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[28])
	}, {
		"txtFore29",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[29])
	}, {
		"txtFore30",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[30])
	}, {
		"txtFore31",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[31])
	}, {
		"txtFore32",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[32])
	}, {
		"txtFore33",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[33])
	}, {
		"txtFore34",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[34])
	}, {
		"txtFore35",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[35])
	}, {
		"txtFore36",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[36])
	}, {
		"txtFore37",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[37])
	}, {
		"txtFore38",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[38])
	}, {
		"txtFore39",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[39])
	}, {
		"txtFore40",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[40])
	}, {
		"txtFore41",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[41])
	}, {
		"txtFore42",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[42])
	}, {
		"txtFore43",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[43])
	}, {
		"txtFore44",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[44])
	}, {
		"txtFore45",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[45])
	}, {
		"txtFore46",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[46])
	}, {
		"txtFore47",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[47])
	}, {
		"txtFore48",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[48])
	}, {
		"txtFore49",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[49])
	}, {
		"txtFore50",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[50])
	}, {
		"txtFore51",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[51])
	}, {
		"txtFore52",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[52])
	}, {
		"txtFore53",
		KVI_OPT_TXTF,
		(void *) &(KviOptions::m_cViewOutTypeFore[53])
	}, {
		0, 0, 0
	}
};

KviOptionEntry KviOptions::optStringsTable[] =
{
	{
		"szUserName",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szUserName)
	}, {
		"szRealName",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szRealName)
	}, {
		"szNickName1",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szNickName1)
	}, {
		"szNickName2",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szNickName2)
	}, {
		"szPartMessage",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szPartMessage)
	}, {
		"szKickMessage",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szKickMessage)
	}, {
		"szQuitMessage",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szQuitMessage)
	}, {
		"szCaptionMessage",
		KVI_OPT_STR | KVI_OPT_CAPTION,
		(void *) &(KviOptions::m_szCaptionMessage)
	}, {
		"szCtcpVersionAppendix",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szCtcpVersionAppendix)
	}, {
		"szCtcpUserinfoAppendix",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szCtcpUserinfoAppendix)
	}, {
		"szCtcpClientinfoAppendix",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szCtcpClientinfoAppendix)
	}, {
		"szCtcpSourceAppendix",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szCtcpSourceAppendix)
	}, {
		"szCtcpFingerReply",
		KVI_OPT_STR | KVI_OPT_MSG,
		(void *) &(KviOptions::m_szCtcpFingerReply)
	}, {
		"szMdiBack",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szMdiBack)
	}, {
		"szListBoxBack",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szListBoxBack)
	}, {
		"szInputBack",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szInputBack)
	}, {
		"szLabelsBack",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szLabelsBack)
	}, {
		"szViewBack",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szViewBack)
	}, {
		"szExtPrivmsgPrefix",
		KVI_OPT_STR | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_szExtPrivmsgPrefix)
	}, {
		"szExtPrivmsgPostfix",
		KVI_OPT_STR | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_szExtPrivmsgPostfix)
	}, {
		"szPrivmsgFormatNickLinkCommand",
		KVI_OPT_STR | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_szPrivmsgFormatNickLinkCommand)
	}, {
		"szApplicationGUIStyle",
		KVI_OPT_STR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_szApplicationGUIStyle)
	}, {
		"szLastScriptPath",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szLastScriptPath)
	}, {
		"szDccLocalIpAddress",
		KVI_OPT_STR,
		(void *) &(KviOptions::m_szDccLocalIpAddress)
	}, {
		"szLocalHostIp",
		KVI_OPT_STR | KVI_OPT_IRCENG,
		(void *) &(KviOptions::m_szLocalHostIp)
	}, {
		0, 0, 0
	}
};

KviOptionEntry KviOptions::optColorsTable[] =
{
	{
		"clrMdiCaptionActiveBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrMdiCaptionActiveBack)
	}, {
		"clrMdiCaptionActiveFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrMdiCaptionActiveFore)
	}, {
		"clrMdiCaptionInactiveBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrMdiCaptionInactiveBack)
	}, {
		"clrMdiCaptionInactiveFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrMdiCaptionInactiveFore)
	}, {
		"clrMdiBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrMdiBack)
	}, {
		"clrListBoxOwner",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxOwner)
	}, {
		"clrListBoxOp",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxOp)
	}, {
		"clrListBoxHalfOp",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxHalfOp)
	}, {
		"clrListBoxVoice",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxVoice)
	}, {
		"clrListBoxUserOp",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxUserOp)
	}, {
		"clrListBoxNormal",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxNormal)
	}, {
		"clrListBoxSeleBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxSeleBack)
	}, {
		"clrListBoxSeleFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxSeleFore)
	}, {
		"clrListBoxBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrListBoxBack)
	}, {
		"clrInputBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrInputBack)
	}, {
		"clrInputFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrInputFore)
	}, {
		"clrInputSeleBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrInputSeleBack)
	}, {
		"clrInputSeleFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrInputSeleFore)
	}, {
		"clrInputCursor",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrInputCursor)
	}, {
		"clrLabelsBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrLabelsBack)
	}, {
		"clrLabelsActiveFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrLabelsActiveFore)
	}, {
		"clrLabelsInactiveFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrLabelsInactiveFore)
	}, {
		"clrHelpBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrHelpBack)
	}, {
		"clrHelpFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrHelpFore)
	}, {
		"clrHelpTitle",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrHelpTitle)
	}, {
		"clrHelpSubtitle",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrHelpSubtitle)
	}, {
		"clrHelpExample",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrHelpExample)
	}, {
		"clrSysTrayBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrSysTrayBack)
	}, {
		"clrSysTrayFore",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrSysTrayFore)
	}, {
		"clrViewBack",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrViewBack)
	}, {
		"clrMirc0",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[0])
	}, {
		"clrMirc1",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[1])
	}, {
		"clrMirc2",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[2])
	}, {
		"clrMirc3",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[3])
	}, {
		"clrMirc4",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[4])
	}, {
		"clrMirc5",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[5])
	}, {
		"clrMirc6",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[6])
	}, {
		"clrMirc7",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[7])
	}, {
		"clrMirc8",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[8])
	}, {
		"clrMirc9",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[9])
	}, {
		"clrMirc10",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[10])
	}, {
		"clrMirc11",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[11])
	}, {
		"clrMirc12",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[12])
	}, {
		"clrMirc13",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[13])
	}, {
		"clrMirc14",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[14])
	}, {
		"clrMirc15",
		KVI_OPT_PCLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_pMircColor[15])
	}, {
		"clrNormalGlobalForeground",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalForeground)
	}, {
		"clrNormalGlobalButton",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalButton)
	}, {
		"clrNormalGlobalLight",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalLight)
	}, {
		"clrNormalGlobalDark",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalDark)
	}, {
		"clrNormalGlobalMid",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalMid)
	}, {
		"clrNormalGlobalText",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalText)
	}, {
		"clrNormalGlobalBase",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrNormalGlobalBase)
	}, {
		"clrDisabledGlobalForeground",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrDisabledGlobalForeground)
	}, {
		"clrDisabledGlobalText",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrDisabledGlobalText)
	}, {
		"clrDisabledGlobalBase",
		KVI_OPT_CLR | KVI_OPT_GUI,
		(void *) &(KviOptions::m_clrDisabledGlobalBase)
	}, {
		0, 0, 0
	}
};

