// =============================================================================
//
//      --- kvi_dirbrowser.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDirBrowser"

#include "kvi_defines.h"
#include "kvi_dirbrowser.h"
#include "kvi_dirbrowser_widget.h"
#include "kvi_options.h"
#include "kvi_winproperties.h"

// Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap *g_pixViewOut[KVI_OUT_NUM_IMAGES];

KviDirectoryBrowser::KviDirectoryBrowser(KviFrame *lpFrm, const char *dirname)
	: KviWindow(KVI_DIRECTORYBROWSER_WINDOW_NAME, KVI_WND_TYPE_DIRBROWSER, lpFrm)
{
	m_pBrowser = new KviDirectoryBrowserWidget(this, lpFrm, dirname);
}

/**
 * ============ ~KviDirectoryBrowser ============
 */
KviDirectoryBrowser::~KviDirectoryBrowser()
{
	// Nothing here
}

void KviDirectoryBrowser::saveProperties()
{
	KviWindowProperty p;
	p.rect           = externalGeometry();
	p.isDocked       = isAttached();
	p.splitWidth1    = 0;
	p.splitWidth2    = 0;
	p.timestamp      = false;
	p.imagesVisible  = false;
	p.isMaximized    = isAttached() && isMaximized();
	p.topSplitWidth1 = 0;
	p.topSplitWidth2 = 0;
	p.topSplitWidth3 = 0;
	g_pOptions->m_pWinPropertiesList->setProperty(caption(), &p);
}

void KviDirectoryBrowser::setProperties(KviWindowProperty *)
{
	// Nothing here
}

bool KviDirectoryBrowser::loadDirectory(const char *dirname)
{
	return m_pBrowser->loadDirectory(dirname);
}

void KviDirectoryBrowser::stop()
{
	m_pBrowser->stop();
}

QPixmap *KviDirectoryBrowser::myIconPtr()
{
	return g_pixViewOut[KVI_OUT_WND_DIRBROWSER];
}

/**
 * =============== applyOptions ================
 */
void KviDirectoryBrowser::applyOptions()
{
	m_pBrowser->applyOptions();
}

/**
 * ================ resizeEvent ===============
 */
void KviDirectoryBrowser::resizeEvent(QResizeEvent *)
{
	m_pBrowser->setGeometry(0, 0, width(), height());
}

#include "m_kvi_dirbrowser.moc"
