/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatoptions.cpp ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  *
  *
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/

#define __KVIRC_PLUGIN__

#include <qtabdialog.h>
#include <qlist.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qvbox.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qslider.h>

#include "libkvistatoptions.h"
#include "kvi_locale.h"

KviStatOptions::KviStatOptions() : QTabDialog( 0, __tr("KviStat Options"), true )
{
	setCaption( __tr("KviStat Configuration") );
	labels.setAutoDelete(true);
	cboxes.setAutoDelete(true);
	rbuttons.setAutoDelete(true);
	const char *cs_cbnames[] = {
	// Custom stats
	 __tr("Show joins to channel"),
	 __tr("Show words spoken on channel"),
	 __tr("Show kicks given on channel"),
	 __tr("Show bans set on channel"),
	 __tr("Show number of topics changes")
	 };
	 
	const char *stw_cbnames[] = {
	// StatTray Widget options
	 __tr("Enable SysTray Widget on startup"),
	 __tr("Show words"),
	 __tr("Show joins"),
	 __tr("Show kicks"),
	 __tr("Show bans"),
	 __tr("Show topic changes")
	 };
	const char *cs_rbnames[] = {
	 __tr("No stats"),
	 __tr("Full stats"),
	 __tr("Customized stats") };
/*	const char *stw_rbnames[] = {
	 "Channel stats",
	 "Total stats" };
*/
	
#define NUM_CS_CBOXES		sizeof(cs_cbnames) / sizeof(cs_cbnames[0])
#define NUM_CS_RBUTTONS		sizeof(cs_rbnames) / sizeof(cs_rbnames[0])
#define NUM_STW_CBOXES		sizeof(stw_cbnames) / sizeof(stw_cbnames[0])
#define NUM_STW_RBUTTONS    sizeof(stw_rbnames) / sizeof(stw_rbnames[0])

	QHBox *hb = new QHBox( this );
	hb->setMargin(5);	

	QVBox *vb = new QVBox( hb );
	vb->setMargin(5);
	QLabel *lab = new QLabel( vb );
	lab->setText( _CHAR_2_QSTRING(__tr("Here you can decide what stats you\n"
					   "want to see when joining a channel.")));
	QVButtonGroup *gr = new QVButtonGroup( _CHAR_2_QSTRING(__tr("Stats on chan join")), vb );
	for( uint i = 0; i < NUM_CS_RBUTTONS; i++ )
	{
		QRadioButton *rb = new QRadioButton( _CHAR_2_QSTRING(cs_rbnames[i]), gr );
		connect(rb, SIGNAL(clicked()), SLOT(slotToggle()));
		gr->insert(rb);
		rbuttons.append(rb);
	}

	vb = new QVBox(hb);
	vb->setMargin(5);
	gr = new QVButtonGroup( _CHAR_2_QSTRING(__tr("Customized stats")), vb );
	gr->addSpace(10);
	for( uint i = 0; i < NUM_CS_CBOXES; i++ )
	{
		QCheckBox *cb = new QCheckBox(gr);
		cb->setText( _CHAR_2_QSTRING(cs_cbnames[i]));
		cb->setAutoResize(true);
		gr->insert(cb);
		cboxes.append(cb);
	}
	addTab( hb, _CHAR_2_QSTRING(__tr("OnJoin Stats")));

//	
// -- StatTray tab --
	
	hb = new QHBox(this);
/*	
	vb = new QVBox(hb);
	vb->setMargin(10);
	lab = new QLabel(vb);
	lab->setText( "Here you decide what type of stats the\n" \
	"StatTray Widget will show.");
	gr = new QVButtonGroup( "Stats type", vb );
	for( int i = 0; i < NUM_STW_RBUTTONS; i++ )
	{
		QRadioButton *rb = new QRadioButton(gr);
		rb->setText(stw_rbnames[i]);
		gr->insert(rb);
		rbuttons.append(rb);
	}
*/
	vb = new QVBox(hb);
	vb->setMargin(10);
	gr = new QVButtonGroup( _CHAR_2_QSTRING(__tr("StatTray Widget options")), vb );
	for( uint i = 0; i < NUM_STW_CBOXES; i++ )
	{
		QCheckBox *cb = new QCheckBox(gr);
		cb->setText( _CHAR_2_QSTRING(stw_cbnames[i]) );
		cb->setAutoResize( true );
		gr->insert(cb);
		cboxes.append(cb);
	}
	addTab( hb, _CHAR_2_QSTRING(__tr("StatTray")) );

//
// -- Scrolling tab --

	hb = new QHBox(this);
	vb = new QVBox(hb);
	vb->setMargin(15);

	QHBox *w = new QHBox(vb);
	lab = new QLabel(w);
	lab->setText( _CHAR_2_QSTRING(__tr("Scrolling enabled:")));
	lab->setAutoResize(true);

	scrollBox = new QComboBox( false, w );
	scrollBox->insertItem( _CHAR_2_QSTRING(__tr("No")) );
	scrollBox->insertItem( _CHAR_2_QSTRING(__tr("Yes")) );
//	scrollBox->insertItem( "When needed" );
	
	scrollBox->resize( 120, QFontMetrics(scrollBox->text(2)).height() + 10);


#define dirLeftIndex	0
#define dirRightIndex	1

	w = new QHBox(vb);
	lab = new QLabel(w);
	lab->setAutoResize(true);
	lab->setText(_CHAR_2_QSTRING(__tr("Direction:")));
	labels.append(lab);
	dirBox = new QComboBox( false, w );
	dirBox->insertItem( _CHAR_2_QSTRING(__tr("Left")), dirLeftIndex );
	dirBox->insertItem( _CHAR_2_QSTRING(__tr("Right")), dirRightIndex );
	dirBox->move( lab->x() + lab->width() + 10, lab->y() - lab->height() / 2 );
	dirBox->resize( 100, QFontMetrics(dirBox->currentText()).height() + 10 );

#undef Below	// fix for X includes conflict (another one)

	w = new QHBox(vb);
	lab = new QLabel(w);
	lab->setAutoResize(true);
	lab->setText( _CHAR_2_QSTRING(__tr("Scrolling delay:\t\t")) );
	labels.append(lab);
	delaySlider = new QSlider( 5, 600, 5, 30, Qt::Horizontal, w );
	delaySlider->setTickmarks( QSlider::Below );
	delaySlider->setTickInterval(20);

	w = new QHBox(vb);
	lab = new QLabel(w);
	lab->setAutoResize(true);
	lab->setText( _CHAR_2_QSTRING(__tr("Text Movement:\t\t")) );
	labels.append(lab);
	smoothnessSlider = new QSlider( 1, 10, 1, 3, Qt::Horizontal, w );
	smoothnessSlider->setTickmarks( QSlider::Below );

	addTab( hb, _CHAR_2_QSTRING(__tr("Scrolling")) );

//	connect(cboxes.at(SysTrayEnabled), SIGNAL(clicked()), SLOT(slotToggle()));
	connect(scrollBox, SIGNAL(activated(int)), SLOT(slotToggleScroll(int)));
	setCancelButton( _CHAR_2_QSTRING(__tr("Cancel")) );
	slotToggle();
	slotToggleScroll(-1);
}

void KviStatOptions::setOptions( unsigned int rbn, bool jo , bool wo , bool ki,
	bool ba , bool to )
{
	if(rbuttons.at(rbn))rbuttons.at( rbn )->setChecked( true );
	slotToggle();
	if(cboxes.at(ShowJoinsOnJoin))cboxes.at(ShowJoinsOnJoin)->setChecked(jo);
	if(cboxes.at(ShowWordsOnJoin))cboxes.at(ShowWordsOnJoin)->setChecked(wo);	
	if(cboxes.at(ShowKicksOnJoin))cboxes.at(ShowKicksOnJoin)->setChecked(ki);
	if(cboxes.at(ShowBansOnJoin))cboxes.at(ShowBansOnJoin)->setChecked(ba);
	if(cboxes.at(ShowTopicsOnJoin))cboxes.at(ShowTopicsOnJoin)->setChecked(to);
}

void KviStatOptions::setSysTrayOptions( bool enabled, bool wo, bool jo, bool ki,
	bool ba, bool to )
{
	if(cboxes.at(SysTrayEnabled))cboxes.at(SysTrayEnabled)->setChecked(enabled);
	if(cboxes.at(SysTrayShowWords))cboxes.at(SysTrayShowWords)->setChecked(wo);
	if(cboxes.at(SysTrayShowJoins))cboxes.at(SysTrayShowJoins)->setChecked(jo);
	if(cboxes.at(SysTrayShowKicks))cboxes.at(SysTrayShowKicks)->setChecked(ki);
	if(cboxes.at(SysTrayShowBans))cboxes.at(SysTrayShowBans)->setChecked(ba);
	if(cboxes.at(SysTrayShowTopics))
		cboxes.at(SysTrayShowTopics)->setChecked(to);
}

void KviStatOptions::setScrollingOptions( int when, int delay, int jump,
	bool dirLeft)
{
	if(scrollBox)
		scrollBox->setCurrentItem(when);
	slotToggleScroll(-1);
	if(delaySlider)
		delaySlider->setValue(delay);
	if(smoothnessSlider)
		smoothnessSlider->setValue(jump);
	if(dirBox)
		if(dirLeft)
			dirBox->setCurrentItem(dirLeftIndex);
		else
			dirBox->setCurrentItem(dirRightIndex);
}

void KviStatOptions::getOptions( int &rbn, bool &jo, bool &wo,
	bool &ki, bool &ba, bool &to )
{
	QListIterator<QRadioButton> it(rbuttons);
	int blah = 0;
	for( ; it.current(); ++it )
	{
		if( it.current()->isChecked() )
			break;
		blah++;
	}
	rbn = blah;
	jo = cboxes.at(ShowJoinsOnJoin)->isChecked();
	wo = cboxes.at(ShowWordsOnJoin)->isChecked();
	ki = cboxes.at(ShowKicksOnJoin)->isChecked();
	ba = cboxes.at(ShowBansOnJoin)->isChecked();
	to = cboxes.at(ShowTopicsOnJoin)->isChecked();
}

void KviStatOptions::getSysTrayOptions( bool &enabled, bool &wo, bool &jo,
	bool &ki, bool &ba, bool &to )
{
	enabled = cboxes.at(SysTrayEnabled)->isChecked();
	wo = cboxes.at(SysTrayShowWords)->isChecked();
	jo = cboxes.at(SysTrayShowJoins)->isChecked();
	ki = cboxes.at(SysTrayShowKicks)->isChecked();
	ba = cboxes.at(SysTrayShowBans)->isChecked();
	to = cboxes.at(SysTrayShowTopics)->isChecked();
}

void KviStatOptions::getScrollingOptions( int &when, int &delay, int &jump,
	bool &dirLeft )
{
	when = scrollBox->currentItem();
	delay = delaySlider->value();
	jump = smoothnessSlider->value();
	if( dirBox->currentText() == _CHAR_2_QSTRING(__tr("Left")))
		dirLeft = true;
	else
		dirLeft = false;
}

void KviStatOptions::slotToggle()
{
	QListIterator<QCheckBox> it(cboxes);
   	for( ; it.current(); ++it )
   	{
   		if( it.current() == cboxes.at(SysTrayEnabled) )
   			break;
   		it.current()->setEnabled(
			rbuttons.at(ShowCustomStatsOnJoin)->isChecked());
   	}
}

void KviStatOptions::slotToggleScroll(int dummy_integer)
{
	if( scrollBox->currentItem() == ScrollingNever )
	{
		delaySlider->setEnabled(false);
		smoothnessSlider->setEnabled(false);
		dirBox->setEnabled(false);
		QListIterator<QLabel> it(labels);
		for( ; it.current(); ++it )
			it.current()->setEnabled(false);
	}
	else
	{
		delaySlider->setEnabled(true);
		smoothnessSlider->setEnabled(true);
		dirBox->setEnabled(true);
		QListIterator<QLabel> it(labels);
		for( ; it.current(); ++it )
			it.current()->setEnabled(true);
	}
}

#include "libkvistatoptions.moc"
