//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//   Copyright (C) Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qpixmap.h>
#include <qlayout.h>
#include "setupData.h"

#include "kvi_locale.h"
#include "config.h"

#include <qlabel.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>

eciSetupData::eciSetupData(QWidget *parent, const char *name)
             : QDialog(parent, name, FALSE, 0)
{
    QButtonGroup *qtarch_ButtonGroup_1 = new QButtonGroup(this, "ButtonGroup_1");
    qtarch_ButtonGroup_1->setGeometry(10, 20, 150, 190);
    qtarch_ButtonGroup_1->setMinimumSize(10, 10);
    qtarch_ButtonGroup_1->setMaximumSize(32767, 32767);
    qtarch_ButtonGroup_1->setFocusPolicy(QWidget::NoFocus);
    qtarch_ButtonGroup_1->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_ButtonGroup_1->setFontPropagation(QWidget::SameFont);
    qtarch_ButtonGroup_1->setPalettePropagation(QWidget::SameFont);
    qtarch_ButtonGroup_1->setFrameStyle( 49 );
    qtarch_ButtonGroup_1->setLineWidth( 1 );
    qtarch_ButtonGroup_1->setMidLineWidth( 0 );
    qtarch_ButtonGroup_1->QFrame::setMargin( 0 );
    qtarch_ButtonGroup_1->setTitle( "" );
    qtarch_ButtonGroup_1->setAlignment( AlignLeft );
    qtarch_ButtonGroup_1->setExclusive( FALSE );

    m_pPitchbase = new QSlider(this, __tr("pitchbase_select"));
    m_pPitchbase->setGeometry(190, 90, 230, 20);
    m_pPitchbase->setMinimumSize(10, 10);
    m_pPitchbase->setMaximumSize(32767, 32767);
    m_pPitchbase->setFocusPolicy(QWidget::TabFocus);
    m_pPitchbase->setBackgroundMode(QWidget::PaletteBackground);
    m_pPitchbase->setFontPropagation(QWidget::SameFont);
    m_pPitchbase->setPalettePropagation(QWidget::SameFont);
    m_pPitchbase->setOrientation( QSlider::Horizontal );
    m_pPitchbase->setRange( 0, 99 );
    m_pPitchbase->setSteps( 1, 10 );
    m_pPitchbase->setValue( 0 );
    m_pPitchbase->setTracking( TRUE );
    m_pPitchbase->setTickmarks( QSlider::NoMarks );
    m_pPitchbase->setTickInterval( 0 );
    connect(m_pPitchbase, SIGNAL(valueChanged(int)), SLOT(pitchBaseValue(int)));

    m_pPitchrange = new QSlider(this, __tr("pitchrange_select"));
    m_pPitchrange->setGeometry(190, 120, 230, 20);
    m_pPitchrange->setMinimumSize(10, 10);
    m_pPitchrange->setMaximumSize(32767, 32767);
    m_pPitchrange->setFocusPolicy(QWidget::TabFocus);
    m_pPitchrange->setBackgroundMode(QWidget::PaletteBackground);
    m_pPitchrange->setFontPropagation(QWidget::SameFont);
    m_pPitchrange->setPalettePropagation(QWidget::SameFont);
    m_pPitchrange->setOrientation( QSlider::Horizontal );
    m_pPitchrange->setRange( 0, 99 );
    m_pPitchrange->setSteps( 1, 10 );
    m_pPitchrange->setValue( 0 );
    m_pPitchrange->setTracking( TRUE );
    m_pPitchrange->setTickmarks( QSlider::NoMarks );
    m_pPitchrange->setTickInterval( 0 );
    connect(m_pPitchrange, SIGNAL(valueChanged(int)), SLOT(pitchRangeValue(int)));

    m_pRoughness = new QSlider(this, __tr("roughness_select"));
    m_pRoughness->setGeometry(190, 150, 230, 20);
    m_pRoughness->setMinimumSize(10, 10);
    m_pRoughness->setMaximumSize(32767, 32767);
    m_pRoughness->setFocusPolicy(QWidget::TabFocus);
    m_pRoughness->setBackgroundMode(QWidget::PaletteBackground);
    m_pRoughness->setFontPropagation(QWidget::SameFont);
    m_pRoughness->setPalettePropagation(QWidget::SameFont);
    m_pRoughness->setOrientation( QSlider::Horizontal );
    m_pRoughness->setRange( 0, 99 );
    m_pRoughness->setSteps( 1, 10 );
    m_pRoughness->setValue( 0 );
    m_pRoughness->setTracking( TRUE );
    m_pRoughness->setTickmarks( QSlider::NoMarks );
    m_pRoughness->setTickInterval( 0 );
    connect(m_pRoughness, SIGNAL(valueChanged(int)), SLOT(roughnessValue(int)));

    m_pSpeed = new QSlider(this, __tr("speed_select"));
    m_pSpeed->setGeometry(190, 180, 230, 20);
    m_pSpeed->setMinimumSize(10, 10);
    m_pSpeed->setMaximumSize(32767, 32767);
    m_pSpeed->setFocusPolicy(QWidget::TabFocus);
    m_pSpeed->setBackgroundMode(QWidget::PaletteBackground);
    m_pSpeed->setFontPropagation(QWidget::SameFont);
    m_pSpeed->setPalettePropagation(QWidget::SameFont);
    m_pSpeed->setOrientation( QSlider::Horizontal );
    m_pSpeed->setRange( 0, 99 );
    m_pSpeed->setSteps( 1, 10 );
    m_pSpeed->setValue( 0 );
    m_pSpeed->setTracking( TRUE );
    m_pSpeed->setTickmarks( QSlider::NoMarks );
    m_pSpeed->setTickInterval( 0 );
    connect(m_pSpeed, SIGNAL(valueChanged(int)), SLOT(speedValue(int)));

    m_pHeadsize = new QSlider(this, __tr("headsize_select"));
    m_pHeadsize->setGeometry(190, 60, 230, 20);
    m_pHeadsize->setMinimumSize(10, 10);
    m_pHeadsize->setMaximumSize(32767, 32767);
    m_pHeadsize->setFocusPolicy(QWidget::TabFocus);
    m_pHeadsize->setBackgroundMode(QWidget::PaletteBackground);
    m_pHeadsize->setFontPropagation(QWidget::SameFont);
    m_pHeadsize->setPalettePropagation(QWidget::SameFont);
    m_pHeadsize->setOrientation( QSlider::Horizontal );
    m_pHeadsize->setRange( 0, 99 );
    m_pHeadsize->setSteps( 1, 10 );
    m_pHeadsize->setValue( 0 );
    m_pHeadsize->setTracking( TRUE );
    m_pHeadsize->setTickmarks( QSlider::NoMarks );
    m_pHeadsize->setTickInterval( 0 );
    connect(m_pHeadsize, SIGNAL(valueChanged(int)), SLOT(headValue(int)));

    m_pVolume = new QSlider(this, __tr("volume_select"));
    m_pVolume->setGeometry(190, 210, 230, 20);
    m_pVolume->setMinimumSize(10, 10);
    m_pVolume->setMaximumSize(32767, 32767);
    m_pVolume->setFocusPolicy(QWidget::TabFocus);
    m_pVolume->setBackgroundMode(QWidget::PaletteBackground);
    m_pVolume->setFontPropagation(QWidget::SameFont);
    m_pVolume->setPalettePropagation(QWidget::SameFont);
    m_pVolume->setOrientation( QSlider::Horizontal );
    m_pVolume->setRange( 0, 99 );
    m_pVolume->setSteps( 1, 10 );
    m_pVolume->setValue( 0 );
    m_pVolume->setTracking( TRUE );
    m_pVolume->setTickmarks( QSlider::NoMarks );
    m_pVolume->setTickInterval( 0 );
    connect(m_pVolume, SIGNAL(valueChanged(int)), SLOT(volumeValue(int)));

    m_pBreathiness = new QSlider(this, __tr("breathiness_select"));
    m_pBreathiness->setGeometry(190, 240, 230, 20);
    m_pBreathiness->setMinimumSize(10, 10);
    m_pBreathiness->setMaximumSize(32767, 32767);
    m_pBreathiness->setFocusPolicy(QWidget::TabFocus);
    m_pBreathiness->setBackgroundMode(QWidget::PaletteBackground);
    m_pBreathiness->setFontPropagation(QWidget::SameFont);
    m_pBreathiness->setPalettePropagation(QWidget::SameFont);
    m_pBreathiness->setOrientation( QSlider::Horizontal );
    m_pBreathiness->setRange( 0, 99 );
    m_pBreathiness->setSteps( 1, 10 );
    m_pBreathiness->setValue( 0 );
    m_pBreathiness->setTracking( TRUE );
    m_pBreathiness->setTickmarks( QSlider::NoMarks );
    m_pBreathiness->setTickInterval( 0 );
    connect(m_pBreathiness, SIGNAL(valueChanged(int)), SLOT(breathinessValue(int)));

    QLabel *qtarch_Label_1 = new QLabel(this, "Label_1");
    qtarch_Label_1->setGeometry(430, 60, 70, 20);
    qtarch_Label_1->setMinimumSize(10, 10);
    qtarch_Label_1->setMaximumSize(32767, 32767);
    qtarch_Label_1->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_1->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_1->setFontPropagation(QWidget::SameFont);
    qtarch_Label_1->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_1->setFrameStyle( 0 );
    qtarch_Label_1->setLineWidth( 1 );
    qtarch_Label_1->setMidLineWidth( 0 );
    qtarch_Label_1->QFrame::setMargin( -1 );
    qtarch_Label_1->setText( __tr("Headsize") );
    qtarch_Label_1->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_1->setMargin( -1 );

    QLabel *qtarch_Label_2 = new QLabel(this, "Label_2");
    qtarch_Label_2->setGeometry(430, 90, 70, 20);
    qtarch_Label_2->setMinimumSize(10, 10);
    qtarch_Label_2->setMaximumSize(32767, 32767);
    qtarch_Label_2->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_2->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_2->setFontPropagation(QWidget::SameFont);
    qtarch_Label_2->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_2->setFrameStyle( 0 );
    qtarch_Label_2->setLineWidth( 1 );
    qtarch_Label_2->setMidLineWidth( 0 );
    qtarch_Label_2->QFrame::setMargin( -1 );
    qtarch_Label_2->setText( __tr("Pitch base") );
    qtarch_Label_2->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_2->setMargin( -1 );

    QLabel *qtarch_Label_3 = new QLabel(this, "Label_3");
    qtarch_Label_3->setGeometry(430, 120, 80, 20);
    qtarch_Label_3->setMinimumSize(10, 10);
    qtarch_Label_3->setMaximumSize(32767, 32767);
    qtarch_Label_3->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_3->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_3->setFontPropagation(QWidget::SameFont);
    qtarch_Label_3->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_3->setFrameStyle( 0 );
    qtarch_Label_3->setLineWidth( 1 );
    qtarch_Label_3->setMidLineWidth( 0 );
    qtarch_Label_3->QFrame::setMargin( -1 );
    qtarch_Label_3->setText( __tr("Pitch range") );
    qtarch_Label_3->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_3->setMargin( -1 );

    QLabel *qtarch_Label_4 = new QLabel(this, "Label_4");
    qtarch_Label_4->setGeometry(430, 150, 80, 20);
    qtarch_Label_4->setMinimumSize(10, 10);
    qtarch_Label_4->setMaximumSize(32767, 32767);
    qtarch_Label_4->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_4->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_4->setFontPropagation(QWidget::SameFont);
    qtarch_Label_4->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_4->setFrameStyle( 0 );
    qtarch_Label_4->setLineWidth( 1 );
    qtarch_Label_4->setMidLineWidth( 0 );
    qtarch_Label_4->QFrame::setMargin( -1 );
    qtarch_Label_4->setText( __tr("Roughness") );
    qtarch_Label_4->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_4->setMargin( -1 );

    QLabel *qtarch_Label_5 = new QLabel(this, "Label_5");
    qtarch_Label_5->setGeometry(430, 180, 80, 20);
    qtarch_Label_5->setMinimumSize(10, 10);
    qtarch_Label_5->setMaximumSize(32767, 32767);
    qtarch_Label_5->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_5->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_5->setFontPropagation(QWidget::SameFont);
    qtarch_Label_5->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_5->setFrameStyle( 0 );
    qtarch_Label_5->setLineWidth( 1 );
    qtarch_Label_5->setMidLineWidth( 0 );
    qtarch_Label_5->QFrame::setMargin( -1 );
    qtarch_Label_5->setText( __tr("Speed") );
    qtarch_Label_5->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_5->setMargin( -1 );

    QLabel *qtarch_Label_6 = new QLabel(this, "Label_6");
    qtarch_Label_6->setGeometry(430, 210, 80, 20);
    qtarch_Label_6->setMinimumSize(10, 10);
    qtarch_Label_6->setMaximumSize(32767, 32767);
    qtarch_Label_6->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_6->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_6->setFontPropagation(QWidget::SameFont);
    qtarch_Label_6->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_6->setFrameStyle( 0 );
    qtarch_Label_6->setLineWidth( 1 );
    qtarch_Label_6->setMidLineWidth( 0 );
    qtarch_Label_6->QFrame::setMargin( -1 );
    qtarch_Label_6->setText( __tr("Volume") );
    qtarch_Label_6->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_6->setMargin( -1 );

    QLabel *qtarch_Label_7 = new QLabel(this, "Label_7");
    qtarch_Label_7->setGeometry(430, 240, 90, 20);
    qtarch_Label_7->setMinimumSize(10, 10);
    qtarch_Label_7->setMaximumSize(32767, 32767);
    qtarch_Label_7->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_7->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_7->setFontPropagation(QWidget::SameFont);
    qtarch_Label_7->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_7->setFrameStyle( 0 );
    qtarch_Label_7->setLineWidth( 1 );
    qtarch_Label_7->setMidLineWidth( 0 );
    qtarch_Label_7->QFrame::setMargin( -1 );
    qtarch_Label_7->setText( __tr("Breathiness") );
    qtarch_Label_7->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_7->setMargin( -1 );

    QRadioButton *qtarch_male_1 = new QRadioButton(qtarch_ButtonGroup_1, "male_1");
    qtarch_male_1->setGeometry(10, 10, 100, 20);
    qtarch_male_1->setMinimumSize(10, 10);
    qtarch_male_1->setMaximumSize(32767, 32767);
    qtarch_male_1->setFocusPolicy(QWidget::TabFocus);
    qtarch_male_1->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_male_1->setFontPropagation(QWidget::SameFont);
    qtarch_male_1->setPalettePropagation(QWidget::SameFont);
    qtarch_male_1->setText( __tr("Male voice 1") );
    qtarch_male_1->setAutoRepeat( FALSE );
    qtarch_male_1->setAutoResize( FALSE );
    qtarch_male_1->setChecked( TRUE );
    connect(qtarch_male_1, SIGNAL(clicked()), SLOT(male1()));

    QRadioButton *qtarch_male_2 = new QRadioButton(qtarch_ButtonGroup_1, "male_2");
    qtarch_male_2->setGeometry(10, 40, 100, 20);
    qtarch_male_2->setMinimumSize(10, 10);
    qtarch_male_2->setMaximumSize(32767, 32767);
    qtarch_male_2->setFocusPolicy(QWidget::TabFocus);
    qtarch_male_2->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_male_2->setFontPropagation(QWidget::SameFont);
    qtarch_male_2->setPalettePropagation(QWidget::SameFont);
    qtarch_male_2->setText( __tr("Male voice 2") );
    qtarch_male_2->setAutoRepeat( FALSE );
    qtarch_male_2->setAutoResize( FALSE );
    qtarch_male_2->setChecked( FALSE );
    connect(qtarch_male_2, SIGNAL(clicked()), SLOT(male2()));

    QRadioButton *qtarch_female = new QRadioButton(qtarch_ButtonGroup_1, "female");
    qtarch_female->setGeometry(10, 70, 110, 20);
    qtarch_female->setMinimumSize(10, 10);
    qtarch_female->setMaximumSize(32767, 32767);
    qtarch_female->setFocusPolicy(QWidget::TabFocus);
    qtarch_female->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_female->setFontPropagation(QWidget::SameFont);
    qtarch_female->setPalettePropagation(QWidget::SameFont);
    qtarch_female->setText( __tr("Female voice") );
    qtarch_female->setAutoRepeat( FALSE );
    qtarch_female->setAutoResize( FALSE );
    qtarch_female->setChecked( FALSE );
    connect(qtarch_female, SIGNAL(clicked()), SLOT(female()));

    QRadioButton *qtarch_child = new QRadioButton(qtarch_ButtonGroup_1, "child");
    qtarch_child->setGeometry(10, 100, 100, 20);
    qtarch_child->setMinimumSize(10, 10);
    qtarch_child->setMaximumSize(32767, 32767);
    qtarch_child->setFocusPolicy(QWidget::TabFocus);
    qtarch_child->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_child->setFontPropagation(QWidget::SameFont);
    qtarch_child->setPalettePropagation(QWidget::SameFont);
    qtarch_child->setText( __tr("Childs voice") );
    qtarch_child->setAutoRepeat( FALSE );
    qtarch_child->setAutoResize( FALSE );
    qtarch_child->setChecked( FALSE );
    connect(qtarch_child, SIGNAL(clicked()), SLOT(child()));

    QRadioButton *qtarch_grandma = new QRadioButton(qtarch_ButtonGroup_1, "grandma");
    qtarch_grandma->setGeometry(10, 130, 120, 20);
    qtarch_grandma->setMinimumSize(10, 10);
    qtarch_grandma->setMaximumSize(32767, 32767);
    qtarch_grandma->setFocusPolicy(QWidget::TabFocus);
    qtarch_grandma->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_grandma->setFontPropagation(QWidget::SameFont);
    qtarch_grandma->setPalettePropagation(QWidget::SameFont);
    qtarch_grandma->setText( __tr("Grandma voice") );
    qtarch_grandma->setAutoRepeat( FALSE );
    qtarch_grandma->setAutoResize( FALSE );
    qtarch_grandma->setChecked( FALSE );
    connect(qtarch_grandma, SIGNAL(clicked()), SLOT(grandma()));

    QRadioButton *qtarch_grandpa = new QRadioButton(qtarch_ButtonGroup_1, "grandpa");
    qtarch_grandpa->setGeometry(10, 160, 130, 20);
    qtarch_grandpa->setMinimumSize(10, 10);
    qtarch_grandpa->setMaximumSize(32767, 32767);
    qtarch_grandpa->setFocusPolicy(QWidget::TabFocus);
    qtarch_grandpa->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_grandpa->setFontPropagation(QWidget::SameFont);
    qtarch_grandpa->setPalettePropagation(QWidget::SameFont);
    qtarch_grandpa->setText( __tr("Grandfathers voice") );
    qtarch_grandpa->setAutoRepeat( FALSE );
    qtarch_grandpa->setAutoResize( FALSE );
    qtarch_grandpa->setChecked( FALSE );
    connect(qtarch_grandpa, SIGNAL(clicked()), SLOT(grandpa()));

    QPushButton *qtarch_PushButton_1 = new QPushButton(this, "PushButton_1");
    qtarch_PushButton_1->setGeometry(10, 300, 90, 30);
    qtarch_PushButton_1->setMinimumSize(10, 10);
    qtarch_PushButton_1->setMaximumSize(32767, 32767);
    qtarch_PushButton_1->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_1->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_1->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_1->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_1->setText( __tr("OK") );
    qtarch_PushButton_1->setAutoRepeat( FALSE );
    qtarch_PushButton_1->setAutoResize( FALSE );
    qtarch_PushButton_1->setToggleButton( FALSE );
    qtarch_PushButton_1->setDefault( FALSE );
    qtarch_PushButton_1->setAutoDefault( FALSE );
    qtarch_PushButton_1->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_1, SIGNAL(clicked()), SLOT(okPressed()));

    QPushButton *qtarch_PushButton_2 = new QPushButton(this, "PushButton_2");
    qtarch_PushButton_2->setGeometry(120, 300, 90, 30);
    qtarch_PushButton_2->setMinimumSize(10, 10);
    qtarch_PushButton_2->setMaximumSize(32767, 32767);
    qtarch_PushButton_2->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_2->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_2->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_2->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_2->setText( __tr("Cancel") );
    qtarch_PushButton_2->setAutoRepeat( FALSE );
    qtarch_PushButton_2->setAutoResize( FALSE );
    qtarch_PushButton_2->setToggleButton( FALSE );
    qtarch_PushButton_2->setDefault( FALSE );
    qtarch_PushButton_2->setAutoDefault( FALSE );
    qtarch_PushButton_2->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_2, SIGNAL(clicked()), SLOT(cancelPressed()));

    QPushButton *qtarch_test = new QPushButton(this, "test");
    qtarch_test->setGeometry(430, 300, 81, 30);
    qtarch_test->setMinimumSize(0, 0);
    qtarch_test->setMaximumSize(32767, 32767);
    qtarch_test->setFocusPolicy(QWidget::TabFocus);
    qtarch_test->setBackgroundMode(QWidget::PaletteButton);
    qtarch_test->setFontPropagation(QWidget::SameFont);
    qtarch_test->setPalettePropagation(QWidget::SameFont);
    qtarch_test->setText( __tr("Test") );
    qtarch_test->setAutoRepeat( FALSE );
    qtarch_test->setAutoResize( FALSE );
    qtarch_test->setToggleButton( FALSE );
    qtarch_test->setDefault( FALSE );
    qtarch_test->setAutoDefault( FALSE );
    qtarch_test->setIsMenuButton( FALSE );
    connect(qtarch_test, SIGNAL(clicked()), SLOT(testPressed()));

    QLabel *qtarch_Label_11 = new QLabel(this, "Label_11");
    qtarch_Label_11->setGeometry(220, 10, 180, 30);
    qtarch_Label_11->setMinimumSize(0, 0);
    qtarch_Label_11->setMaximumSize(32767, 32767);
    {
        QColorGroup normal;
        normal.setColor( QColorGroup::Foreground, QColor( QRgb( 127 ) ) );
        normal.setColor( QColorGroup::Button, QColor( QRgb( 12632256 ) ) );
        normal.setColor( QColorGroup::Light, QColor( QRgb( 16777215 ) ) );
        normal.setColor( QColorGroup::Midlight, QColor( QRgb( 14474460 ) ) );
        normal.setColor( QColorGroup::Dark, QColor( QRgb( 8421504 ) ) );
        normal.setColor( QColorGroup::Mid, QColor( QRgb( 10526884 ) ) );
        normal.setColor( QColorGroup::Text, QColor( QRgb( 127 ) ) );
        normal.setColor( QColorGroup::BrightText, QColor( QRgb( 16777215 ) ) );
        normal.setColor( QColorGroup::ButtonText, QColor( QRgb( 0 ) ) );
        normal.setColor( QColorGroup::Base, QColor( QRgb( 16777215 ) ) );
        normal.setColor( QColorGroup::Background, QColor( QRgb( 12632256 ) ) );
        normal.setColor( QColorGroup::Shadow, QColor( QRgb( 0 ) ) );
        normal.setColor( QColorGroup::Highlight, QColor( QRgb( 128 ) ) );
        normal.setColor( QColorGroup::HighlightedText, QColor( QRgb( 16777215 ) ) );
        QColorGroup disabled;
        disabled.setColor( QColorGroup::Foreground, QColor( QRgb( 8421504 ) ) );
        disabled.setColor( QColorGroup::Button, QColor( QRgb( 12632256 ) ) );
        disabled.setColor( QColorGroup::Light, QColor( QRgb( 16777215 ) ) );
        disabled.setColor( QColorGroup::Midlight, QColor( QRgb( 14474460 ) ) );
        disabled.setColor( QColorGroup::Dark, QColor( QRgb( 8421504 ) ) );
        disabled.setColor( QColorGroup::Mid, QColor( QRgb( 10526884 ) ) );
        disabled.setColor( QColorGroup::Text, QColor( QRgb( 8421504 ) ) );
        disabled.setColor( QColorGroup::BrightText, QColor( QRgb( 16777215 ) ) );
        disabled.setColor( QColorGroup::ButtonText, QColor( QRgb( 8421504 ) ) );
        disabled.setColor( QColorGroup::Base, QColor( QRgb( 12632256 ) ) );
        disabled.setColor( QColorGroup::Background, QColor( QRgb( 12632256 ) ) );
        disabled.setColor( QColorGroup::Shadow, QColor( QRgb( 0 ) ) );
        disabled.setColor( QColorGroup::Highlight, QColor( QRgb( 128 ) ) );
        disabled.setColor( QColorGroup::HighlightedText, QColor( QRgb( 16777215 ) ) );
        QColorGroup active;
        active.setColor( QColorGroup::Foreground, QColor( QRgb( 127 ) ) );
        active.setColor( QColorGroup::Button, QColor( QRgb( 12632256 ) ) );
        active.setColor( QColorGroup::Light, QColor( QRgb( 16777215 ) ) );
        active.setColor( QColorGroup::Midlight, QColor( QRgb( 14474460 ) ) );
        active.setColor( QColorGroup::Dark, QColor( QRgb( 8421504 ) ) );
        active.setColor( QColorGroup::Mid, QColor( QRgb( 10526884 ) ) );
        active.setColor( QColorGroup::Text, QColor( QRgb( 127 ) ) );
        active.setColor( QColorGroup::BrightText, QColor( QRgb( 16777215 ) ) );
        active.setColor( QColorGroup::ButtonText, QColor( QRgb( 0 ) ) );
        active.setColor( QColorGroup::Base, QColor( QRgb( 16777215 ) ) );
        active.setColor( QColorGroup::Background, QColor( QRgb( 12632256 ) ) );
        active.setColor( QColorGroup::Shadow, QColor( QRgb( 0 ) ) );
        active.setColor( QColorGroup::Highlight, QColor( QRgb( 128 ) ) );
        active.setColor( QColorGroup::HighlightedText, QColor( QRgb( 16777215 ) ) );
        QPalette palette( normal, disabled, active );
        qtarch_Label_11->setPalette( palette );
    }
    {
        QFont font("helvetica", 18, 50, 0);
        font.setStyleHint((QFont::StyleHint)5);
#ifndef COMPILE_WITH_QT_3
        font.setCharSet((QFont::CharSet)0);
#endif
        qtarch_Label_11->setFont( font );
    }
    qtarch_Label_11->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_11->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_11->setFontPropagation(QWidget::SameFont);
    qtarch_Label_11->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_11->setFrameStyle( 0 );
    qtarch_Label_11->setLineWidth( 1 );
    qtarch_Label_11->setMidLineWidth( 0 );
    qtarch_Label_11->QFrame::setMargin( 0 );
    qtarch_Label_11->setText( __tr("KVIrc Speaker Voice") );
    qtarch_Label_11->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_11->setMargin( 0 );

    m_pGender = new QCheckBox(this, "CheckBox_1");
    m_pGender->setGeometry(20, 230, 160, 20);
    m_pGender->setMinimumSize(0, 0);
    m_pGender->setMaximumSize(32767, 32767);
    m_pGender->setFocusPolicy(QWidget::TabFocus);
    m_pGender->setBackgroundMode(QWidget::PaletteBackground);
    m_pGender->setFontPropagation(QWidget::SameFont);
    m_pGender->setPalettePropagation(QWidget::SameFont);
    m_pGender->setText( __tr("Vocal tract male/female") );
    m_pGender->setAutoRepeat( FALSE );
    m_pGender->setAutoResize( FALSE );
    m_pGender->setChecked( FALSE );
    connect(m_pGender, SIGNAL(toggled(bool)), SLOT(genderValue(bool)));

    QLabel *qtarch_Label_12 = new QLabel(this, "Label_12");
    qtarch_Label_12->setGeometry(20, 270, 130, 20);
    qtarch_Label_12->setMinimumSize(0, 0);
    qtarch_Label_12->setMaximumSize(32767, 32767);
    qtarch_Label_12->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_12->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_12->setFontPropagation(QWidget::SameFont);
    qtarch_Label_12->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_12->setFrameStyle( 0 );
    qtarch_Label_12->setLineWidth( 1 );
    qtarch_Label_12->setMidLineWidth( 0 );
    qtarch_Label_12->QFrame::setMargin( 0 );
    qtarch_Label_12->setText( __tr("ViaVoice annotations:") );
    qtarch_Label_12->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    qtarch_Label_12->setMargin( 0 );

    m_pAnnotations = new QLabel(this, "Label_13");
    m_pAnnotations->setGeometry(160, 270, 330, 20);
    m_pAnnotations->setMinimumSize(0, 0);
    m_pAnnotations->setMaximumSize(32767, 32767);
    m_pAnnotations->setFocusPolicy(QWidget::NoFocus);
    m_pAnnotations->setBackgroundMode(QWidget::PaletteBackground);
    m_pAnnotations->setFontPropagation(QWidget::SameFont);
    m_pAnnotations->setPalettePropagation(QWidget::SameFont);
    m_pAnnotations->setFrameStyle( 0 );
    m_pAnnotations->setLineWidth( 1 );
    m_pAnnotations->setMidLineWidth( 0 );
    m_pAnnotations->QFrame::setMargin( 0 );
    m_pAnnotations->setText( "" );
    m_pAnnotations->setAlignment( AlignLeft|AlignVCenter|ExpandTabs );
    m_pAnnotations->setMargin( 0 );

	QBoxLayout* qtarch_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, NULL );
	qtarch_layout_1->addStrut( 0 );
    resize(530,340);
    setMinimumSize(0, 0);
    setMaximumSize(32767, 32767);
}

eciSetupData::~eciSetupData()
{
}
