#ifndef _KVI_WMDOCK_H_INCLUDED_
#define _KVI_WMDOCK_H_INCLUDED_

#include <config.h>
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef COMPILE_NEED_KDE

#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <qpixmap.h>

class KviWMDockWidget : public KSystemTray
{
	friend class KviApp;
	Q_OBJECT
public:
	KviWMDockWidget();
	~KviWMDockWidget();

public slots:
	void fillContextPopup();
	void fillSessionsPopup();
	void slot_showAllFrames();
	void slot_hideAllFrames();
	void slot_toggleAllFrames();
	void slot_toggleLock();

protected:
	int m_iFramesMinimize;
	int m_iFramesRestore;
	bool m_bFramesVisible;
	bool m_bLocked;
	KPopupMenu * m_pContextPopup;
	KPopupMenu * m_pSessionsPopup;
	bool m_bHighlight;
	bool m_bAltColor;
	unsigned long m_lPw;
	QPixmap * m_pNormalIcon;
	QPixmap * m_pHighlightIcon;
	QPixmap * m_pAltColorIcon;
protected:

	inline bool framesVisible(){ return m_bFramesVisible; };
	void setFramesVisible(bool bVisible);
	virtual void mousePressEvent(QMouseEvent *e);
	void highlight(bool bAltColor);
	void setPixmap();
};

#else

class KviWMDockWidget
{
public:
	KviWMDockWidget() {}
};

#endif

#endif //_KVI_WMDOCK_H_INCLUDED_

