#ifndef _KVI_UTOOLBAR_H_INCLUDED_
#define _KVI_UTOOLBAR_H_INCLUDED_

//
//   File : kvi_popupmenu.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_popupmenu.h)
//   Last major modification : Wed Apr 21 1999 21:36:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qlist.h>
#include <qwidget.h>
#include <qfile.h>
#include <qpalette.h>
#include <qpopupmenu.h>

#include "kvi_string.h"
#include "kvi_popupmenu.h"
#include "kvi_style.h"

//class KviUserToolBar;
class KviToolButton;
class KviUserToolBarTemplate;

typedef struct KviUserToolBarData
{
	KviStr 			buffer;
	KviStr			image;
	KviStr			text;
	KviStr			sbar;
	KviToolButton	*button;
	KviPopupMenu	*menu;
	int				id;
	int				type;
};

//
// An item with id=0 , menu=0 and buffer = " " is a separator.
// Normal menu item buffers have the initial spaces stripped at
// insertion time
//

class KviFrame;
class KviCommand;
//class KviTransparentWidget;

class KviUserToolBar : public QToolBar
{
	friend class KviDlgScript;
	Q_OBJECT
public:
	KviUserToolBar(KviFrame *frame,QMainWindow::ToolBarDock dock);
	KviUserToolBar(KviFrame *frame, QWidget *parent);
	~KviUserToolBar();
private:
//	KviTransparentWidget * m_pFiller;
	KviFrame *m_pFrame;
	QWidget  *m_pParent;
	int m_id;
//	QPopupMenu *m_pEditPopup; // Qt KILLS THIS
public:
	enum ToolButtonType { Separator, Button, Menu };
	QList<KviUserToolBarData> * m_pDataList;
	bool m_bLocked; //Protects against self-modification
	void clearAll();
	int insertNormalItem(const char *name, const char *sbar,const char *img,const char *buffer, KviPopupMenu *menu=0);
	void insertSeparatorItem();
	void copyFromTemplate(KviUserToolBarTemplate *toolbar, bool bEditPopup = true);
	void clearToolBar();
	bool isEmpty();
public slots:
	void buttonClicked(int id);

protected slots:
//	virtual bool eventFilter(QObject * o,QEvent *e);
//	void slot_editToolBar();
	void popupClicked(const KviStr &dataBuffer);
};


class KviUserToolBarTemplate
{
public:
	KviUserToolBarTemplate();
	~KviUserToolBarTemplate();
private:
	int m_id;
public:
	enum ToolButtonType { Separator, Button, Menu };
	QList<KviUserToolBarData> * m_pDataList;
	void copyFromToolBar(KviUserToolBar *toolbar);
	int insertSeparatorItem();
	int insertNormalItem(const char *name, const char *sbar,const char *img,const char *buffer, KviPopupMenu * menu=0);
	static bool saveToolBarTemplate(const char *filename);
	static bool loadToolBarTemplate(const char *filename,KviStr &error);
	bool isEmpty();
	void clearToolBar();
private:
	void save(QFile *f);
	void buildDataBuffer(KviStr &str);
	bool loadFromDataBuffer(KviStr &buffer,KviStr &error);
};

class KviToolButton : public KviToolBarButton
{
	Q_OBJECT
public:
	KviToolButton(int id, const QPixmap & pm, const char * textLabel, const char * grouptext, QObject * receiver, const char * slot, QToolBar * parent);
	~KviToolButton();
private:
	int m_BtnId;
signals:
	void idClicked(int);
public slots:
	void wasClicked();
};

#endif //!_KVI_UTOOLBAR_H_INCLUDED_
