#ifndef _KVI_DLGSCRIPT_H_INCLUDED_
#define _KVI_DLGSCRIPT_H_INCLUDED_

//
//   File : kvi_dlgscript.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgscript.h)
//   Last major modification : Sun Feb 26 2000 03:54:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#include <qtabdialog.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qvbox.h>
#include <qlist.h>

#include "kvi_string.h"

class KviAliasManager;
class KviEventManager;
class KviScriptEditor;
class KviPopupMenu;
class KviUserToolBar;

class KviListView;


//================ class KviAliasNameValidator ==============

class KviAliasNameValidator : public QValidator
{
	Q_OBJECT
public:
	KviAliasNameValidator(QWidget * parent):QValidator(parent){};
	~KviAliasNameValidator(){};
	QValidator::State validate(QString & str,int &) const;
};



class KviScriptDataListViewItem : public QListViewItem
{
public:
	KviScriptDataListViewItem(QListView * lb,const char * buffer,const char * data0,const char *data1 = 0,const char * data2 = 0,const char * data3 = 0);
	~KviScriptDataListViewItem();
public:
	KviStr m_szBuffer;
public:
	void makeKey(KviStr &keyBuffer);
};




class KviAliasEditor : public QWidget
{
	Q_OBJECT
public:
	KviAliasEditor(QWidget * parent,const char *name = 0);
	~KviAliasEditor();
public:
	QListView                 * m_pListView;
	QLineEdit                 * m_pLineEdit;
	QPushButton               * m_pNew;
	QPushButton               * m_pDelete;
	QPushButton               * m_pClear;
	KviScriptEditor           * m_pEditor;
	KviScriptDataListViewItem * m_pCurItem;
	QPushButton               * m_pEditName;
public:
	void commit();
protected:
	void fillListView();
	void commitAliasName();
protected slots:
	void editAliasName();
	void listViewSelectionChanged(QListViewItem *it);
	void saveCurrentItem();
	void makeNewAlias();
	void deleteCurrentAlias();
	void clearAllAliases();
	KviScriptDataListViewItem * findAlias(const char *name);
protected:
	bool eventFilter(QObject *o,QEvent *e);
};



class KviScriptObjectClassDefinition;
class KviScriptObject;

class KviObjectViewer : public QWidget
{
	Q_OBJECT
public:
	KviObjectViewer(QWidget * parent,const char *name = 0);
	~KviObjectViewer();
public:
	QListView * m_pObjectView;
	QListView * m_pClassView;
	QListView * m_pFncView;
public:
	void fillViews();
	void fillClassDefinition(QListViewItem * p,KviScriptObjectClassDefinition * d);
	void fillObjectItem(QListViewItem * p,KviScriptObject * o);
protected slots:
	void classViewCurrentChanged(QListViewItem *it);
};




class KviRawEventEditor : public QWidget
{
	Q_OBJECT
public:
	KviRawEventEditor(QWidget * parent,const char * name);
	~KviRawEventEditor();
public:
	KviScriptDataListViewItem * m_pCurItem;
	KviListView     * m_pListView;
	KviScriptEditor * m_pScriptEditor;
	QPushButton     * m_pNew;
	QPushButton     * m_pDelete;
	QPushButton     * m_pClear;
public:
	void commit();
protected:
	void fillEventListView();
	void saveCurrentItem();
	KviScriptDataListViewItem * findEventItem(const char * item_key);
protected slots:
	void makeNewEvent();
	void deleteCurEvent();
	void clearAllEvents();
	void listViewSelectionChanged(QListViewItem *it);
};



class KviEventEditor : public QWidget
{
	Q_OBJECT
public:
	KviEventEditor(QWidget * parent,const char * name);
	~KviEventEditor();
public:
	QListView       * m_pListView;
	KviScriptEditor * m_pScriptEditor;
	QLabel          * m_pParamsLabel;
	QCheckBox       * m_pEnabled;
	QPushButton     * m_pClear;
	KviScriptDataListViewItem * m_pCurItem;
public:
	void commit();
protected:
	KviScriptDataListViewItem * findEventItem(const char * item_key);
	void fillEventListView();
	void saveCurrentItem();
protected slots:
	void listViewSelectionChanged(QListViewItem *it);
	void clearAllHandlers();
	void enableCheckToggled(bool bEnabled);
};


//================ POPUPS ===================//

typedef struct _KviPopupClipboardItem KviPopupClipboardItem;

class KviPopupListViewItem : public QListViewItem
{
public:
	enum PopupItemType { Submenu , Separator , Item };
	KviPopupListViewItem(PopupItemType t,KviPopupListViewItem * parent,const char * name,const char *type,const char *buffer = 0,const char *icon = 0);
	KviPopupListViewItem(PopupItemType t,KviPopupListViewItem * parent,KviPopupListViewItem * after,const char * name,const char *type,const char *buffer = 0,const char *icon = 0);
	KviPopupListViewItem(PopupItemType t,QListView * parent,const char *name,const char *type,const char *buffer = 0,const char *icon = 0);
	KviPopupListViewItem(PopupItemType t,QListView * parent,KviPopupListViewItem * after,const char *name,const char *type,const char *buffer = 0,const char *icon = 0);
	~KviPopupListViewItem();
public:
	KviStr m_buffer;
	KviStr m_icon;
	PopupItemType m_type;
	int m_id;
public:
	void tryLoadImage();
	KviPopupClipboardItem * getClipboardItem();
};

typedef struct _KviPopupClipboardItem
{
	KviStr szName;
	KviStr szBuffer;
	KviStr szIcon;
	KviPopupListViewItem::PopupItemType type;
	QList<KviPopupClipboardItem> * pItemList;
} KviPopupClipboardItem;

class KviPopupEditor : public QWidget
{
	Q_OBJECT
public:
	KviPopupEditor(QWidget * parent,const char * name = 0);
	~KviPopupEditor();
public:
	KviPopupMenu         * m_pConsolePopup;
	KviPopupMenu         * m_pChannelPopup;
	KviPopupMenu         * m_pQueryPopup;
	KviPopupMenu         * m_pUserlistPopup;
	KviPopupMenu         * m_pNotifylistPopup;
	KviPopupMenu         * m_pDccChatPopup;
	KviPopupMenu         * m_pEditedMenu;
	QListView            * m_pPopupView;
	QComboBox            * m_pPopupsBox;
	QPopupMenu           * m_pPopupPopup;
	KviScriptEditor      * m_pPopupEditor;
	QPopupMenu           * m_pIconPopup;
	QLineEdit            * m_pPopupIconEditor;
	QLineEdit            * m_pPopupNameEditor;
	KviPopupListViewItem * m_pEditedPopupItem;
	KviPopupClipboardItem * m_pClipboardItem;

/*
	KviStr                 m_szClipboardItemName;
	KviStr                 m_szClipboardItemBuffer;
	KviStr                 m_szClipboardItemIcon;
*/
protected:
	KviPopupListViewItem * pasteClipboard(KviPopupListViewItem * par,KviPopupListViewItem * aft,KviPopupClipboardItem * it,bool bNullAfter = false);
	void destroyClipboardItem(KviPopupClipboardItem * i);
	void destroyClipboard();
	void saveMenu(KviPopupMenu *p);
	bool selectPopupItemById(KviPopupListViewItem * par,int id);
	void startEditPopup(KviPopupMenu * p);
	void disablePopupEditors();
	void appendChildPopup(KviPopupListViewItem * parent,KviPopupMenu *p);
	void savePopupItem(KviPopupListViewItem * p);
	void saveSubmenu(KviPopupMenu *p,KviPopupListViewItem *par);
public:
	void commit();
	bool eventFilter(QObject * o,QEvent *e);
protected slots:
	void removeEditedPopupItem();
	void popupViewRightButtonPressed(QListViewItem *i,const QPoint &p,int);
	void copyItem();
	void iconPopupActivated(int id);
	void addEmptyPopupItem();
	void pasteItemBelow();
	void pasteItemInside();
	void pasteItemAbove();
	void addEmptyPopupItemAbove();
	void addSubmenuItemAbove();
	void addSeparatorItemAbove();
	void addEmptyPopupItemInside();
	void addSubmenuItemInside();
	void addSubmenuItem();
	void addSeparatorItem();
	void testCurrentPopup();
	void clearCurrentPopup();
	void testPopupSlot(int id);
	void popupComboSelectionChanged(int index);
	void popupItemSelected(QListViewItem *i);
};


// ===================== class KviToolBarListViewItem ======================

class KviToolBarListViewItem : public QListViewItem
{
public:
	enum ToolButtonType { Separator , Button, Menu, Submenu, Item };
	// Add item
	KviToolBarListViewItem(ToolButtonType t,QListView * parent,const char *name,const char *type,const char *buffer = 0,const char *icon = 0, const char *sbar = 0);
	// Add item below
	KviToolBarListViewItem(ToolButtonType t,QListView * parent,KviToolBarListViewItem * after,const char *name,const char *type,const char *buffer=0,const char *icon=0, const char *sbar=0);
	// Add menu
	KviToolBarListViewItem(ToolButtonType t,KviToolBarListViewItem * parent,const char * name,const char *type,const char *buffer,const char *icon, const char *sbar=0);
	// Add menu below
	KviToolBarListViewItem(ToolButtonType t,KviToolBarListViewItem * parent,KviToolBarListViewItem * after,const char * name,const char *type,const char *buffer,const char *icon, const char *sbar=0);

	~KviToolBarListViewItem();
public:
	KviStr	m_buffer;
	KviStr	m_icon;
	KviStr	m_sbar;
	int		m_id;
	ToolButtonType m_type;
public:
	void tryLoadImage();
};


class KviUToolBarEditor : public QWidget
{
	Q_OBJECT
public:
	KviUToolBarEditor(QWidget * parent,const char *name = 0);
	~KviUToolBarEditor();
protected:
	KviUserToolBar  * m_pToolBar;
	KviUserToolBar  * m_pEditedToolBar;
	QListView       * m_pToolBarView;
	QLineEdit       * m_pToolBarIconEditor;
	QLineEdit       * m_pToolBarNameEditor;
	QLineEdit       * m_pToolBarStatusBarEditor;
	QPopupMenu      * m_pToolBarPopup;
	KviScriptEditor * m_pToolBarEditor;
	KviToolBarListViewItem * m_pEditedToolButton;
	QPopupMenu      * m_pIconPopup;
	KviStr            m_szClipboardItemBuffer;
	KviStr            m_szClipboardItemIcon;
	KviStr            m_szClipboardItemName;
	KviStr            m_szClipboardItemSbar;
public:
	void commit();
	bool eventFilter(QObject *o,QEvent *e);
protected:
	void startEditToolBar(KviUserToolBar * p);
	void appendToolButton(KviUserToolBar *p);
	void appendToolBarMenu(KviToolBarListViewItem *parent, KviPopupMenu *p);
//	void appendChildPopup(KviToolBarListViewItem * parent,KviUserToolBar *p);
	void disableToolBarEditors();
	void saveToolButton(KviToolBarListViewItem * p);
	void saveToolBar(KviUserToolBar *p);
	void updateToolBar(KviUserToolBar *p,KviToolBarListViewItem *par);
	void saveToolBarMenu(KviPopupMenu *p,KviToolBarListViewItem *par);
protected slots:
	void iconPopupActivated(int id);
	void toolButtonSelected(QListViewItem *i);
	void toolBarViewRightButtonPressed(QListViewItem *i,const QPoint &p,int);
	void removeEditedToolButton();
	void clearToolBar();
	void addToolBarMenu();
	void addToolBarMenuAbove();
	void addEmptyToolButton();//Below
	void addToolBarSeparatorItem(); //Below
	void addEmptyToolButtonAbove();
	void addToolBarSeparatorItemAbove();
	void copyToolButton();
	void pasteToolButtonBelow();
	void pasteToolButtonAbove();
	bool selectToolButtonById(KviToolBarListViewItem * par,int id);
};



class KviVariablesEditor : public QWidget
{
	Q_OBJECT
public:
	KviVariablesEditor(QWidget * parent,const char *name = 0);
	~KviVariablesEditor();
protected:
	KviScriptEditor * m_pVariablesEditor;
	bool              m_bVariablesChanged;
public:
	void fillVariablesEditor();
	void commit();
protected slots:
	void variablesTextChanged();
};


class KviCodeTester : public QWidget
{
	Q_OBJECT
public:
	KviCodeTester(QWidget * parent,const char *name = 0);
	~KviCodeTester();
protected:
	KviScriptEditor * m_pCodeEditor;
	QLineEdit       * m_pWindowNameEdit;
protected slots:
	void test();
};



// ================ class KviDlgScript ===================

//class KviDlgScript : public QTabDialog
//{
//	Q_OBJECT
//public:
//	KviDlgScript();
//	~KviDlgScript();
//private:
//	KviAliasEditor     * m_pAliasEditor;
//	KviRawEventEditor  * m_pRawEventEditor;
//	KviEventEditor     * m_pHiLevelEventEditor;
//	KviPopupEditor     * m_pThePopupEditor;
//	KviUToolBarEditor  * m_pUToolBarEditor;
//	KviVariablesEditor * m_pVariablesEditor;
//private:
//	virtual bool focusNextPrevChild(bool next);
//signals:
//	void finished(bool bAccepted);
//protected slots:
//	virtual void done(int r);
//	virtual void closeEvent(QCloseEvent *);
//};

class KviHelpWindow;

class KviScriptCenter : public QWidget
{
	Q_OBJECT
public:
	KviScriptCenter(QWidget * parent = 0);
	~KviScriptCenter();
protected:
	KviAliasEditor     * m_pAliasEditor;
	KviRawEventEditor  * m_pRawEventEditor;
	KviEventEditor     * m_pHiLevelEventEditor;
	KviPopupEditor     * m_pThePopupEditor;
	KviUToolBarEditor  * m_pUToolBarEditor;
	KviVariablesEditor * m_pVariablesEditor;
	KviObjectViewer    * m_pObjectViewer;
	KviCodeTester      * m_pCodeTester;
	KviHelpWindow      * m_pHelpWindow;
	QTabWidget         * m_pTabWidget;
protected:
	virtual void closeEvent(QCloseEvent *e);
	bool focusNextPrevChild(bool next);
protected slots:
	void acceptClicked();
	void rejectClicked();
	void applyClicked();
signals:
	void closed();
};



#endif //!_KVI_DLGSCRIPT_H_INCLUDED_
