//
//   File : kvi_xutils.cpp (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_xutils.cpp)
//   Last major modification : Wed Jan 6 1999 14:53:41 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_xutils.h"
#include <qnamespace.h>

void kvi_xDraw3dRect(Display *dpy,GC gc,Drawable d,const QColorGroup &cg,int x1,int y1,int x2,int y2,bool bSunken)
{
	//Need to draw the sunken rect around the view now...
//	XSetLineAttributes(dpy,gc,1,LineSolid,CapButt,JoinMiter);
	if(bSunken)XSetForeground(dpy,gc,cg.dark().pixel());
	else XSetForeground(dpy,gc,cg.light().pixel());
	XDrawLine(dpy,d,gc,x1,y1,x2,y1);
	XDrawLine(dpy,d,gc,x1,y1+1,x1,y2);
	if(bSunken)XSetForeground(dpy,gc,cg.light().pixel());
	else XSetForeground(dpy,gc,cg.dark().pixel());
	XDrawLine(dpy,d,gc,x2,y2,x2,y1);
	XDrawLine(dpy,d,gc,x2-1,y2,x1,y2);
}

/* FIXME "MOVE KviMdiManager::drawDragRectangle to kvi_drawDragRectangle" */

void kvi_drawDragRectangle(QRect &rectToDraw,Drawable drw,int style)
{
	if(drw == 0)drw = qt_xrootwin();
	if (!rectToDraw.isNull()){
		XGCValues gcvals;
		gcvals.foreground=Qt::black.pixel();
		gcvals.subwindow_mode=IncludeInferiors;
		gcvals.function=GXinvert;
        
		Display * d = qt_xdisplay();
		GC gc=XCreateGC(d,drw,GCForeground|GCSubwindowMode|GCFunction,&gcvals);
		XDrawRectangle(d,drw,gc,rectToDraw.x(),rectToDraw.y(),rectToDraw.width(),rectToDraw.height());
		if(style > 0){
			XDrawRectangle(d,drw,gc,rectToDraw.x()+2,rectToDraw.y()+2,rectToDraw.width()-4,rectToDraw.height()-4);
		}
		XDrawRectangle(d,drw,gc,rectToDraw.x()+1,rectToDraw.y()+1,rectToDraw.width()-2,rectToDraw.height()-2);
		XFreeGC(d,gc);
	}
}


