/***************************************************************************
                          ckvdrcfg.cpp  -  description
                             -------------------
    begin                : Fri Aug 11 2000
    copyright            : (C) 2000 by Guido
    email                : gfiala@s.netic.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define QT_CLEAN_NAMESPACE
#include "ckvdrcfg.h"
#include <qdir.h>
#include <qpixmap.h>
#include <kwin.h>
#include <qstring.h>
#include <qmessagebox.h>
//#include <sys/types.h>
//#include <sys/stat.h>
#include <fcntl.h>
#include "kvdr.h"
#include "kvdr.xpm"

ckvdrcfg::ckvdrcfg(QWidget *parent, const char *name)
: QDialog(0,name,false)
{
  initDialog();
  ckvdrcfg::p=parent;

  //take the actual settings:
  dISPAL=((Kvdr*)p)->isPAL;
  dVideoAspectRatio=((Kvdr*)p)->video_aspect_ratio;
  dInitialWidth=((Kvdr*)p)->i_size_x;
  dInitialHeight=((Kvdr*)p)->i_size_y;
  dGrabWidth=((Kvdr*)p)->i_g_size_x;
  dGrabHeight=((Kvdr*)p)->i_g_size_y;
  dJpgQuality=((Kvdr*)p)->i_jpg_qual;
  dVdrPort=((Kvdr*)p)->vdr_port;
  dColour=((Kvdr*)p)->colour;
  dBrightness=((Kvdr*)p)->brightness;
  dHue=((Kvdr*)p)->hue;
  dContrast=((Kvdr*)p)->contrast;
  dBaseDir=((Kvdr*)p)->basename;
  dVolume=((Kvdr*)p)->Volume;
  dFrontRear=((Kvdr*)p)->FrontRear;
  dMixerChannel=((Kvdr*)p)->MixerChannel;
  dVidDev=((Kvdr*)p)->VidDev;
  //set the actual settings:
  if(dISPAL)
  {
    QRadioButton_1->setChecked(true);
  }
  else
  {
    QRadioButton_2->setChecked(true);
  }
  if(dVideoAspectRatio<1.5)
  {
    QRadioButton_4_3->setChecked(true);
  }
  else
  {
    QRadioButton_16_9->setChecked(true);
  }
  QString t;
  t.sprintf("%d",dInitialWidth);InitialWidth->setText(t);
  t.sprintf("%d",dInitialHeight);InitialHeight->setText(t);
  t.sprintf("%d",dGrabHeight);GrabHeight->setText(t);
  t.sprintf("%d",dGrabWidth);GrabWidth->setText(t);
  t.sprintf("%d",dJpgQuality);JpgQuality->setText(t);
  t.sprintf("%d",dVdrPort);VdrPort->setText(t);
  BaseDir->setText(dBaseDir);
  VolumeSlider->setValue(dVolume);
  VolumeSlider->setTickmarks(QSlider::Right);
  VolumeSlider->setTickInterval( 10 );
  FrontRearSlider->setValue(dFrontRear);
  FrontRearSlider->setTickmarks( QSlider::Right );
  FrontRearSlider->setTickInterval( 10 );
  BrightnessSlider->setValue(dBrightness);
  BrightnessSlider->setTickmarks( QSlider::Right );
  BrightnessSlider->setTickInterval( 8192 );
  HueSlider->setValue(dHue);
  HueSlider->setTickmarks( QSlider::Right );
  HueSlider->setTickInterval( 8192 );
  ColourSlider->setValue(dColour);
  ColourSlider->setTickmarks( QSlider::Right );
  ColourSlider->setTickInterval( 8192 );
  ContrastSlider->setValue(dContrast);
  ContrastSlider->setTickmarks( QSlider::Right );
  ContrastSlider->setTickInterval( 8192 );
  MixerChannel->clear();
  MixerChannel->insertStrList( &(((Kvdr*)p)->mixerdevlist),0);
  MixerChannel->setCurrentItem(dMixerChannel);
  QSpinBox_VidDev->setValue(dVidDev);
  //connect Signals...
  connect( ApplyButton, SIGNAL(clicked()), SLOT(ApplyButtonClicked()) );
  connect( CancelButton, SIGNAL(clicked()), SLOT(CancelButtonClicked()) );
  connect( StoreButton, SIGNAL(clicked()), SLOT(StoreButtonClicked()) );
  connect( CreditsButton, SIGNAL(clicked()),SLOT(CreditsButtonClicked()));
  connect( QButtonGroupNorm, SIGNAL(clicked(int)), SLOT(QButtonGroupNormClicked(int)) );
  connect( QButtonGroupAR,SIGNAL(clicked(int)),SLOT(QButtonGroupARClicked(int)) );

  connect( InitialWidth, SIGNAL(returnPressed()),
           SLOT(InitialWidthChanged()) );
  connect( InitialHeight, SIGNAL(returnPressed()),
           SLOT(InitialHeightChanged()) );
  connect( GrabHeight, SIGNAL(returnPressed()),
           SLOT(GrabHeightChanged()) );
  connect( GrabWidth, SIGNAL(returnPressed()),
           SLOT(GrabWidthChanged()) );
  connect( BaseDir, SIGNAL(returnPressed()),
           SLOT(BaseDirChanged()) );
  connect( JpgQuality, SIGNAL(returnPressed()),
           SLOT(JpgQualityChanged()) );
  CreditsButton->setPixmap(QPixmap((const char **)kvdr));

  setIcon(QPixmap((const char **)kvdr));
  setIconText("kvdr-config");

  connect( VolumeSlider, SIGNAL(valueChanged(int)), SLOT(VolumeSliderValueChanged(int)) );
  connect( FrontRearSlider, SIGNAL(valueChanged(int)), SLOT(FrontRearSliderValueChanged(int)) );
  connect( ColourSlider,SIGNAL(valueChanged(int)),SLOT(ColourSliderValueChanged(int)) );
  connect(BrightnessSlider,SIGNAL(valueChanged(int)),
          SLOT(BrightnessSliderValueChanged(int)));
  connect(HueSlider,SIGNAL(valueChanged(int)),
          SLOT(HueSliderValueChanged(int)));
  connect(ContrastSlider,SIGNAL(valueChanged(int)),
          SLOT(ContrastSliderValueChanged(int)));
  connect( MixerChannel, SIGNAL(activated(int)), SLOT(MixerChannelItemActivated(int)) );
  connect( QSpinBox_VidDev, SIGNAL(valueChanged(int)), SLOT(QSpinBox_VidDev_Changed(int)) );

  //accelerators for config-dialog:
  userKeys = new KAccel( this );
  userKeys->insertItem(i18n("Cancel"),"Cancel",Key_Escape);
  userKeys->connectItem("Cancel",this,SLOT(CancelButtonClicked()));
  userKeys->insertItem(i18n("Cancel"),"Cancel",CTRL|Key_C);
  userKeys->connectItem("Cancel",this,SLOT(CancelButtonClicked()));
  userKeys->insertItem(i18n("Apply"),"Apply",CTRL|Key_A);
  userKeys->connectItem("Apply",this,SLOT(ApplyButtonClicked()));
  userKeys->insertItem(i18n("Store"),"Store",CTRL|Key_S);
  userKeys->connectItem("Store",this,SLOT(StoreButtonClicked()));
}

ckvdrcfg::~ckvdrcfg()
{
  delete userKeys;
}

void ckvdrcfg::show()
{
  dVolume=((Kvdr*)p)->Volume;
  dFrontRear=((Kvdr*)p)->FrontRear;
  VolumeSlider->setValue(dVolume);
  FrontRearSlider->setValue(dFrontRear);
  QDialog::show();
}

void ckvdrcfg::ApplyButtonClicked()
{
  //call all Lineedit-Slots to actualize the values:
  InitialWidthChanged();InitialHeightChanged();
  GrabWidthChanged();GrabHeightChanged();
  BaseDirChanged();JpgQualityChanged();
  VdrPortChanged();
  //take the actual settings:
  ((Kvdr*)p)->isPAL=dISPAL;
  ((Kvdr*)p)->video_aspect_ratio=dVideoAspectRatio;
  ((Kvdr*)p)->aspect_ratio=dVideoAspectRatio*((Kvdr*)p)->display_width/
                                             ((Kvdr*)p)->display_height/1.33;
  ((Kvdr*)p)->i_size_x=dInitialWidth;
  ((Kvdr*)p)->i_size_y=dInitialHeight;
  ((Kvdr*)p)->i_g_size_x=dGrabWidth;
  ((Kvdr*)p)->i_g_size_y=dGrabHeight;
  ((Kvdr*)p)->i_jpg_qual=dJpgQuality;
  ((Kvdr*)p)->colour=dColour;
  ((Kvdr*)p)->brightness=dBrightness;
  ((Kvdr*)p)->hue=dHue;
  ((Kvdr*)p)->contrast=dContrast;
  ((Kvdr*)p)->basename=dBaseDir;
  ((Kvdr*)p)->vdr_port=dVdrPort;
  ((Kvdr*)p)->Volume=dVolume;
  ((Kvdr*)p)->FrontRear=dFrontRear;
  ((Kvdr*)p)->MixerChannel=dMixerChannel;
  ((Kvdr*)p)->StrMixerChannel=MixerChannel->currentText();
  ((Kvdr*)p)->VidDev=dVidDev;
  if (dInitialWidth>0) ((Kvdr*)p)->resize(((Kvdr*)p)->i_size_x,((Kvdr*)p)->i_size_y);
  //close the dialog
  QDialog::done(true);
}

void ckvdrcfg::CancelButtonClicked()
{
  if(!((Kvdr*)p)->ismute)
  {
    ((Kvdr*)p)->SetVolume(((Kvdr*)p)->Volume,((Kvdr*)p)->StrMixerChannel,((Kvdr*)p)->FrontRear);
  }
  ((Kvdr*)p)->OvlP(((Kvdr*)p)->brightness,((Kvdr*)p)->colour,
                         ((Kvdr*)p)->hue,((Kvdr*)p)->contrast);
  //close the dialog
  QDialog::done(false);
}

void ckvdrcfg::StoreButtonClicked()
{
  //call all Lineedit-Slots to actualize the values:
  InitialWidthChanged();InitialHeightChanged();
  GrabWidthChanged();GrabHeightChanged();
  BaseDirChanged();JpgQualityChanged();
  VdrPortChanged();
  //take the actual settings:
  ((Kvdr*)p)->isPAL=dISPAL;
  ((Kvdr*)p)->video_aspect_ratio=dVideoAspectRatio;
  ((Kvdr*)p)->aspect_ratio=dVideoAspectRatio*((Kvdr*)p)->display_width/
                                             ((Kvdr*)p)->display_height/1.33;
  ((Kvdr*)p)->i_size_x=dInitialWidth;
  ((Kvdr*)p)->i_size_y=dInitialHeight;
  ((Kvdr*)p)->i_g_size_x=dGrabWidth;
  ((Kvdr*)p)->i_g_size_y=dGrabHeight;
  ((Kvdr*)p)->i_jpg_qual=dJpgQuality;
  ((Kvdr*)p)->colour=dColour;
  ((Kvdr*)p)->brightness=dBrightness;
  ((Kvdr*)p)->hue=dHue;
  ((Kvdr*)p)->contrast=dContrast;
  ((Kvdr*)p)->basename=dBaseDir;
  ((Kvdr*)p)->vdr_port=dVdrPort;
  ((Kvdr*)p)->Volume=dVolume;
  ((Kvdr*)p)->FrontRear=dFrontRear;
  ((Kvdr*)p)->MixerChannel=dMixerChannel;
  ((Kvdr*)p)->StrMixerChannel=MixerChannel->currentText();
  ((Kvdr*)p)->VidDev=dVidDev;
  if (dInitialWidth>0) ((Kvdr*)p)->resize(((Kvdr*)p)->i_size_x,((Kvdr*)p)->i_size_y);
  //save them to file:
  ((Kvdr*)p)->save_kvdrrc();
  //close the dialog
  QDialog::done(true);
}

void ckvdrcfg::CreditsButtonClicked()
{
	QString s;
	s.sprintf("kvdr %s:   ",VERSION);
  QMessageBox::about(this,s,"Author: Guido Fiala <gfiala@s.netic.de>\n"\
                                  "Homepage: http://www.s.netic.de/gfiala");
}

void ckvdrcfg::QButtonGroupNormClicked(int i)
{
  if(i==1)
    dISPAL=false;
  else
    dISPAL=true;
}

void ckvdrcfg::QButtonGroupARClicked(int i)
{
  if(i==1)
    dVideoAspectRatio=16.0/9.0;
  else
    dVideoAspectRatio=4.0/3.0;
}

void ckvdrcfg::InitialWidthChanged()
{
  int temp=CheckNumber(InitialWidth->text(),0,2045);//dISPAL?768:640);
  if(temp>=0) dInitialWidth=temp;
  QString t;
  t.sprintf("%d",dInitialWidth);
  InitialWidth->setText(t);
}

void ckvdrcfg::InitialHeightChanged()
{
  int temp=CheckNumber(InitialHeight->text(),0,2048);//dISPAL?576:480);
  if(temp>=0) dInitialHeight=temp;
  QString t;
  t.sprintf("%d",dInitialHeight);
  InitialHeight->setText(t);
}

void ckvdrcfg::GrabHeightChanged()
{
  int temp=CheckNumber(GrabHeight->text(),50,dISPAL?576:480);
  if(temp>0) dGrabHeight=temp;
  QString t;
  t.sprintf("%d",dGrabHeight);
  GrabHeight->setText(t);
}

void ckvdrcfg::GrabWidthChanged()
{
  int temp=CheckNumber(GrabWidth->text(),50,dISPAL?768:640);
  if(temp>0) dGrabWidth=temp;
  QString t;
  t.sprintf("%d",dGrabWidth);
  GrabWidth->setText(t);
}

void ckvdrcfg::BaseDirChanged()
{
  QDir bdir(BaseDir->text());
  if (bdir.exists())
  {
    dBaseDir=BaseDir->text();
  }
  else
  {
    BaseDir->setText(dBaseDir);
    //ToDo:show Statusbar message!
  }
}

void ckvdrcfg::JpgQualityChanged()
{
  int temp=CheckNumber(JpgQuality->text(),0,100);
  if(temp>0) dJpgQuality=temp;
  QString t;
  t.sprintf("%d",dJpgQuality);
  JpgQuality->setText(t);
}


void ckvdrcfg::VdrPortChanged()
{
  int temp=CheckNumber(VdrPort->text(),2000,65535);
  if(temp>0) dVdrPort=temp;
  QString t;
  t.sprintf("%d",dVdrPort);
  VdrPort->setText(t);
  //port has changed, we have to reconfigure via SVDRPC:
  ((Kvdr*)p)->svdrpc->Close();
  ((Kvdr*)p)->svdrpc->Open(dVdrPort);
}

void ckvdrcfg::VolumeSliderValueChanged(int i)
{
  dVolume=i;
  ((Kvdr*)p)->SetVolume(dVolume,MixerChannel->currentText(),dFrontRear);
}

void ckvdrcfg::FrontRearSliderValueChanged(int i)
{
  dFrontRear=i;
  ((Kvdr*)p)->SetVolume(dVolume,MixerChannel->currentText(),dFrontRear);
}

void ckvdrcfg::ColourSliderValueChanged(int i)
{
  dColour=i;
  ((Kvdr*)p)->OvlP(dBrightness,dColour,dHue,dContrast);
}

void ckvdrcfg::BrightnessSliderValueChanged(int i)
{
  dBrightness=i;
  ((Kvdr*)p)->OvlP(dBrightness,dColour,dHue,dContrast);
}

void ckvdrcfg::HueSliderValueChanged(int i)
{
  dHue=i;
  ((Kvdr*)p)->OvlP(dBrightness,dColour,dHue,dContrast);
}

void ckvdrcfg::ContrastSliderValueChanged(int i)
{
  dContrast=i;
  ((Kvdr*)p)->OvlP(dBrightness,dColour,dHue,dContrast);
}

void ckvdrcfg::MixerChannelItemActivated(int i)
{
  dMixerChannel=i;
  ((Kvdr*)p)->SetVolume(dVolume,MixerChannel->currentText(),dFrontRear);
}

int ckvdrcfg::CheckNumber(const char* s,int min,int max)
{
  //remove any non-number-characters from string
  int number=0;
  if(1!=sscanf(s,"%d",&number))
  {
    //clear string!
    return -1;//not the best...
  }
  else
  {
    if(number>max)
    {
      return max;
    }
    else if(number<min)
    {
      return min;
    }
    else
    {
      return number;
    }
  }
}

void ckvdrcfg::QSpinBox_VidDev_Changed(int value)
{
  //change setting but ignore if ismultivideo!
	dVidDev=value;
	if (((Kvdr*)p)->video_fd.handle()!=-1)
	{
		((Kvdr*)p)->OverlayOnOffSLOT(-1);
		((Kvdr*)p)->video_fd.close();
	}
	QString s;
	s.sprintf("%s%d",DEFAULT_VIDEO_DEV,value);
	((Kvdr*)p)->video_fd.setName((const char*)s);
	((Kvdr*)p)->video_fd.open(IO_ReadWrite);
	if(-1!=((Kvdr*)p)->video_fd.handle())
	{
    ((Kvdr*)p)->OvlF(((Kvdr*)p)->display_width,((Kvdr*)p)->display_height,
                     (int)((Kvdr*)p)->base,((Kvdr*)p)->bpp,((Kvdr*)p)->palette);
    ((Kvdr*)p)->OvlP(((Kvdr*)p)->brightness,((Kvdr*)p)->colour,
                            ((Kvdr*)p)->hue,((Kvdr*)p)->contrast);
		((Kvdr*)p)->OverlayOnOffSLOT(1);
  }
}
