/***************************************************************************
                          logwidget.h  -  description
                             -------------------
    begin                : Mon Apr 30 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef LOGWIDGET_H
#define LOGWIDGET_H

#include <qwidget.h>
#include <qmultilineedit.h>
#include <qstring.h>

/**
  *@author Pascal Brachet
  */
const QColor bluelog   		= QColor(0x00, 0x00, 0xCC);
const QColor redlog  		= QColor(0xCC, 0x00, 0x00);
const QColor vertlog = QColor(0x00, 0x80, 0x00); //Green

struct shstruct {
   QString w;
   QColor c;
};
typedef shstruct synthi[3];
const synthi sytax=
	{
	{"LaTeX Warning",				bluelog},
	{"!" ,				redlog},
	{".tex" ,				vertlog}
	};


class LogWidget : public QMultiLineEdit  {
   Q_OBJECT
public:
	LogWidget(QWidget *parent=0, const char *name=0);
	~LogWidget();
protected:
  virtual void mouseReleaseEvent(QMouseEvent* event);
	inline int tabLength() {return fontMetrics().width("x")*8;};
	int textWidthWithTabs(QString s, int nChars);
	virtual void paintCell(QPainter *painter, int row, int col);
	virtual void setupPainter(QPainter *painter);
signals:
  void clicked();
};

#endif
