/**********************************************************************

	--- Qt Architect generated file ---

	File: rotation.cpp

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.    

 *********************************************************************/

#include "rotation.h"

#define Inherited rotationData

rotation::rotation
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "3D Rotation" );
}


rotation::~rotation()
{
}

void rotation::setGnuInterface(gnuInterface* gnu)
{
  gnuInt = gnu;

  int xAxisValue = gnuInt->getRotationXAxis();
  int zAxisValue = gnuInt->getRotationZAxis();
  string scale = gnuInt->getRotationScaling();
  string zscale = gnuInt->getRotationZAxisScaling();

  xAxis->setValue(xAxisValue);
  xAxisLCD->display(xAxisValue);
  zAxis->setValue(zAxisValue);
  zAxisLCD->display(zAxisValue);
  plotScalingEdit->setText(scale.c_str());
  zAxisScalingEdit->setText(zscale.c_str());
}

void rotation::doOK()
{  
  string scale = plotScalingEdit->text().data();
  string zscale = zAxisScalingEdit->text().data();

  gnuInt->setRotationXAxis(xAxisRotation);
  gnuInt->setRotationZAxis(zAxisRotation);
  gnuInt->setRotationScaling(scale);
  gnuInt->setRotationZAxisScaling(zscale);

  QDialog::accept();
}

void rotation::setDefaults()
{
  xAxis->setValue(60);
  xAxisLCD->display(60);
  zAxis->setValue(30);
  zAxisLCD->display(30);
  plotScalingEdit->setText("1");
  zAxisScalingEdit->setText("1");
}

void rotation::xAxisChanged(int num)
{
  xAxisLCD->display(num);
  xAxisRotation = num;
}

void rotation::zAxisChanged(int num)
{
  zAxisLCD->display(num);
  zAxisRotation = num;
}
