/* -------------------------- gnuCurveFit class --------------------------
   
   This is a class to create an object to handle curve fitting. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/
using namespace std;

#include <string>

#ifndef gnuCurveFit_included
#define gnuCurveFit_included

class gnuCurveFit
{
public:
  gnuCurveFit();
  /* Description:
       Constructor function */

  string getFitCmd();
  /* Description:
       Gets curve fitting command */

  void setFunctionName(string name);
  /* Description:
       Sets function name (left side of equal sign) to fit to */

  string getFunctionName();
  /* Description:
       Gets function name to fit to */

  void setFunctionValue(string function);
  /* Description:
       Sets function value (right side of equal sign) to fit to */

  string getFunctionValue();
  /* Description:
       Gets function value (right side of equal sign) to fit to  */

  void setDataFile(string file);
  /* Description:
       Sets data file for plotting */

  string getDataFile();
  /* Description:
       Gets data file for plotting  */

  void setVarXRangeName(string range);
  /* Description:
       Sets x variable name for xrange */

  string getVarXRangeName();
  /* Description:
       Gets x variable name for xrange  */

  void setVarXRangeMin(string min);
  /* Description:
       Sets x variable min value */

  string getVarXRangeMin();
  /* Description:
       Gets x variable min value */

  void setVarXRangeMax(string max);
  /* Description:
       Sets x variable max value */

  string getVarXRangeMax();
  /* Description:
       Gets x variable max value */

  void setVarYRangeName(string range);
  /* Description:
       Sets y variable name for yrange */

  string getVarYRangeName();
  /* Description:
       Gets y variable name for yrange */

  void setVarYRangeMin(string min);
  /* Description:
       Sets y variable min value */

  string getVarYRangeMin();
  /* Description:
       Gets y variable min value */

  void setVarYRangeMax(string max);
  /* Description:
       Sets y variable max value */

  string getVarYRangeMax();
  /* Description:
       Gets y variable max value */

  void setParamFile(string file);
  /* Description:
       Sets parameter file for plotting parameters */

  string getParamFile();
  /* Description:
       Gets parameter file for plotting parameters */

  void setParamFileFlag(int flag);
  /* Description:
       Sets flag for selecting parameter file vs comma seperated 
       value parameters */

  int getParamFileFlag();
  /* Description:
       Gets flag for selecting parameter file vs comma seperated 
       value parameters */

  void setParamCSLFlag(int flag);
  /* Description:
       Sets flag for selecting parameter file vs comma seperated 
       value parameters */ 

  int getParamCSLFlag();
  /* Description:
       Gets flag for selecting parameter file vs comma seperated 
       value parameters */

  void setParamCSL(string list);
  /* Description:
       Sets comma seperated list of plotting parameters */

  string getParamCSL();
  /* Description:
       Gets comma seperated list of plotting parameters */

  void setFitLimit(string limit);
  /* Description:
       Sets fit limit value for convergence */

  string getFitLimit();
  /* Description:
       Gets fit limit value for convergence */

  void setFitMaxIter(string iter);
  /* Description:
       Sets maximum number of iterations for non-convergence case */

  string getFitMaxIter();
  /* Description:
       Gets maximum number of iterations for non-convergence case */

  void setDataSetStart(string start);
  /* Description:
       Sets starting data set of the data file modifiers */

  string getDataSetStart();
  /* Description:
       Gets starting data set of the data file modifiers */

  void setDataSetEnd(string end);
  /* Description:
       Sets ending data set of the data file modifiers */

  string getDataSetEnd();
  /* Description:
       Gets ending data set of the data file modifiers */

  void setDataSetInc(string inc);
  /* Description:
       Sets data set increment of the data file modifiers */

  string getDataSetInc();
  /* Description:
       Gets data set increment of the data file modifiers */

  void setPointInc(string inc);
  /* Description:
       Sets the data point increment of the data file modifiers */

  string getPointInc();
  /* Description:
       Gets the data point increment of the data file modifiers */

  void setLineInc(string inc);
  /* Description:
       Sets the increment value for lines in data file (modifier) */

  string getLineInc();
  /* Description:
       Gets the increment value for lines in data file (modifier) */

  void setStartPoint(string start);
  /* Description:
       Sets the starting point in data file (modifier) */

  string getStartPoint();
  /* Description:
       Gets the starting point in data file (modifier) */

  void setStartLine(string start);
  /* Description:
       Sets the starting line in data file (modifier) */

  string getStartLine();
  /* Description:
       Gets the starting line in data file (modifier) */

  void setEndPoint(string end);
  /* Description:
       Sets the end point in data file (modifier) */

  string getEndPoint();
  /* Description:
       Gets the end point in data file (modifier) */

  void setEndLine(string end);
  /* Description:
       Sets the ending line in data file (modifier) */

  string getEndLine();
  /* Description:
       Gets the ending line in data file (modifier) */

  void setXColumn(string col);
  /* Description:
       Sets the x column from data file to plot (modifier) */

  string getXColumn();
  /* Description:
       Gets the x column from data file to plot (modifier) */

  void setYColumn(string col);
  /* Description:
       Sets the y column from data file to plot (modifier)  */

  string getYColumn();
  /* Description:
       Gets the y column from data file to plot (modifier) */

  void setZColumn(string col);
  /* Description:
       Sets the z column from data file to plot (modifier) */

  string getZColumn();
  /* Description:
       Gets the z column from data file to plot (modifier) */

  void setFormat(string informat);
  /* Description:
       Sets scanf format string for plotting from data file (modifier)
       (format should be surrounded with double quotes) */

  string getFormat();
  /* Description:
       Gets format string for plotting from data file (modifier)
       (format will be surrounded with double quotes) */

  void setRawFormat(string format);
  /* Description:
       Sets format string for plotting from data file (modifier)
       (no automatic quoting, must be supplied by user) */

  string getRawFormat();
  /* Description:
       Sets format string for plotting from data file (modifier)
       (no automatic quoting, must be supplied by user) */

private:
  string functionName;
  string functionValue;
  string dataFile;
  string varXRangeName;
  string varXRangeMin;
  string varXRangeMax;
  string varYRangeName;
  string varYRangeMin;
  string varYRangeMax;
  string paramFile;
  int paramFileFlag;
  int paramCSLFlag;
  string paramCSL;
  string fitLimit;
  string fitMaxIter;
  string dataSetStart;
  string dataSetEnd;
  string dataSetInc;
  string pointInc;
  string lineInc;
  string startPoint;
  string startLine;
  string endPoint;
  string endLine;
  string xColumn;
  string yColumn;
  string zColumn;
  string format;
  string rawFormat;
};

#endif // gnuCurveFit_included
