// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#ifndef QSUDOKUBUTTON_H
#define QSUDOKUBUTTON_H

#include <qwidget.h>
#include <kparts/part.h>
#include <qpainter.h>
#include "ksudokuview.h"
/**
@author Francesco Rossi
*/

class ksudokuView;
class QPaintEvent;

class QSudokuButton : public QWidget
{
Q_OBJECT
public:
    QSudokuButton(QWidget *parent = 0, const char *name = 0,   int xx=0, int yx=0);

    ~QSudokuButton();
	
public:
	void setValue(int n);
	void justmark(int n);
public:
	void resize();
	void paintEvent (QPaintEvent *); //2FIX
	void mousePressEvent (QMouseEvent *);
	void enterEvent (QEvent *);
	void exitEvent (QEvent *) ;
	void leaveEvent (QEvent *) ;
	void keyReleaseEvent ( QKeyEvent * e ) ;
	void keyPressEvent ( QKeyEvent * e ) ;
	
signals:
	void clicked2 (int , int );
	void enter(int , int );
	void leave(int, int );
	void rightclicked(int, int);
	
	void numberset(int,int,int);

	void beginHighlight(int val);
	void finishHighlight();

public slots:
	void animate();
public:
	bool mousein;
	bool highlighted[4];
	
	ksudokuView* p;

	bool wrong;

	bool given;
	bool justmarked;
	
	QString text;
	
	int x;
	int y;
	int value;
};

#endif
