/***************************************************************************
                          ksubtile.h  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSUBTILE_H
#define KSUBTILE_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>
#include "kprocess.h"
#include "ksubtileplayer.h"
#include <kdockwidget.h>
#include <qmenubar.h>

#include "csubtitles.h"

// forward declaration of the KSubtile classes
class KSubtileDoc;
class KSubtileView;
class KSubtilePlayer;

/**
  * The base class for KSubtile application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KSubtileView creates your center view, which is connected
  * to the window's Doc object.
  * KSubtileApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KSubtileApp : public KDockMainWindow
{
  Q_OBJECT

  friend class KSubtileView;

  public:
    /** construtor of KSubtileApp, calls all init functions to create the application.     */
    KSubtileApp(QWidget* parent=0, const char* name=0);
    ~KSubtileApp();
    /** opens a file specified by commandline option  */
    void openDocumentFile(const KURL& url=0);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
      * the View class to access the document object's methods     */
    KSubtileDoc *getDocument() const;

    /** The copied subtitles in memory
     */
    CSubtitles * copySubtitles;
        
//  KActionCollection* mActionCollection;

  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
      * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
      * be saved if Modified; on cancel the closeEvent is rejected.
      * @see KTMainWindow#queryClose
      * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
      * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
      * properties.
      * @see KTMainWindow#queryExit
      * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
      * opened file by a temporary filename provided by KApplication.
      * @see KTMainWindow#saveProperties
      */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

  public slots:
    /** open a new application window by creating a new instance of KSubtileApp */
    //    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
//     void slotFileOpenRecent(const KURL& url);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
      * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.  */
    void slotFileQuit();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();

    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
      * @param text the text that is displayed in the statusbar     */
    void slotStatusMsg(const QString &text);

    /**sets application in right modified state
	  * @param m modified or not
	 */
    void slotSetModified(bool m);

    /** searches for mplayer and enables/disables the player accordingly
	 */
    void slotSettingsCheckForMPlayer(void);

    /** invoked after we try to launch mplayer to detect if it exists
	 */
    void slotCheckForMPlayerTest(KProcess *);

	/** Imports subtitles which are not in the SRT format
	  * It asks the filename to import and a moviename if no movie is loaded into the player
	  */
	void slotFileImport(void);

    private slots:

	/** configure keybindings
	*/
	void optionsConfigureKeys();
//     void optionsConfigureToolbars();
    void optionsPreferences();
//     void newToolbarConfig();
    /** If we import, we ask a filename, then we load a movie into the player.  This slot is
	  * invoked after the movie is loaded into the player.  Then we can carry on with the import.
	  * @param fileName The filename of the loaded movie.  If it is "" then the movie was not a valid one accoring to the player
	  */
    void slotImportMovieLoaded(QString fileName);

  private:
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KSubtileView *view;
	/** The player object
	*/
	KSubtilePlayer *player;

    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KSubtileDoc *doc;

	/** used to find a menu in the toolbar provided a name
      * @return The submenu of the menu object with the sought name
	  * @param menu A menu object
	  * @param name The name of the menu we wish to find

	*/
    QPopupMenu* findMenu(QMenuData* menu, QString name);

	/** this is the filename of the subtitle file we will import, it is needed in the slotImportMovieLoaded
	  * @see slotImportMovieLoaded
	*/
	QString fileToImport;
	/** Actually imports the file into the editor
	  * @param fileName The filename of the subtitle file
	  * @param movieFileName The filename of the movie
	  */
    void importFile(QString fileName, QString movieFileName);

    // KAction pointers to enable/disable actions
    KAction* fileNew;
    KAction* fileOpen;
//     KRecentFilesAction* fileOpenRecent;
    KAction* fileSave;
    KAction* fileSaveAs;
    KAction* fileQuit;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;
    KAction* settingsCheckForMPlayer;
    KAction* fileImport;

};

#endif // KSUBTILE_H
