/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ksociograma.h"
#include "coverwindow.h"
#include <qobject.h>
#include <qtimer.h> 

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kactioncollection.h>
#include "ksociogramaMainWindow.h"
#include <kaboutdata.h>



static const char description[] =
    I18N_NOOP("Ksociograma is an application for make sociological analysis of a students group.");

static const char version[] = "2.0.1";

KAboutData *about = new KAboutData("ksociograma", I18N_NOOP("ksociograma"), version, description, KAboutData::License_GPL, "(C) 2004 Manuel Pérez López","\n", "http://www.ieduca.net/ksociograma/", "mapelo@ieduca.net");











int main(int argc, char **argv)
{


about->addAuthor ("Manuel Pérez López", I18N_NOOP("Project manager and developer"), "mapelo@ieduca.net", "http://www.ieduca.net/" );

about->addCredit( "Antonio Prioglio and Mario Fux", I18N_NOOP("For correcting my little English (...but the mistakes still are mine ;-) )."), 0 );

 about->addCredit( "Pedro Jurado Maqueda (melenas) and Juan Manuel Garcia Molina", I18N_NOOP("For creating the Debian packages."), 0 );

 about->addCredit( "José Ramón Villa (capi_x)", I18N_NOOP("For creating the RPM packages."), 0 );

 about->addCredit( "'C++ con clase' team,  kde-devel list and kde-devel-es list", I18N_NOOP("For introducing me to C++ and KDE."), 0 );

 about->addCredit( "Encarnación Alcantara López", I18N_NOOP("For her understanding that this is an important project for me."), 0 );












        static KCmdLineOptions options[] ={
        //{ "+[URL]", I18N_NOOP( "Document to open." ), 0 },
        KCmdLineLastOption
        };
        KCmdLineArgs::init(argc, argv, about);
        KCmdLineArgs::addCmdLineOptions(options);
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
                     
        KApplication app;
        
        
        
        
        
	coverWindow *coverWin = new coverWindow();
	
        QTimer *timer1 = new QTimer(coverWin);
        QObject::connect( timer1, SIGNAL(timeout()), coverWin, SLOT(timeOut() ));
        timer1->start( 3000, TRUE ); // 3 seconds single-shot timer
        
        //centrar en la pantalla el coverWin
        QRect qRect(QApplication::desktop()->screenGeometry());
        int iXpos=qRect.width()/2-coverWin->width()/2;
        int iYpos=qRect.height()/2-coverWin->height()/2;
        coverWin->move(iXpos,iYpos);
         
        coverWin->show();
        
        
        
        
        
        
        
        
        
        
        
	
        ksociogramaMainWindow *mainWin = new ksociogramaMainWindow();
        app.setMainWidget( mainWin );
        //no se muestra ahora, se mostrar 3 segundos despues

        QTimer *timer2 = new QTimer(mainWin);
        QObject::connect( timer2, SIGNAL(timeout()), mainWin, SLOT(timeOut() ));
        timer2->start( 1000, TRUE );
        
        
       
        
        
       
        
        

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

