/***************************************************************************
                          plugin.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

#include "batchrenamer.h"

#include <qobject.h>

class HelpDialogData;

class QString;
class QStringList;
class QWidget;
class QVBoxLayout;
class Plugin : public QObject {
    Q_OBJECT
    public:
        Plugin();
        virtual ~Plugin();

        virtual const QString getName() const = 0;
        virtual const QString getAccelName() const = 0;
        virtual const QString getPattern() const;
        virtual const int type() const = 0;
        virtual bool alwaysUsed() const;

        virtual bool checkError() = 0;
        virtual void drawInterface( QWidget* w, QVBoxLayout* l ) = 0;
        virtual void fillStructure() { }
        virtual QString processFile( BatchRenamer* b, int i, QString token, int mode ) = 0;
        virtual void finished() { }
        
        virtual void addHelp( HelpDialogData* data );
        virtual void removeHelp(  HelpDialogData* data );

        virtual void clearCache();
        
        virtual const QPixmap getIcon() const;
        virtual const QStringList getKeys() const;
};

#endif
