#ifndef KRECORD_H
#define KRECORD_H

#if 0
#include <qfiledialog.h>
#include <qmsgbox.h>
#include <qpopmenu.h>
#include <qmenubar.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qchkbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qlistbox.h>
#include <qaccel.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <kmenubar.h>
#include <kmainwindow.h>
#include <ktabctl.h>
#endif

class QDropEvent;

/* ------------------------------------------------------------------------ */

class KFFT : public KMainWindow
{
    Q_OBJECT;
public:
    KFFT(Soundcard *card);
    ~KFFT();

public slots:
    void showit();

private:
    FFTWindow     *fftwin;
};

class KLevel : public KMainWindow
{
    Q_OBJECT;
public:
    KLevel(Soundcard *card);
    ~KLevel();

protected:
    void resizeEvent( QResizeEvent * );

public slots:
    void showit();
    void updatelabels();
    void setvalue(char *text);
    void PowervsMaxClicked(int i);
    void LogvsLinearClicked(int i);

private:
    LevelWindow *levelwin;
    QWidget *thislevelwidget; 
    QButtonGroup *PowMaxGroup;
    QButtonGroup *LogLinGroup;
    QLabel *llabel;
    QLabel *mlabel;
    QLabel *rlabel;
};

/* ------------------------------------------------------------------------ */

class KRecord : public KMainWindow
{
    Q_OBJECT
public:
    KRecord();
    ~KRecord();
    Soundcard     *soundcard;
    SoundOptions  *soundopts;
    QFileDialog   *fdialog;
    QAccel        *accel;
    KFFT          *kfft;
    KLevel        *klevel;
    BufferList    *blist;
   
protected:
    void dropEvent(QDropEvent *);
    void dragEnterEvent(QDragEnterEvent* event);

public slots:
    void new_file();
    void save_as();
    void quit_cb();

    void record_options();
    void exec_mixer();
    void tb_toggle();
    void sl_toggle();

    void update_statusline(const char *text);
    void update_statusline(struct SOUNDPARAMS *p);

private:
    void create_menu();
    void create_toolbar();
    void create_soundbar();
    void create_statusline();

    QPopupMenu    *file_menu;
    QPopupMenu    *opt_menu;

    KToolBar      *toolbar;
    KToolBar      *soundbar;
    int            tb_mid;

    QListBox      *listwidget;

    KStatusBar    *statusline;
    int            sl_mid;
};

#endif
