// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ReadcdRipper.h"
#include "appmacros.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include <qmessagebox.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ReadcdRipper.moc"

bool ReadcdRipper::ripDataTrack(char *filename,long int lba_start,
				long int size_hint) {
  KConfig *config;

  char devline[32],fileline[1024],sectorline[64];
  int host,unit;
  QString cddev;

  prepareProcess();

  start_lba=lba_start;
  end_lba=lba_start+size_hint-1;

  config=kapp->config();
  config->setGroup("SCSI");
  host=config->readNumEntry("SCSICdromHost",0);
  unit=config->readNumEntry("SCSICdromUnit",-1);
  if (unit==-1) return(0);

  sprintf(devline,"dev=%d,%d,0",host,unit);
  sprintf(fileline,"f=%s",filename);
  sprintf(sectorline,"sectors=%ld-%ld",lba_start,lba_start+size_hint);
  config->setGroup("Path");
  if FREE_READCD {
    *this<<config->readEntry("PathReadcd",PATH_READCD)<<
      devline<<fileline<<sectorline<<"retries=10"<<"-noerror";
  } else {
    *this<<PATH_WRAPPER<<"readcd"<<devline<<fileline<<sectorline<<"retries=10"<<
      "-noerror";
  }

  return(true);
}

ReadcdRipper::ReadcdRipper(void):DataRipper() {

}

bool ReadcdRipper::processStderrLine(char *linebuffer) {
  if (strncmp("addr:",linebuffer,5)==0) {
    char *xptr;
    long int val;
    xptr=linebuffer+5;
    while ( *xptr==' ') ++xptr;
    if (*xptr==0) return(true);
    val=strtol(xptr,0,10);
    reportProgress((val-start_lba)*2048,(end_lba-start_lba+1)*2048);
  }
  if (strcmp("#OK#",linebuffer)==0) {
    ripflag=1;
  }

  if (strncmp("Time total",linebuffer,10)==0) {
    ripflag=1;
  }
  return(true);
}



