// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef ISOWINDOW_INCLUDED
#define ISOWINDOW_INCLUDED

#include <kdialogbase.h> 

class FileTree;
class ISOImage;
class ISOFile;
class QPushButton;
class KStatusBar;
class CDTrack;


class ISOWindow : public KDialogBase {
  Q_OBJECT;
 public:
  ISOWindow( QWidget *parent, const char *name,
	     class ISOImage *isoimage,class CDTrack *cdt);
  ~ISOWindow(void);
 signals:
  void needUpdate(void);
  void imageChanged(void);
  void closed(void);

 private:
  ISOImage *isoImage;
  ISOFile  *backupTree;
  CDTrack *cdTrack;
  class IsoWidget *mainWidget;
 protected:
  virtual void slotOk(); 
  virtual void slotCancel();
};

#endif
