// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _ISO_WIDGET_H_
#define _ISO_WIDGET_H_

#include <qvbox.h>
#include "CDTrack.h"
#include "FileTree.h"
#include <qlabel.h>

class IsoWidget:public QVBox
{
	Q_OBJECT
	public:
	IsoWidget(QWidget *parent,bool showSourceTree=true);
	void setTrack(CDTrack *Track);
	  private:
	CDTrack *track;
	FileTree *isoTree;
	FileTree *sourceTree;
	QLabel *isoSize;
        void addSessionView(void);

	public slots:
	void doRecalc();

	private slots:
        void addSession(void);
	void slotSetDirty();
        void createDir();
	void deleteObject();
	void openISOOptions();

	signals:
  	void imageChanged(void);  
	void needUpdate(void);
};
#endif
