// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ConfigSCSIWidget.h"
#include "ConfigSCSIWidget.moc"

#include "ProgressDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qwindowdefs.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <strings.h>
#include <stdio.h>
#include <sys/stat.h>

ConfigSCSIWidget::ConfigSCSIWidget( QWidget *parent, const char *name):QWidget(parent,name) {
  int i,k,dev=0;
  KConfig *config;
  QVBoxLayout  *mainlayout;
  QGridLayout  *cdrlayouthl;
  QVBoxLayout  *cdrlayoutop;
  QVBoxLayout  *cdrlayout;
  QGridLayout  *cdromlayouthl;
  QVBoxLayout  *cdromlayoutop;
  QVBoxLayout  *cdromlayout;
  ProgressDialog *prog;

  config=kapp->config();

  config->setGroup("SCSI");
  writer_id=config->readNumEntry("SCSIWriterUnit",-1);
  cdrom_id=config->readNumEntry("SCSICdromUnit",-1);
  writer_host=config->readNumEntry("SCSIWriterHost",0);
  cdrom_host=config->readNumEntry("SCSICdromHost",0);

  setCaption(i18n("KreateCD - SCSI configuration"));

  mainlayout=new QVBoxLayout(this);
	
  prog=new ProgressDialog();
  SCSIBus=new BusScanner();
  prog->attachProcess(SCSIBus);
  SCSIBus->scanSCSIBus();
  prog->exec();
  delete(prog);

  scsiboxes[0]=new QButtonGroup(i18n("CD writer"),this,"writer group");
  scsiboxes[0]->setAlignment(AlignHCenter);
  scsiboxes[0]->setMinimumSize(300,60);
  cdrlayouthl=new QGridLayout(scsiboxes[0],3,4,20,0);
  cdrlayouthl->setColStretch(0,0);
  cdrlayouthl->setColStretch(1,0);
  cdrlayouthl->setColStretch(2,0);
  cdrlayouthl->setColStretch(3,1);
  cdrlayouthl->addColSpacing(0,15);
  cdrlayouthl->addColSpacing(2,15);
  cdrlayoutop=new QVBoxLayout();
  cdrlayouthl->addLayout(cdrlayoutop,1,1);
  cdrlayout=new QVBoxLayout();
  cdrlayouthl->addLayout(cdrlayout,1,3);

  scsiboxes[1]=new QButtonGroup(i18n("CD-ROM"),this,"cdrom group");
  scsiboxes[1]->setAlignment(AlignHCenter);
  scsiboxes[1]->setMinimumSize(300,60);
  cdromlayouthl=new QGridLayout(scsiboxes[1],3,4,20,0);
  cdromlayouthl->setColStretch(0,0);
  cdromlayouthl->setColStretch(1,0);
  cdromlayouthl->setColStretch(2,0);
  cdromlayouthl->setColStretch(3,1);
  cdromlayouthl->addColSpacing(0,15);
  cdromlayouthl->addColSpacing(2,15);
  cdromlayoutop=new QVBoxLayout();
  cdromlayouthl->addLayout(cdromlayoutop,1,1);
  cdromlayout=new QVBoxLayout();
  cdromlayouthl->addLayout(cdromlayout,1,3);

  for (k=0;k<MAX_SCSI_HOSTS;++k) {
    for (i=0;i<MAX_SCSI_UNITS;++i) {
      scsidevs[k][i][0]=0;
      if (SCSIBus->getSCSIType(i,k)==2) {
        struct stat mst;
	sprintf(scsidevs[k][i],"/dev/sr%d",dev);
        if (stat(scsidevs[k][i],&mst)==-1) {
          sprintf(scsidevs[k][i],"/dev/scd%d",dev);
        }
	++dev;
      }
    }
  }

  for (i=0;i<MAX_SCSI_UNITS;++i) {
    scsibuttons[0][i]=new QRadioButton(scsiboxes[0]);
    cdrlayout->addWidget(scsibuttons[0][i]);
  }

  for (i=0;i<MAX_SCSI_UNITS;++i) {
    scsibuttons[1][i]=new QRadioButton(scsiboxes[1]);
    cdromlayout->addWidget(scsibuttons[1][i]);
  }

  {
    QLabel *lab;
    writerhostspin=new QSpinBox(scsiboxes[0]);
    writerhostspin->setRange(0,MAX_SCSI_HOSTS-1);
    writerhostspin->setFixedSize(writerhostspin->sizeHint());
    cdrlayoutop->addStretch(1);
    lab=new QLabel(i18n("SCSI host"),scsiboxes[0],0,0);
    lab->setFixedSize(lab->sizeHint());
    cdrlayoutop->addWidget(lab);
    cdrlayoutop->addWidget(writerhostspin);
    cdrlayoutop->addStretch(1);
  }

  {
    QLabel *lab;
    cdromhostspin=new QSpinBox(scsiboxes[1]);
    cdromhostspin->setRange(0,MAX_SCSI_HOSTS-1);
    cdromhostspin->setFixedSize(cdromhostspin->sizeHint());
    cdromlayoutop->addStretch(1);
    lab=new QLabel(i18n("SCSI host"),scsiboxes[1],0,0);
    lab->setFixedSize(lab->sizeHint());
    cdromlayoutop->addWidget(lab);
    cdromlayoutop->addWidget(cdromhostspin);
    cdromlayoutop->addStretch(1);
  }

  connect(scsiboxes[0],SIGNAL(clicked(int)),this,SLOT(clickedWriter(int)));
  connect(scsiboxes[1],SIGNAL(clicked(int)),this,SLOT(clickedCDROM(int)));

  updateWriterButtons();
  updateCdromButtons();
  writerhostspin->setValue(writer_host);
  scsiboxes[0]->setButton(writer_id);
  cdromhostspin->setValue(cdrom_host);
  scsiboxes[1]->setButton(cdrom_id);

  mainlayout->addWidget(scsiboxes[0]);
  mainlayout->addStretch(1);
  mainlayout->addWidget(scsiboxes[1]);

  connect(writerhostspin,SIGNAL(valueChanged(int)),
          this,SLOT(changedWriterHost(int)));
  connect(cdromhostspin,SIGNAL(valueChanged(int)),
          this,SLOT(changedCdromHost(int)));

  cdrlayouthl->activate();
  cdromlayouthl->activate();
  mainlayout->activate();
}


ConfigSCSIWidget::~ConfigSCSIWidget() {
  delete (SCSIBus);
}

void ConfigSCSIWidget::applySettings() {
  KConfig *config;
  config=kapp->config();
  config->setGroup("SCSI");
  config->writeEntry("SCSIWriterHost",writer_host);
  config->writeEntry("SCSIWriterUnit",writer_id);
  if (writer_id!=1) {
    config->writeEntry("SCSIWriterDevice",QString(scsidevs[writer_host][writer_id]));
  } else {
    config->writeEntry("SCSIWriterDevice",QString::null);
  }
  config->writeEntry("SCSICdromHost",cdrom_host);
  config->writeEntry("SCSICdromUnit",cdrom_id);
  if (cdrom_id!=-1) {
    config->writeEntry("SCSICdromDevice",QString(scsidevs[cdrom_host][cdrom_id]));
  } else {
    config->writeEntry("SCSICdromDevice",QString::null);
  }
}

void ConfigSCSIWidget::updateWriterButtons() {
  int i;
  char tempscsi[80];
  for (i=0;i<MAX_SCSI_UNITS;++i) {
    if (SCSIBus->getSCSIType(i,writer_host)==0) {
      sprintf(tempscsi,i18n("ID : %d - No drive connected"),i);
    } else {
      sprintf(tempscsi,i18n("ID : %d - %s %s (%s)"),
              i,SCSIBus->getSCSIManu(i,writer_host),SCSIBus->getSCSIProd(i,writer_host),
	      SCSIBus->getSCSIType(i,writer_host)==2?
              i18n("CD-ROM").ascii():i18n("Hard drive").ascii());
    }
    scsibuttons[0][i]->setText(tempscsi);
    scsibuttons[0][i]->setMinimumSize(scsibuttons[0][i]->sizeHint());
    scsibuttons[0][i]->setEnabled((SCSIBus->getSCSIType(i,writer_host)==2)?true:false);
  }
}

void ConfigSCSIWidget::updateCdromButtons() {
  int i;
  char tempscsi[80];
  for (i=0;i<MAX_SCSI_UNITS;++i) {
    if (SCSIBus->getSCSIType(i,cdrom_host)==0) {
      sprintf(tempscsi,i18n("ID : %d - No drive connected"),i);
    }  else {
      sprintf(tempscsi,i18n("ID : %d - %s %s (%s)"),
              i,SCSIBus->getSCSIManu(i,cdrom_host),SCSIBus->getSCSIProd(i,cdrom_host),
              SCSIBus->getSCSIType(i,cdrom_host)==2?
              i18n("CD-ROM").ascii():i18n("Hard drive").ascii());
    }
    scsibuttons[1][i]->setText(tempscsi);
    scsibuttons[1][i]->setMinimumSize(scsibuttons[1][i]->sizeHint());
    scsibuttons[1][i]->setEnabled((SCSIBus->getSCSIType(i,cdrom_host)==2)?true:false);
  }
}


void ConfigSCSIWidget::clickedWriter(int unit) {
  writer_id=unit;
}

void ConfigSCSIWidget::clickedCDROM(int unit) {
  cdrom_id=unit;
}

void ConfigSCSIWidget::changedWriterHost(int host) {
  if ( (host>=(MAX_SCSI_HOSTS-1)) || (host<0) ) return;
  writer_host=host;
  updateWriterButtons();
  writer_id=-1;
  scsiboxes[0]->setButton(writer_id);
}

void ConfigSCSIWidget::changedCdromHost(int host) {
  if ( (host<0) || (host>=(MAX_SCSI_HOSTS-1)) ) return;
  cdrom_host=host;
  updateCdromButtons();
  cdrom_id=-1;
  scsiboxes[1]->setButton(cdrom_id);
}

