// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioWaveData.h"
#include "AudioFileInfo.h"
#include "AudioFileOp.h"

AudioWaveData::AudioWaveData(AudioFileInfo *afi) {
  validFile=false;
  myAudio=afi;
  myOp=new AudioFileOp(myAudio);
  if (myOp!=0) {
    if (myOp->openRead(afi->getBurnFile())!=0)  {
      validFile=true;
    }
  }
  samplePos=0;
  memorySample=-1;
}

AudioWaveData::~AudioWaveData(void) {
  if (myOp!=0) delete myOp;
}

long AudioWaveData::getData(int curve,long int x) {
  if (!validFile) return(0);
  if (curve>=AUDIOWAVEDATA_MAXCHAN) {
    return(0);
  }
  if (memorySample!=x) fillCache(x);
  return(sampleCache[curve]);
}


void AudioWaveData::fillCache(long int sample) {
  int i;
  long int dat;
  if (memorySample==sample) return;
  if (samplePos!=sample) {
    myOp->positionSample(sample);
  }
  samplePos=sample+1;
  for (i=0;i<myAudio->channels();++i) {
    if (i>=AUDIOWAVEDATA_MAXCHAN) {
      myOp->readSample(&dat);
    } else {
      myOp->readSample(&sampleCache[i]);
    }
  } 
}


int AudioWaveData::getCurves(void) {
  int chan;
  chan=myAudio->channels();
  if (chan>AUDIOWAVEDATA_MAXCHAN) {
    chan=AUDIOWAVEDATA_MAXCHAN;
  }
  return(chan);
}


long AudioWaveData::getMaxX(void) {
  if (myAudio->dataSamples()<=1) return(1);
  return(myAudio->dataSamples()-1);
}

long AudioWaveData::getMinY(void) {
  return(-32768);
}

long AudioWaveData::getMaxY(void) {
  return(32767);
}

long AudioWaveData::getSampleRate(void) {
  return(myAudio->rate());
}
