// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef _AUDIO_POS_WIDGET_H
#define _AUDIO_POS_WIDGET_H

#include <qwidget.h>

class QSpinBox;
class QLabel;

class AudioPosWidget : public QWidget {
  Q_OBJECT;
  
  public:
    AudioPosWidget(QWidget *parent,long samples,int rate);

    void setPosition(long int pos);
    long position(void);

  signals:
    void positionChanged(void);

  protected:
    long samples;
    int  rate;
    int minutes;
    int seconds;
    int samplerem;

  private slots:
    void valuesChanged(int value);

  private:
    QSpinBox *minuteSpin;
    QSpinBox *secondSpin;
    QSpinBox *sampleSpin;  
    QLabel *minuteLabel;
    QLabel *secondLabel;
    QLabel *sampleLabel;
    bool userChange;
};


#endif
