// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#ifndef AUDIOCONVERSION_INCLUDED
#define AUDIOCONVERSION_INCLUDED

#include "ProcessInterface.h"

class AudioConverter;
class AudioFileInfo;

class AudioConversion : public ProcessInterface {

 public:
  AudioConversion(AudioFileInfo *afile,AudioConverter *acon);
  AudioConversion(AudioFileInfo *afile,AudioConverter *acon,
                  int (*fx)(int argc,char **argv));
  bool convertAudio(const char *filename);

  void setProgress(long int prog,long int max);	

 protected:

  virtual int  processExited(void);
  virtual bool processStderrLine(char *linebuffer);
  virtual bool processStdoutLine(char *linebuffer);
  virtual int  processCleanup(int rval);
  AudioFileInfo *myAudio;
  AudioConverter *myConverter;

 private:
  
  char convertFilename[1024];
};

#endif
