/***************************************************************************
                          kpregview.cpp  -  description
                             -------------------
    begin                : Seg Jul 30 00:39:14 EDT 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qstring.h>
#include <qiconset.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "kpregview.h"
#include "kpreg.h"

KpregView::KpregView(QWidget *parent, const char *name) : QWidget(parent, name)
{
	setMinimumSize ( 250, 370 );
	qtw = new QTabWidget ( this, "qtw");
	blue_pm = new QPixmap (KGlobal::dirs()->findResource( "data", "kpreg/blue_circ.png" ));
	red_pm = new QPixmap (KGlobal::dirs()->findResource( "data", "kpreg/red_circ.png" ));
	yellow_pm = new QPixmap (KGlobal::dirs()->findResource( "data", "kpreg/yellow_circ.png" ));
	setModified( false );
	atualizeSysTray = true;
	copiedItem = 0;
//	connect( this, SIGNAL( text_select (QString) ), parent, SLOT( slotSaveAll () ) );
	connect( this, SIGNAL( save_all () ), parent, SLOT( slotSaveAll () ) );
	connect( qtw, SIGNAL( currentChanged (QWidget *) ), this, SLOT( changedCategory () ) );
}

KpregView::~KpregView()
{
	for ( kplb_list . first ();  kplb_list . current() != 0;  kplb_list . next ()  ) {
		kplb_list . current()->clearItens ();
		kplb_list . remove ();
	}
}

void KpregView::changedCategory () {
	emit currentCategoryMenu ( kplb_list . at ( qtw->currentPageIndex() ) -> getSubMenu() );
}

void KpregView::resizeEvent ( QResizeEvent * newSize)
{
	qtw ->resize( newSize->size().width(), newSize->size().height() - 5 );
}

void KpregView::slotAddItem( QDomDocument itemNode )
{
	kplb_list . at ( qtw->currentPageIndex () )->setNewItem ( itemNode );
}

void KpregView::deleteItem ()
{
	kplb_list . at ( qtw->currentPageIndex () )->deleteItem ();
	setModified( true );
}

KpregItem* KpregView::editItem ()
{
	return kplb_list . at ( qtw->currentPageIndex () )->getCurrentItem ();
}

KpregListBox *KpregView::editCategory ()
{
 	return kplb_list . at (qtw->currentPageIndex ());
}

QDomDocumentFragment KpregView::save (QDomDocument qdd)
{
	QDomDocumentFragment fragment  = qdd . createDocumentFragment ();
	for ( kplb_list . first ();  kplb_list . current() != 0;  kplb_list . next ()  ) {
		QDomElement rootElem (qdd.createElement("category"));
		rootElem . setAttribute ( "label", kplb_list . current()->getCategoryLabel() );
		rootElem . setAttribute ( "icon", kplb_list . current()->getCategoryIcon() );
		rootElem . appendChild ( kplb_list . current()->save(qdd) );
		fragment . appendChild ( rootElem );
	}
	return fragment;
}

void KpregView::insertNewTab (QDomNode tabNode)
{
	QDomElement tabElement = tabNode . toElement ();
	QString label = tabElement . attribute ("label");
	QString icon = tabElement . attribute ("icon");

	KIconLoader kil;
	setAtSysTray(false);
	kplb_list . append( new KpregListBox( qtw, label) );
	kplb_list . current () -> setCategoryIcon (icon);
	kplb_list . current () -> setIcons (blue_pm, yellow_pm, red_pm);
	kplb_list . current ()-> setItens (tabNode);
	kplb_list . current ()-> setParentWidgets ( qtw, hierMenu);
	if  ( icon == "" ) {
		qtw ->insertTab  ( kplb_list . current (), label, kplb_list . at() );
		hierMenu -> insertItem ( label, kplb_list . current ()-> getSubMenu() );
	} else {
		qtw ->insertTab  ( kplb_list . current (), QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, kplb_list . at() );
		hierMenu -> insertItem ( QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, kplb_list . current ()-> getSubMenu() );
	}

	setAtSysTray(true);
}

void KpregView::insertNewTab (QDomDocument category)
{
	QDomNodeList tabList = category . elementsByTagName ( "category" );
	insertNewTab (tabList.item(0));
}

bool KpregView::saveModified()
{
	bool completed=true;

	if(modified)
	{
		KpregApp *win=(KpregApp *) parent();
		int want_save = KMessageBox::warningYesNoCancel(win, i18n("Warning\nThe current file has been modified.\nDo you want to save it?"), i18n("The current file has been modified.") );

		switch(want_save)
		{
			case 3:
//			emit text_select ("");
			emit save_all();
			completed=true;
			break;

			case 4:
			setModified(false);
			completed=true;
			break;

			case 2:
			completed=false;
			break;

			default:
			completed=false;
			break;
		}
	}
	return completed;
}

void KpregView::deleteCategory ()
{
	kplb_list . setAutoDelete(true);
	kplb_list.at(qtw->currentPageIndex());
	hierMenu -> removeItemAt ( kplb_list.at() + 5 );
	kplb_list . remove ();
	if ( qtw -> count() == 0 ) {
		KIconLoader kil;
		kplb_list . append( new KpregListBox( qtw, "Untitled") );
		kplb_list . current () -> setCategoryIcon ("kpreg");
		kplb_list . current () -> setIcons (blue_pm, yellow_pm, red_pm);
		kplb_list . current ()-> setParentWidgets ( qtw, hierMenu);
		qtw ->insertTab  ( kplb_list . current (), QIconSet (QPixmap(kil . loadIcon( "kpreg", KIcon::Toolbar ))), "Untitled" );
		hierMenu -> insertItem ( QIconSet (QPixmap(kil . loadIcon( "kpreg", KIcon::Toolbar ))), "Untitled", kplb_list . current ()-> getSubMenu() );
		qtw ->showPage (kplb_list . current ());
	}
	kplb_list . setAutoDelete(false);
	setModified( true );
}

void KpregView::setAtSysTray (bool a)
{
	atualizeSysTray = a;
}

void KpregView::clearItens()
{
	for ( kplb_list . first ();  kplb_list . current() != 0;  kplb_list . next ()  ) {
		kplb_list . current()->clearItens ();
	}
}

void KpregView::setHierMenu(KPopupMenu *menu)
{
	hierMenu = menu;
}

void KpregView::setModified(bool _m)
{
	modified=_m;
	emit setSaveButtonEnabled(_m);
}

void KpregView::moveItemUp ()
{
	kplb_list . at ( qtw->currentPageIndex () )->moveUp ();
	setModified( true );
}

void KpregView::moveItemDown ()
{
	kplb_list . at ( qtw->currentPageIndex () )->moveDown ();
	setModified( true );
}

void KpregView::moveCategoryRight(){
	if ( qtw->currentPageIndex() != ( qtw->count() - 1 ) ) {
		KIconLoader kil;
		KpregListBox *page1, *page2;
		int pos1, pos2;
		page1 = kplb_list . at (qtw->currentPageIndex());
		QString icon = page1 -> getCategoryIcon();
		QString label = page1 -> getCategoryLabel();
		pos1 = kplb_list . at();
		page2 = kplb_list . next();
		pos2 = kplb_list . at();
		kplb_list . replace(pos2, page1);
		kplb_list . replace(pos1, page2);
		qtw -> removePage (page1);
		qtw -> insertTab ( page1, QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, pos1 + 1 );
		qtw -> setCurrentPage ( pos1 + 1 );
		hierMenu -> removeItemAt ( pos1 + 5 );
		hierMenu -> insertItem ( QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, page1->getSubMenu(), -1, pos1 + 6 );
		setModified( true );
	}
}

void KpregView::moveCategoryLeft(){
	if ( qtw->currentPageIndex() != 0 ) {
		KIconLoader kil;
		KpregListBox *page1, *page2;
		int pos1, pos2;
		page1 = kplb_list . at (qtw->currentPageIndex());
		QString icon = page1 -> getCategoryIcon();
		QString label = page1 -> getCategoryLabel();
		pos1 = kplb_list . at();
		page2 = kplb_list . prev();
		pos2 = kplb_list . at();
		kplb_list . replace(pos1, page2);
		kplb_list . replace(pos2, page1);
		qtw -> removePage (page1);
		qtw -> insertTab ( page1, QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, pos1 - 1 );
		qtw -> setCurrentPage ( pos1 - 1 );
		hierMenu -> removeItemAt ( pos1 + 5 );
		hierMenu -> insertItem ( QIconSet (QPixmap(kil . loadIcon( icon, KIcon::Toolbar ))), label, page1->getSubMenu(), -1, pos1 + 4 );
		setModified( true );
	}
}

void KpregView::copyItem ()
{
	if (copiedItem) 
		delete copiedItem;
	copiedItem = new KpregItem ( editItem()->getTitle(), editItem()->getContent() );
	copiedItem->setType( editItem()->getType() );
}

void KpregView::cutItem ()
{
	copyItem ();
	deleteItem ();
}

void KpregView::pasteItens ( Position _pos )
{
	if (copiedItem) {
		itemXMLfactory ixf ( copiedItem->getTitle(), copiedItem->getContent(), copiedItem->getType(), _pos );
		slotAddItem( ixf . getDocument() );
		setModified();
	}
}



