//
// C++ Implementation: kpogrecontroller
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpogrecontroller.h"

// include files for Qt
#include <qtextcodec.h>
#include <qprinter.h>
#include <qinputdialog.h>
#include <qapplication.h>
#include <qclipboard.h>

// include files for KDE
#include <kactioncollection.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcursor.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <ktextedit.h>
#include <kencodingfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "kpogrecomboaction.h"
#include "kpgsearchdialog.h"
#include "kpgbookmarksbutton.h"
#include "kpglinklabel.h"

// Property page includes
#include "PropertyPages/kpgabstractpropertypage.h"
#include "PropertyPages/kpgpropertypagechildview.h"

// Query result includes
#include "QueryResult/kpgqueryresultchildview.h"
#include "QueryResult/kpgqueryresultwindow.h"

// Data table includes 
#include "DataTable/kpgdatatablechildview.h"
#include "DataTable/kpgdatatable.h"
#include "DataTable/kpgdatatabledialog.h"

// Function executor includes 
#include "Executor/kpgexecutorchildview.h"
#include "Executor/kpgexecutor.h"

// PL/pgSQL debugger includes 
#include "Debugger/kpgdebuggerchildview.h"
#include "Debugger/kpgdebugger.h"

#include "QueryResult/kpgsqledit.h"


// Database objects includes
#include "DbObjects/kpgserver.h"
#include "DbObjects/kpgfunction.h"
#include "DbObjects/kpgtablespace.h"
#include "DbObjects/kpgdatabase.h"
#include "DbObjects/kpgschema.h"
#include "DbObjects/kpgtrigger.h"
#include "DbObjects/kpgdomain.h"
#include "DbObjects/kpgtable.h"
#include "DbObjects/kpgtablecolumn.h"
#include "DbObjects/kpgtableindex.h"

KPoGreController::KPoGreController(KPoGreView *pOwnerView)
 : QObject()
{
	m_pView = pOwnerView;
	m_pDlgSearch = 0;
}


KPoGreController::~KPoGreController()
{
	if(m_pDlgSearch)
		delete m_pDlgSearch; 
}

void KPoGreController::initActions(KActionCollection * pActionCollection)
{
	//-----------------------------------------------------------------
	// File menu
	
	m_pActFileNewWindow = new KAction(i18n("New &Window"), 0, 0, this, SLOT(slotFileNewWindow()), pActionCollection,"file_new_window");
	
	m_pActFileNew = KStdAction::openNew(this, SLOT(slotFileNew()), pActionCollection);
	
	m_pActFileOpen = KStdAction::open(this, SLOT(slotFileOpen()), pActionCollection);
	
	m_pActFileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), pActionCollection);
	
	m_pActFileExportResult = new KAction(i18n("&Export Result..."), "fileexport", 0, this, SLOT(slotExportResult()), pActionCollection, "export_result");
		
	m_pActFileClose = KStdAction::close(this, SLOT(slotFileClose()), pActionCollection);
		
	m_pActFileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), pActionCollection);
	
	m_pActFileNewWindow->setStatusText(i18n("Opens a new application window"));
	m_pActFileNew->setStatusText(i18n("Creates a new document"));
	m_pActFileOpen->setStatusText(i18n("Opens an existing document"));
	m_pActFileOpenRecent->setStatusText(i18n("Opens a recently used file"));
	//m_pActFileSave->setStatusText(i18n("Saves the actual document"));
	//m_pActFileSaveAs->setStatusText(i18n("Saves the actual document as..."));
	m_pActFileClose->setStatusText(i18n("Closes the actual document"));
	//m_pActFilePrint ->setStatusText(i18n("Prints out the actual document"));
	m_pActFileQuit->setStatusText(i18n("Quits the application"));
	
	//-----------------------------------------------------------------
	// Edit menu
		
	m_pActEditFindInTree = new KAction(i18n("Find in tree..."), "find", 0,  this, SLOT(slotEditFindInTree()), pActionCollection, "edit_find_in_tree" );
	
	m_pActEditFindNextInTree = new KAction(i18n("Find next in tree"), "next", 0,  this, SLOT(slotEditFindNextInTree()), pActionCollection, "edit_find_next_in_tree" );
	

  	//-----------------------------------------------------------------
	// View menu
  																		
	m_pActViewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), pActionCollection, "showtoolbar");
  	m_pActViewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), pActionCollection, "settings_show_statusbar");
 
    //-----------------------------------------------------------------
	// Database menu       
	m_pActDatabaseConnect = new KAction(i18n("&Connect..."), "connect_established", 0, this, SLOT(slotDatabaseConnect()), pActionCollection, "connect");
	
	m_pActDatabaseDisconnect = new KAction(i18n("&Disconnect"), "connect_no", 0, this, SLOT(slotDatabaseDisconnect()), pActionCollection, "disconnect");
	
	m_pActDatabaseWizard = new KAction(i18n("&Wizard..."), "wizard", Key_F9, this, SLOT(slotDatabaseWizard()), pActionCollection, "wizard");
			
  	//-----------------------------------------------------------------
	// Settings menu
	KStdAction::keyBindings(m_pView, SLOT(slotConfigureKeys()), pActionCollection, "options_configure_keys");
	
  	KStdAction::configureToolbars(m_pView, SLOT(slotConfigToolbars()), pActionCollection, "options_configure_toolbars");
	
	KStdAction::preferences(m_pView, SLOT(slotConfigure()), pActionCollection, "settings_configure");
	
  	//-----------------------------------------------------------------
	//-----------------------------------------------------------------
	// Popup menus
  	//-----------------------------------------------------------------
  	//-----------------------------------------------------------------
  
	m_pActFolderRefresh = new KAction( i18n("&Refresh"), "reload", SHIFT+Key_F5, this, SLOT(slotRefresh()), pActionCollection, "refresh" );
	
	//--- Server related menu actions
	(void) new KAction( i18n("&Reload configuration..."), 0, 0, this, SLOT(slotReloadServerConfig()), pActionCollection, "server_reload_config" );
	
	(void) new KAction( i18n("Rotate &log file..."), 0, 0, this, SLOT(slotRotateServerLogFile()), pActionCollection, "server_rotate_log_file" );
	
	//--- Database related menu actions
	
	(void) new KAction( i18n("&Create new database..."), "wizard", 0, this, SLOT(slotCreateDatabase()), pActionCollection, "create_database" );
    
    (void) new KAction( i18n("&Create database from dump..."), "revert", 0, this, SLOT(slotLoadDatabase()), pActionCollection, "load_database" );
	
	(void) new KAction( i18n("&Drop database..."), "editdelete", 0, this, SLOT(slotDropDatabase()), pActionCollection, "drop_database" );
 
    (void) new KAction( i18n("&Analyze..."), 0, 0, this, SLOT(slotAnalyseDatabase()), pActionCollection, "analyse_database" );
    
    (void) new KAction( i18n("Re&index..."), 0, 0, this, SLOT(slotReindexDatabase()), pActionCollection, "reindex_database" );
        
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerDatabase()), pActionCollection, "set_owner_database" );
    
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesDatabase()), pActionCollection, "grant_privileges_database" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesDatabase()), pActionCollection, "revoke_privileges_database" );
    
    (void) new KAction( i18n("Dump..."), 0, 0, this, SLOT(slotDumpDatabase()), pActionCollection, "dump_database" );
    
    (void) new KAction( i18n("Restore..."), 0, 0, this, SLOT(slotRestoreDatabase()), pActionCollection, "restore_database" );
        
    (void) new KAction( i18n("Disconnect from database"), "connect_no", 0, this, SLOT(slotDisconnectDatabase()), pActionCollection, "disconnect_database" );
    
	
	//--- Schema related menu actions
	
	(void) new KAction( i18n("&Create schema..."), "wizard", 0, this, SLOT(slotCreateSchema()), pActionCollection, "create_schema" );
	
	(void) new KAction( i18n("&Drop schema..."), "editdelete", 0, this, SLOT(slotDropSchema()), pActionCollection, "drop_schema" );
	
	(void) new KAction( i18n("R&ename schema..."), "edittool", 0, this, SLOT(slotModifySchema()), pActionCollection, "rename_schema" );
  
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerSchema()), pActionCollection, "set_owner_schema" );
        
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesSchema()), pActionCollection, "grant_privileges_schema" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesSchema()), pActionCollection, "revoke_privileges_schema" );
    
	//--- Table related menu actions
	
	(void) new KAction( i18n("&Create table..."), "wizard", 0, this, SLOT(slotCreateTable()), pActionCollection, "create_table" );
	
	(void) new KAction( i18n("&Drop table..."), "editdelete", 0, this, SLOT(slotDropTable()), pActionCollection, "drop_table" );
	
    (void) new KAction( i18n("R&ename table..."), "edittool", 0, this, SLOT(slotRenameTable()), pActionCollection, "rename_table" );
        
    (void) new KAction( i18n("&Analyze table..."), 0, 0, this, SLOT(slotAnalyseTable()), pActionCollection, "analyse_table" );
    
    (void) new KAction( i18n("&Vacuum table..."), 0, 0, this, SLOT(slotVacuumTable()), pActionCollection, "vacuum_table" );
    
    (void) new KAction( i18n("Re&index table..."), 0, 0, this, SLOT(slotReindexTable()), pActionCollection, "reindex_table" );
    
    (void) new KAction( i18n("Set c&luster on..."), 0, 0, this, SLOT(slotSetClusterOnTable()), pActionCollection, "set_cluster_on_table" );
    
    (void) new KAction( i18n("Set &without cluster..."), 0, 0, this, SLOT(slotSetWithoutClusterTable()), pActionCollection, "set_wo_cluster_table" );
    
    (void) new KAction( i18n("&Cluster table..."), 0, 0, this, SLOT(slotClusterTable()), pActionCollection, "cluster_table" );
    
    (void) new KAction( i18n("Copy to &file..."), 0, 0, this, SLOT(slotCopyFromTable()), pActionCollection, "copy_from_table" );
    
    (void) new KAction( i18n("Cop&y from file..."), 0, 0, this, SLOT(slotCopyToTable()), pActionCollection, "copy_to_table" );
    
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerTable()), pActionCollection, "set_owner_table" );
    
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesTable()), pActionCollection, "grant_privileges_table" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesTable()), pActionCollection, "revoke_privileges_table" );
  
    (void) new KAction( i18n("Set tables&pace..."), 0, 0, this, SLOT(slotSetTablespaceTable()), pActionCollection, "set_tblspace_table" );
  
    (void) new KAction( i18n("Set without OIDs..."), 0, 0, this, SLOT(slotSetWithoutOIDsTable()), pActionCollection, "set_wo_oids_table" );
    
    (void) new KAction(i18n("Edit table content..."), "data", 0, this, SLOT(slotEditTableContent()), pActionCollection, "edit_table_content");
    
    (void) new KAction(i18n("Query table"), "exec", 0, this, SLOT(slotQueryTable()), pActionCollection, "query_table");
    
	//--- View related menu actions
	
	(void) new KAction( i18n("&Create view..."), "wizard", 0, this, SLOT(slotCreateView()), pActionCollection, "create_view" );
	
	(void) new KAction( i18n("&Drop view..."), "editdelete", 0, this, SLOT(slotDropView()), pActionCollection, "drop_view" );
	
	(void) new KAction( i18n("&Modify view..."), "edit", 0, this, SLOT(slotModifyView()), pActionCollection, "modify_view" );
	
	(void) new KAction( i18n("&Query view"), "exec", 0, this, SLOT(slotQueryView()), pActionCollection, "query_view" );
  
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesView()), pActionCollection, "grant_privileges_view" );
  
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesView()), pActionCollection, "revoke_privileges_view" );

    //--- Tablespaces related menu actions
    
    (void) new KAction( i18n("&Create tablespace..."), "wizard", 0, this, SLOT(slotCreateTablespace()), pActionCollection, "create_tablespace" );
    
    (void) new KAction( i18n("&Drop tablespace..."), "editdelete", 0, this, SLOT(slotDropTablespace()), pActionCollection, "drop_tablespace" );
    
    (void) new KAction( i18n("&Rename tablespace..."), "edittool", 0, this, SLOT(slotRenameTablespace()), pActionCollection, "rename_tablespace" );
    
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerTablespace()), pActionCollection, "set_owner_tablespace" );
    
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesTablespace()), pActionCollection, "grant_privileges_tablespace" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesTablespace()), pActionCollection, "revoke_privileges_tablespace" );
  
	//--- User related menu actions
	
	(void) new KAction( i18n("&Create user..."), "wizard", 0, this, SLOT(slotCreateUser()), pActionCollection, "create_user" );
	
	(void) new KAction( i18n("&Drop user..."), "editdelete", 0, this, SLOT(slotDropUser()), pActionCollection, "drop_user" );
	
	(void) new KAction( i18n("&Modify user..."), "edit", 0, this, SLOT(slotModifyUser()), pActionCollection, "modify_user" );
	
	//--- Group related menu actions
	
	(void) new KAction( i18n("&Create group..."), "wizard", 0, this, SLOT(slotCreateGroup()), pActionCollection, "create_group" );
	
	(void) new KAction( i18n("&Drop group..."), "editdelete", 0, this, SLOT(slotDropGroup()), pActionCollection, "drop_group" );
	
	(void) new KAction( i18n("&Modify group..."), "edit", 0, this, SLOT(slotModifyGroup()), pActionCollection, "modify_group" );
  
    //--- Language related menu actions
    
    (void) new KAction( i18n("&Create language..."), "wizard", 0, this, SLOT(slotCreateLanguage()), pActionCollection, "create_language" );
    
    (void) new KAction( i18n("&Drop language..."), "editdelete", 0, this, SLOT(slotDropLanguage()), pActionCollection, "drop_language" );
    
    (void) new KAction( i18n("&Rename language..."), "edittool", 0, this, SLOT(slotModifyLanguage()), pActionCollection, "rename_language" );
    
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesLanguage()), pActionCollection, "grant_privileges_language" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesLanguage()), pActionCollection, "revoke_privileges_language" );
    
    //--- Domain related menu actions
    
    (void) new KAction( i18n("&Create domain..."), "wizard", 0, this, SLOT(slotCreateDomain()), pActionCollection, "create_domain" );
    
    (void) new KAction( i18n("&Drop domain..."), "editdelete", 0, this, SLOT(slotDropDomain()), pActionCollection, "drop_domain" );
    
    (void) new KAction( i18n("Set &NOT NULL..."), 0, 0, this, SLOT(slotSetDomainNull()), pActionCollection, "set_domain_null" );
    (void) new KAction( i18n("Set d&efault..."), 0, 0, this, SLOT(slotSetDomainDefault()), pActionCollection, "set_domain_default" );
    (void) new KAction( i18n("Dr&op default..."), 0, 0, this, SLOT(slotDropDomainDefault()), pActionCollection, "drop_domain_default" );
    
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerDomain()), pActionCollection, "set_owner_domain" );
    
    //--- Domain constraint related menu actions
    
    (void) new KAction( i18n("&Create constraint(s)..."), "wizard", 0, this, SLOT(slotCreateDomainConstraint()), pActionCollection, "create_domain_constraint" );
    
    (void) new KAction( i18n("&Drop constraint..."), "editdelete", 0, this, SLOT(slotDropDomainConstraint()), pActionCollection, "drop_domain_constraint" );
        
    //--- Function related menu actions
    
    (void) new KAction( i18n("&Create function..."), "wizard", 0, this, SLOT(slotCreateFunction()), pActionCollection, "create_function" );
    
    (void) new KAction( i18n("&Drop function..."), "editdelete", 0, this, SLOT(slotDropFunction()), pActionCollection, "drop_function" );
    
    (void) new KAction( i18n("&Rename function..."), "edittool", 0, this, SLOT(slotRenameFunction()), pActionCollection, "rename_function" );
    
    (void) new KAction( i18n("&Modify function..."), "edit", 0, this, SLOT(slotModifyFunction()), pActionCollection, "modify_function" );
        
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesFunction()), pActionCollection, "grant_privileges_function" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesFunction()), pActionCollection, "revoke_privileges_function" );
    
    (void) new KAction( i18n("Execute function"), "exec", 0, this, SLOT(slotExecuteFunction()), pActionCollection, "execute_function" );
    
    (void) new KAction( i18n("Debug function"), "kpg_debugger", 0, this, SLOT(slotDebugFunction()), pActionCollection, "debug_function" );
	
	(void) new KAction( i18n("Attach to debugger"), "attach", 0, this, SLOT(slotDebugFunctionAttach()), pActionCollection, "debug_function_attach" );
        
    //--- Sequence related menu actions
    
    (void) new KAction( i18n("&Create sequence..."), "wizard", 0, this, SLOT(slotCreateSequence()), pActionCollection, "create_sequence" );
    
    (void) new KAction( i18n("&Drop sequence..."), "editdelete", 0, this, SLOT(slotDropSequence()), pActionCollection, "drop_sequence" );
    
    (void) new KAction( i18n("&Modify sequence..."), "edit", 0, this, SLOT(slotModifySequence()), pActionCollection, "modify_sequence" );
    
    (void) new KAction( i18n("Grant privileges..."), 0, 0, this, SLOT(slotGrantPrivilegesSequence()), pActionCollection, "grant_privileges_sequence" );
    
    (void) new KAction( i18n("Revoke privileges..."), 0, 0, this, SLOT(slotRevokePrivilegesSequence()), pActionCollection, "revoke_privileges_sequence" );
    
    //--- Column related menu actions
    
    (void) new KAction( i18n("&Create column(s)..."), "wizard", 0, this, SLOT(slotCreateColumn()), pActionCollection, "create_columns" );
    
    (void) new KAction( i18n("&Drop column..."), "editdelete", 0, this, SLOT(slotDropColumn()), pActionCollection, "drop_column" );
    
    (void) new KAction( i18n("&Rename column..."), "edittool", 0, this, SLOT(slotRenameColumn()), pActionCollection, "rename_column" );
    
    (void) new KAction( i18n("Set &NOT NULL..."), 0, 0, this, SLOT(slotSetColumnNull()), pActionCollection, "set_column_null" );
    (void) new KAction( i18n("Set d&efault..."), 0, 0, this, SLOT(slotSetColumnDefault()), pActionCollection, "set_column_default" );
    (void) new KAction( i18n("Dr&op default..."), 0, 0, this, SLOT(slotDropColumnDefault()), pActionCollection, "drop_column_default" );
    (void) new KAction( i18n("Change &type..."), 0, 0, this, SLOT(slotChangeColumnType()), pActionCollection, "change_column_type" );
    (void) new KAction( i18n("Set &storage..."), 0, 0, this, SLOT(slotSetColumnStorage()), pActionCollection, "set_column_storage" );
    (void) new KAction( i18n("Set st&atistics..."), 0, 0, this, SLOT(slotSetColumnStatistisc()), pActionCollection, "set_column_stat" );
        
    //--- Constraint related menu actions
    
    (void) new KAction( i18n("&Create constraint(s)..."), "wizard", 0, this, SLOT(slotCreateConstraint()), pActionCollection, "create_constraints" );
    
    (void) new KAction( i18n("&Drop constraint..."), "editdelete", 0, this, SLOT(slotDropConstraint()), pActionCollection, "drop_constraint" );
    
    //--- Index related menu actions
    
    (void) new KAction( i18n("&Create index(es)..."), "wizard", 0, this, SLOT(slotCreateIndex()), pActionCollection, "create_indexes" );
    
    (void) new KAction( i18n("&Drop index..."), "editdelete", 0, this, SLOT(slotDropIndex()), pActionCollection, "drop_index" );
    
    (void) new KAction( i18n("&Rename index..."), "edittool", 0, this, SLOT(slotRenameIndex()), pActionCollection, "rename_index" );
    
    (void) new KAction( i18n("Re&index..."), 0, 0, this, SLOT(slotReindexIndex()), pActionCollection, "reindex_index" );
    
    (void) new KAction( i18n("Set &owner..."), 0, 0, this, SLOT(slotSetOwnerIndex()), pActionCollection, "set_owner_index" );
    
    (void) new KAction( i18n("Set tables&pace..."), 0, 0, this, SLOT(slotSetTablespaceIndex()), pActionCollection, "set_tblspace_index" );
    
    //--- Rule related menu actions
    
    (void) new KAction( i18n("&Create rule..."), "wizard", 0, this, SLOT(slotCreateRule()), pActionCollection, "create_rule" );
    
    (void) new KAction( i18n("&Drop rule..."), "editdelete", 0, this, SLOT(slotDropRule()), pActionCollection, "drop_rule" );
    
    //--- Trigger related menu actions
    
    (void) new KAction( i18n("&Create trigger..."), "wizard", 0, this, SLOT(slotCreateTrigger()), pActionCollection, "create_trigger" );
    
    (void) new KAction( i18n("&Drop trigger..."), "editdelete", 0, this, SLOT(slotDropTrigger()), pActionCollection, "drop_trigger" );
    
    (void) new KAction( i18n("&Enable trigger..."), 0, 0, this, SLOT(slotEnableTrigger()), pActionCollection, "enable_trigger" );
    
    (void) new KAction( i18n("&Rename trigger..."), "edittool", 0, this, SLOT(slotRenameTrigger()), pActionCollection, "rename_trigger" );
    
  	//--- Type related menu actions
  
  	(void) new KAction( i18n("&Create base type..."), "wizard", 0, this, SLOT(slotCreateBaseType()), pActionCollection, "create_base_type" );
  
  	(void) new KAction( i18n("&Create composite type..."), "wizard", 0, this, SLOT(slotCreateCompositeType()), pActionCollection, "create_composite_type" );
  
  	(void) new KAction( i18n("&Drop type..."), "editdelete", 0, this, SLOT(slotDropType()), pActionCollection, "drop_type" );
  
  	(void) new KAction( i18n("Set &owner"), 0, 0, this, SLOT(slotSetOwnerType()), pActionCollection, "set_owner_type" );
  
	//--- Common menu actions
    (void) new KAction( i18n("Set description..."), "view_text", 0, this, SLOT(slotSetDescription()), pActionCollection, "set_description" ); 
  
	//-----------------------------------------------------------------
	// path toolbar
  	//-----------------------------------------------------------------
	m_pActPathCombo = new KPoGreComboAction( i18n("Path Bar"), 0, this,                                    SLOT(slotPathSelected(const QString &)), pActionCollection, "path_combo" );
	
	new KAction( i18n("Clear Path Bar"), BarIcon("locationbar_erase", 16), 0, this, SLOT(slotPathClear()), pActionCollection, "path_clear" );
	
	QLabel *locationLabel = new ToolbarLabel( i18n("Path: ") );
	
	new KWidgetAction( locationLabel, i18n("Path: "), 0, this, 0, pActionCollection, "path_label" );
	
	locationLabel->setBuddy( m_pActPathCombo->comboBox());
	
  
    //----------------------------------------------------------------------------
  	connect( m_pView, SIGNAL(sigSelectionChanged(const KPGTreeItem::eNodeType, KPGTreeItem *)), this, SLOT(slotSelectionChanged(const KPGTreeItem::eNodeType, KPGTreeItem *)) );
		
	m_pActDatabaseDisconnect->setEnabled(false);
	m_pActDatabaseWizard->setEnabled(false);
			
	m_pActEditFindNextInTree->setEnabled(false);
}


/////////////////////////////////////////////////////////////////////
//                     ACTION SLOTS
/////////////////////////////////////////////////////////////////////

void KPoGreController::slotFileNewWindow()
{
	slotStatusMsg(i18n("Opening a new application window..."));
		
	KPoGreView *new_window = new KPoGreView(KMdi::IDEAlMode);
	new_window->show();
	
	slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotFileNew()
{
  	slotStatusMsg(i18n("Creating new document..."));
  	m_pView->createQueryResultChildView(QString::null, QString::null);
  	slotStatusMsg(i18n("Ready.")); 
}

void KPoGreController::slotFileOpen()
{
	slotStatusMsg(i18n("Opening file..."));
		
	KPGQueryResultChildView* pChildView = m_pView->getActiveQueryResultChildView();
  	if(pChildView == 0)
  	{
  		slotFileNew();
  		slotFileOpen();
  	}
  	else
  	{
  		QString strEncoding(pChildView->encoding());
  		if(strEncoding != QString::null)
  		{
  			KURL url = pChildView->url();
  			
  			KEncodingFileDialog::Result r = KEncodingFileDialog::getOpenURLAndEncoding(
				strEncoding,
				url.isEmpty() ? QString::null : url.url(),
				i18n("*.sql|SQL files"),
				m_pView,
				i18n("Open File")
				);
				
			for (KURL::List::Iterator i=r.URLs.begin(); i != r.URLs.end(); ++i)
			{
				pChildView->setEncoding(r.encoding);
				if(pChildView->openDocument(*i))
					m_pActFileOpenRecent->addURL( *i );
					
				break;
			}
  		}
  		else
  		{
			KURL url = KFileDialog::getOpenURL(QString::null, 
				i18n("*.sql|SQL files"), 
				m_pView, 
				i18n("Open File...")
				);
				
			if(!url.isEmpty())
			{
				if(pChildView->openDocument(url))
					m_pActFileOpenRecent->addURL( url );
			}
		}
	}
		
	slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotFileOpenRecent(const KURL& url)
{
  	slotStatusMsg(i18n("Opening file..."));
	
  	KPGQueryResultChildView* pChildView = m_pView->getActiveQueryResultChildView();
  	if(pChildView == 0)
  	{
  		slotFileNew();
  		slotFileOpenRecent(url);
  	}
  	else
  	{
  		pChildView->openDocument(url);
	}

  	slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotFileClose()
{
	slotStatusMsg(i18n("Closing file..."));
	m_pView->requestClose();
	slotStatusMsg(i18n("Ready."));  
}

void KPoGreController::slotFileQuit()
{
	slotStatusMsg(i18n("Exiting..."));
	m_pView->saveOptions();
	m_pView->close();
}

void KPoGreController::slotEditFindInTree()
{
	slotStatusMsg( i18n("Find first occurence of text ...") );

	if ( ! m_pDlgSearch )
	{
		m_pDlgSearch = new KPGSearchDialog( m_pView, "search dialog", true );
	}
	
	if( m_pDlgSearch->exec() == KPGSearchDialog::Accepted )	
	{	
		slotEditFindNextInTree();
		m_pActEditFindNextInTree->setEnabled(true);
	}
	
	slotStatusMsg( i18n("Ready.") );
}

void KPoGreController::slotEditFindNextInTree()
{
	slotStatusMsg( i18n("Find next occurence of text ...") );

    if(! m_pDlgSearch)
    {
         kdError() << k_funcinfo << " Implementation error - no search dialog" << endl;
    }
	else
    {
        m_pView->editFind(m_pDlgSearch->getSearchString(), m_pDlgSearch->getOIDs(), m_pDlgSearch->getInNames());
    }
    	
	slotStatusMsg( i18n("Ready.") );
}

void KPoGreController::slotViewToolBar()
{
    slotStatusMsg(i18n("Toggling toolbar..."));
    ///////////////////////////////////////////////////////////////////
    // turn Toolbar on or off
    if(!m_pActViewToolBar->isChecked())
    {
        m_pView->toolBar("mainToolBar")->hide();
    }
    else
    {
        m_pView->toolBar("mainToolBar")->show();
    }		
    
    slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotViewStatusBar()
{
    slotStatusMsg(i18n("Toggle the statusbar..."));
    
    //turn Statusbar on or off
    if(!m_pActViewStatusBar->isChecked())
    {
        m_pView->statusBar()->hide();
    }
    else
    {
        m_pView->statusBar()->show();
    }
    
    slotStatusMsg(i18n("Ready."));
}

// Connect to Database Server
void KPoGreController::slotDatabaseConnect()
{
	slotStatusMsg(i18n("Connect to server ..."));
	m_pView->setCursor(KCursor::waitCursor());
	
	m_pView->databaseConnect();
	
	m_pView->setCursor(KCursor::arrowCursor());
	slotStatusMsg(i18n("Ready."));
}

// Disconnect Database 
void KPoGreController::slotDatabaseDisconnect()
{
	slotStatusMsg(i18n("Disconnect from server"));
	m_pView->databaseDisconnect();
	slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotDatabaseWizard()
{
    slotStatusMsg(i18n("Run wizard"));
    m_pView->databaseWizard();
    slotStatusMsg(i18n("Ready."));
}

// Save query result to file 
void KPoGreController::slotExportResult()
{
	QTable* outputArea = m_pView->getCurrentlySelectedTableResult();
    if(!outputArea)
    {
    	KMessageBox::sorry(m_pView, i18n("No result for export")); 
    	return;        
    }
                    
    int cols = outputArea->numCols();
    int rows = outputArea->numRows();
    if((cols == 0) || (rows == 0))
    {
    	KMessageBox::sorry(m_pView, i18n("Result is empty")); 
    	return;        
    }
            
	QString fileName = KFileDialog::getSaveFileName( QString(getenv("HOME") ), QString("*.csv"), m_pView, QString("Export query-result as ...") );
	if( fileName != QString::null ) 
	{			// OK, User made or selected a filename
		QFile* file = new QFile( fileName );
  		if( file->exists() )
		{ 
			// Is it already existing ?
  			QString error(fileName); 	
				error.append(i18n(" already exists!\n Do you wish to overwrite it ?"));
            if (KMessageBox::questionYesNo(m_pView, error, i18n("Overwrite File ?")) == KMessageBox::No) 
            {
                slotExportResult();	//user does not want to overwrite ! -> jump out and recall
                return;
            }
  	  }
		
        if ( ! file->open(IO_WriteOnly) ) 
        {  
            // Is he able to write to it ?
            QString error(i18n("Error writing to "));
            error.append(fileName);
            error.append(" !");
            KMessageBox::error( m_pView, error, i18n("Error"));
            return;
        }
        else 
        {   //Yes, he is able to write !
            QStringList list;
            list << "," << ";" << "|" << " ";
            QString sep = QInputDialog::getItem( i18n("Field Separator ?"), i18n("Please choose a field separator !"), list  );
            QTextStream out( file );
                        
            for( int currentRow=0 ; currentRow<rows ; currentRow++ )
            {
                for (int currentCol=0 ; currentCol<cols ; currentCol++ )
                {
                    out << "\"" << (outputArea->text( currentRow, currentCol )).stripWhiteSpace() << "\"" << sep;
                }
                out << "\n";
            }
            file->flush();
            file->close();
        }
	}
}

// Called when user press Bookmarks Button
void KPoGreController::slotBookmarksButtonPressed()
{
    m_pView->getBookmarksButton()->openPopup();
}


// Refresh selected item
void KPoGreController::slotRefresh()
{
	m_pView->setCursor(KCursor::waitCursor());
	m_pView->refresh();
	m_pView->setCursor(KCursor::arrowCursor());
}

// Force PostgreSQL server to reload configuration
void KPoGreController::slotReloadServerConfig()
{
	slotStatusMsg(i18n("Force PostgreSQL server to reload configuration ..."));
	
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pView->getTreeView()->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeServer)
	{
		kdDebug() << k_funcinfo << " Ttem types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem);
	
	try
    {
		bool bResult = pServer->reloadConfig();
		if(bResult)
			KMessageBox::information(m_pView, i18n("Operation successfull"));
		else
			KMessageBox::error(m_pView, i18n("Operation failed"));	
	}
	catch (const std::exception &e)
    {
        QTextCodec *pTextCodec = QTextCodec::codecForLocale(); 
		KMessageBox::sorry(m_pView, pTextCodec->toUnicode(e.what()));
    } 
	
    slotStatusMsg(i18n("Ready."));
}

// Force PostgreSQL server to rotate log file
void KPoGreController::slotRotateServerLogFile()
{
	slotStatusMsg(i18n("Force PostgreSQL server to rotate log file ..."));
	
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pView->getTreeView()->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeServer)
	{
		kdDebug() << k_funcinfo << " Ttem types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem);
	
	try
    {
		bool bResult = pServer->rotateLogFile();
		if(bResult)
			KMessageBox::information(m_pView, "Operation successfull");
		else
			KMessageBox::error(m_pView, "Operation failed");	
	}
	catch (const std::exception &e)
    {
        QTextCodec *pTextCodec = QTextCodec::codecForLocale(); 
		KMessageBox::sorry(m_pView, pTextCodec->toUnicode(e.what()));
    } 
	
    slotStatusMsg(i18n("Ready."));
}

// Run Create Database Wizard 
void KPoGreController::slotCreateDatabase()
{
    slotStatusMsg(i18n("Create new database ..."));
	m_pView->createDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run Create Database Wizard 
void KPoGreController::slotLoadDatabase()
{
    slotStatusMsg(i18n("Create database from dump..."));
    m_pView->loadDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run Drop Database Wizard 
void KPoGreController::slotDropDatabase()
{
  	slotStatusMsg(i18n("Drop database ..."));
	m_pView->dropDatabase();
  	slotStatusMsg(i18n("Ready."));
}

// Run ANALYSE Wizard
void KPoGreController::slotAnalyseDatabase()
{
    slotStatusMsg(i18n("Analyse database ..."));
    m_pView->analyseDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run REINDEX DATABASE Wizard
void KPoGreController::slotReindexDatabase()
{
    slotStatusMsg(i18n("Reindex database ..."));
    m_pView->reindexDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run ALTER DATABASE name OWNER TO new_owner Wizard
void KPoGreController::slotSetOwnerDatabase()
{
  slotStatusMsg(i18n("Set new database owner ..."));
  m_pView->setOwnerDatabase();
  slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for database
void KPoGreController::slotGrantPrivilegesDatabase()
{
    slotStatusMsg(i18n("Grant database privileges ..."));
    m_pView->grantPrivilegesDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for database
void KPoGreController::slotRevokePrivilegesDatabase()
{
    slotStatusMsg(i18n("Revoke database provileges ..."));
    m_pView->revokePrivilegesDatabase();
    slotStatusMsg(i18n("Ready."));
}    

// Run DUMP DATABASE Wizard
void KPoGreController::slotDumpDatabase()
{
    slotStatusMsg(i18n("Dump database ..."));
    m_pView->dumpDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run RESTORE DATABASE Wizard
void KPoGreController::slotRestoreDatabase()
{
    slotStatusMsg(i18n("Restore database ..."));
    m_pView->restoreDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Close connection to database
void KPoGreController::slotDisconnectDatabase()
{
    slotStatusMsg(i18n("Disconnect from database ..."));
    m_pView->disconnectDatabase();
    slotStatusMsg(i18n("Ready."));
}

// Run Create Schema Wizard 
void KPoGreController::slotCreateSchema()
{
    slotStatusMsg(i18n("Create new schema ..."));
	m_pView->createSchema();
    slotStatusMsg(i18n("Ready."));
}

// Run Drop Schema Wizard 
void KPoGreController::slotDropSchema()
{
    slotStatusMsg(i18n("Drop schema ..."));
	m_pView->dropSchema();
    slotStatusMsg(i18n("Ready."));
}

// Run Create or Replace Schema Wizard 
void KPoGreController::slotModifySchema()
{
    slotStatusMsg(i18n("Modify schema ..."));
	m_pView->modifySchema();
    slotStatusMsg(i18n("Ready."));
}

// Run ALTER Schema OWNER TO new_owner Wizard 
void KPoGreController::slotSetOwnerSchema()
{
    slotStatusMsg(i18n("Set schema owner ..."));
    m_pView->setOwnerSchema();
    slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for schema
void KPoGreController::slotGrantPrivilegesSchema()
{
    slotStatusMsg(i18n("Grant schema privileges ..."));
    m_pView->grantPrivilegesSchema();
    slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for schema
void KPoGreController::slotRevokePrivilegesSchema()
{
    slotStatusMsg(i18n("Revoke schema privileges ..."));
    m_pView->revokePrivilegesSchema();
    slotStatusMsg(i18n("Ready."));
}    

// Run Create Table Wizard 
void KPoGreController::slotCreateTable()
{
    slotStatusMsg(i18n("Create table ..."));
	m_pView->createTable();
    slotStatusMsg(i18n("Ready."));
}

// Run Drop Table Wizard 
void KPoGreController::slotDropTable()
{
  slotStatusMsg(i18n("Drop table ..."));
	m_pView->dropTable();
  slotStatusMsg(i18n("Ready."));
}

// Run Alter Table Rename Wizard 
void KPoGreController::slotRenameTable()
{
  slotStatusMsg(i18n("Rename table ..."));
  m_pView->renameTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotAnalyseTable()
{
  slotStatusMsg(i18n("Analyse table ..."));
  m_pView->analyseTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotVacuumTable()
{
  slotStatusMsg(i18n("Vacuum table ..."));
  m_pView->vacuumTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotReindexTable()
{
  slotStatusMsg(i18n("Reindex table ..."));
  m_pView->reindexTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetClusterOnTable()
{
  slotStatusMsg(i18n("Set cluster on table ..."));
  m_pView->setClusterOnTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetWithoutClusterTable()
{
  slotStatusMsg(i18n("Set table without cluster ..."));
  m_pView->setWithoutClusterTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotClusterTable()
{
  slotStatusMsg(i18n("Cluster table ..."));
  m_pView->clusterTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotCopyFromTable()
{
  slotStatusMsg(i18n("Copy from table ..."));
  m_pView->copyFromTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotCopyToTable()
{
  slotStatusMsg(i18n("Copy to table ..."));
  m_pView->copyToTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetOwnerTable()
{
  slotStatusMsg(i18n("Set table owner ..."));
  m_pView->setOwnerTable();
  slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for table
void KPoGreController::slotGrantPrivilegesTable()
{
  slotStatusMsg(i18n("Grant table privileges ..."));
  m_pView->grantPrivilegesTable();
  slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for table
void KPoGreController::slotRevokePrivilegesTable()
{
  slotStatusMsg(i18n("Revoke table privileges..."));
  m_pView->revokePrivilegesTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetTablespaceTable()
{
  slotStatusMsg(i18n("Choose tablespace for table ..."));
  m_pView->setTablespaceTable();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetWithoutOIDsTable()
{
    slotStatusMsg(i18n("Set table to without OIDs ..."));
    m_pView->setWithoutOIDsTable();
    slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotEditTableContent()
{
    slotStatusMsg(i18n("Edit table content ..."));
    m_pView->editTableContent();
    slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotQueryTable()
{
    slotStatusMsg(i18n("Query table ..."));
    m_pView->queryTable();
    slotStatusMsg(i18n("Ready."));
}

// Run Create View Wizard 
void KPoGreController::slotCreateView()
{
  slotStatusMsg(i18n("Create view ..."));
	m_pView->createView();
  slotStatusMsg(i18n("Ready."));
}

// Run Drop View Wizard 
void KPoGreController::slotDropView()
{
  slotStatusMsg(i18n("Drop view ..."));
	m_pView->dropView();
  slotStatusMsg(i18n("Ready."));
}

// Run Create or Replace View Wizard 
void KPoGreController::slotModifyView()
{
  	slotStatusMsg(i18n("Modify view ..."));
	m_pView->modifyView();
  	slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotQueryView()
{
    slotStatusMsg(i18n("Query table ..."));
    m_pView->queryView();
    slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for view
void KPoGreController::slotGrantPrivilegesView()
{
  slotStatusMsg(i18n("Grant view privileges..."));
  m_pView->grantPrivilegesView();
  slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for view
void KPoGreController::slotRevokePrivilegesView()
{
  slotStatusMsg(i18n("Revoke view privileges..."));
  m_pView->revokePrivilegesView();
  slotStatusMsg(i18n("Ready."));
}

// Run Create Tablespace Wizard 
void KPoGreController::slotCreateTablespace()
{
  slotStatusMsg(i18n("Create tablespace ..."));
  m_pView->createTablespace();
  slotStatusMsg(i18n("Ready."));
}

// Run Drpp Tablespace Wizard 
void KPoGreController::slotDropTablespace()
{
  slotStatusMsg(i18n("Drop tablespace ..."));
  m_pView->dropTablespace();
  slotStatusMsg(i18n("Ready."));
}

// ALTER TABLESPACE name RENAME TO newname Wizard 
void KPoGreController::slotRenameTablespace()
{
  slotStatusMsg(i18n("Rename tablespace ..."));
  m_pView->renameTablespace();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER TABLESPACE name OWNER TO newowner Wizard 
void KPoGreController::slotSetOwnerTablespace()
{
  slotStatusMsg(i18n("Modify tablespace ..."));
  m_pView->setOwnerTablespace();
  slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for tablespace
void KPoGreController::slotGrantPrivilegesTablespace()
{
  slotStatusMsg(i18n("Grant tablespace privileges..."));
  m_pView->grantPrivilegesTablespace();
  slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for tablespace
void KPoGreController::slotRevokePrivilegesTablespace()
{
  slotStatusMsg(i18n("Revoke tablespace privileges..."));
  m_pView->revokePrivilegesTablespace();
  slotStatusMsg(i18n("Ready."));
}   

// Run Create User Wizard 
void KPoGreController::slotCreateUser()
{
  slotStatusMsg(i18n("Create user ..."));
	m_pView->createUser();
  slotStatusMsg(i18n("Ready."));
}

// Run Drpp User Wizard 
void KPoGreController::slotDropUser()
{
  slotStatusMsg(i18n("Drop user ..."));
	m_pView->dropUser();
  slotStatusMsg(i18n("Ready."));
}

// Run Alter User Wizard 
void KPoGreController::slotModifyUser()
{
  slotStatusMsg(i18n("Modify user ..."));
	m_pView->modifyUser();
  slotStatusMsg(i18n("Ready."));
}

// Run Create View Group 
void KPoGreController::slotCreateGroup()
{
  slotStatusMsg(i18n("Create group ..."));
	m_pView->createGroup();
  slotStatusMsg(i18n("Ready."));
}

// Run Drpp Group Wizard 
void KPoGreController::slotDropGroup()
{
  slotStatusMsg(i18n("Drop group ..."));
	m_pView->dropGroup();
  slotStatusMsg(i18n("Ready."));
}

// Run Alter Group Wizard 
void KPoGreController::slotModifyGroup()
{
  	slotStatusMsg(i18n("Modify group ..."));
	m_pView->modifyGroup();
  	slotStatusMsg(i18n("Ready."));
}

// Run Create Language Wizard 
void KPoGreController::slotCreateLanguage()
{
	slotStatusMsg(i18n("Create language ..."));
	m_pView->createLanguage();
	slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Language Wizard 
void KPoGreController::slotDropLanguage()
{
	slotStatusMsg(i18n("Drop language ..."));
	m_pView->dropLanguage();
	slotStatusMsg(i18n("Ready."));
}
    
// Run Alter Language Wizard 
void KPoGreController::slotModifyLanguage()
{
	slotStatusMsg(i18n("Modify language ..."));
	m_pView->modifyLanguage();
	slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for language
void KPoGreController::slotGrantPrivilegesLanguage()
{
	slotStatusMsg(i18n("Grant language privileges..."));
	m_pView->grantPrivilegesLanguage();
	slotStatusMsg(i18n("Ready."));
}

// Run REVOKE privileges Wizard for language
void KPoGreController::slotRevokePrivilegesLanguage()
{
  slotStatusMsg(i18n("Revoke language privileges..."));
  m_pView->revokePrivilegesLanguage();
  slotStatusMsg(i18n("Ready."));
}    

// Run CREATE DOMAIN Wizard 
void KPoGreController::slotCreateDomain()
{
  slotStatusMsg(i18n("Create domain ..."));
  m_pView->createDomain();
  slotStatusMsg(i18n("Ready."));
}

// Run DROP DOMAIN Wizard 
void KPoGreController::slotDropDomain()
{
  slotStatusMsg(i18n("Drop domain ..."));
  m_pView->dropDomain();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN SET | DROP NOT NULL Wizard 
void KPoGreController::slotSetDomainNull()
{
  slotStatusMsg(i18n("Set domain NULL..."));
  m_pView->setDomainNull();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN SET DEFAULT expression Wizard 
void KPoGreController::slotSetDomainDefault()
{
  slotStatusMsg(i18n("Set domain default ..."));
  m_pView->setDomainDefault();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN DROP DEFAULT Wizard 
void KPoGreController::slotDropDomainDefault()
{
  slotStatusMsg(i18n("Drop domain default..."));
  m_pView->dropDomainDefault();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN name OWNER TO new_owner  Wizard 
void KPoGreController::slotSetOwnerDomain()
{
  slotStatusMsg(i18n("Set owner..."));
  m_pView->setOwnerDomain();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN name ADD domain_constraint Wizard 
void KPoGreController::slotCreateDomainConstraint()
{
  slotStatusMsg(i18n("Create domain constraint..."));
  m_pView->createDomainConstraint();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER DOMAIN name DROP CONSTRAINT constraint_name Wizard 
void KPoGreController::slotDropDomainConstraint()
{
  slotStatusMsg(i18n("Drop domain constraint..."));
  m_pView->dropDomainConstraint();
  slotStatusMsg(i18n("Ready."));
}    
    
// Run Create Function Wizard 
void KPoGreController::slotCreateFunction()
{
  slotStatusMsg(i18n("Create function ..."));
  m_pView->createFunction();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Function Wizard 
void KPoGreController::slotDropFunction()
{
  slotStatusMsg(i18n("Drop function ..."));
  m_pView->dropFunction();
  slotStatusMsg(i18n("Ready."));
}
   
// Run Alter Function Wizard 
void KPoGreController::slotRenameFunction()
{
  slotStatusMsg(i18n("Rename function ..."));
  m_pView->renameFunction();
  slotStatusMsg(i18n("Ready."));
}
 
// Run Alter Function Wizard 
void KPoGreController::slotModifyFunction()
{
  slotStatusMsg(i18n("Modify function ..."));
  m_pView->modifyFunction();
  slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for function
void KPoGreController::slotGrantPrivilegesFunction()
{
  slotStatusMsg(i18n("Grant function privileges..."));
  m_pView->grantPrivilegesFunction();
  slotStatusMsg(i18n("Ready."));
}    
    
// Run REVOKE privileges Wizard for function
void KPoGreController::slotRevokePrivilegesFunction()
{
  slotStatusMsg(i18n("Revoke function privileges..."));
  m_pView->revokePrivilegesFunction();
  slotStatusMsg(i18n("Ready."));
}    

// Run Function executor
void KPoGreController::slotExecuteFunction()
{
	slotStatusMsg(i18n("Execute function ..."));
    m_pView->executeFunction();
    slotStatusMsg(i18n("Ready."));
}

// Run Function debugger
void KPoGreController::slotDebugFunction()
{
	slotStatusMsg(i18n("Debug function ..."));
	
	//KMessageBox::sorry( m_pView, "Not implemented yet ...", "KPoGre");
    //return;
	
    m_pView->debugFunction();
    slotStatusMsg(i18n("Ready."));
}
   
// Attach Function to currently opened debugger
void KPoGreController::slotDebugFunctionAttach()
{
	slotStatusMsg(i18n("Attach function to debugger ..."));
	
	m_pView->debugFunctionAttach();
	slotStatusMsg(i18n("Ready."));
} 

// Run Create Sequence Wizard 
void KPoGreController::slotCreateSequence()
{
  slotStatusMsg(i18n("Create sequence ..."));
  m_pView->createSequence();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Sequence Wizard 
void KPoGreController::slotDropSequence()
{
  slotStatusMsg(i18n("Drop sequence ..."));
  m_pView->dropSequence();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER Sequence Wizard 
void KPoGreController::slotModifySequence()
{
  slotStatusMsg(i18n("Modify sequence ..."));
  m_pView->modifySequence();
  slotStatusMsg(i18n("Ready."));
}

// Run GRANT privileges Wizard for sequence
void KPoGreController::slotGrantPrivilegesSequence()
{
  slotStatusMsg(i18n("Grant sequence privileges..."));
  m_pView->grantPrivilegesSequence();
  slotStatusMsg(i18n("Ready."));
}
    
// Run REVOKE privileges Wizard for sequence
void KPoGreController::slotRevokePrivilegesSequence()
{
  slotStatusMsg(i18n("Revoke sequence privileges..."));
  m_pView->revokePrivilegesSequence();
  slotStatusMsg(i18n("Ready."));
}    

// Run ALTER table ADD Column Wizard
void KPoGreController::slotCreateColumn()
{
  slotStatusMsg(i18n("Create column ..."));
  m_pView->createColumn();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table DROP Column Wizard
void KPoGreController::slotDropColumn()
{
  slotStatusMsg(i18n("Drop column ..."));
  m_pView->dropColumn();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table Rename Column Wizard
void KPoGreController::slotRenameColumn()
{
  slotStatusMsg(i18n("Rename column ..."));
  m_pView->renameColumn();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table SET/DROP Column NULL Wizard
void KPoGreController::slotSetColumnNull()
{
  slotStatusMsg(i18n("Set column NULL ..."));
  m_pView->setColumnNull();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table ALTER Column SET DEFAULT Wizard
void KPoGreController::slotSetColumnDefault()
{
  slotStatusMsg(i18n("Set column default ..."));
  m_pView->setColumnDefault();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER table ALTER Column DROP DEFAULT Wizard
void KPoGreController::slotDropColumnDefault()
{
  slotStatusMsg(i18n("Drop clumn default ..."));
  m_pView->dropColumnDefault();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table ALTER Column TYPE Wizard
void KPoGreController::slotChangeColumnType()
{
  slotStatusMsg(i18n("Change column type ..."));
  m_pView->changeColumnType();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table ALTER Column SET STORAGE { PLAIN | EXTERNAL | EXTENDED | MAIN } Wizard
void KPoGreController::slotSetColumnStorage()
{
  slotStatusMsg(i18n("Set column storage ..."));
  m_pView->setColumnStorage();
  slotStatusMsg(i18n("Ready."));
}
    
// Run ALTER table ALTER Column SET STATISTICS Wizard
void KPoGreController::slotSetColumnStatistisc()
{
  slotStatusMsg(i18n("Set column statistics ..."));
  m_pView->setColumnStatistisc();
  slotStatusMsg(i18n("Ready."));
}    

    
// Run Create Constraint Wizard 
void KPoGreController::slotCreateConstraint()
{
  slotStatusMsg(i18n("Create constraint ..."));
  m_pView->createConstraint();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Constraint Wizard 
void KPoGreController::slotDropConstraint()
{
  slotStatusMsg(i18n("Drop constraint ..."));
  m_pView->dropConstraint();
  slotStatusMsg(i18n("Ready."));
}

// Run Create Index Wizard 
void KPoGreController::slotCreateIndex()
{
  slotStatusMsg(i18n("Create index ..."));
  m_pView->createIndex();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Index Wizard 
void KPoGreController::slotDropIndex()
{
  slotStatusMsg(i18n("Drop index ..."));
  m_pView->dropIndex();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER Index RENAME Wizard 
void KPoGreController::slotRenameIndex()
{
  slotStatusMsg(i18n("Rename index ..."));
  m_pView->renameIndex();
  slotStatusMsg(i18n("Ready."));
}

// Run REINDEX INDEX Wizard 
void KPoGreController::slotReindexIndex()
{
  slotStatusMsg(i18n("Reindex index ..."));
  m_pView->reindexIndex();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER Index OWNER TO new_owner Wizard 
void KPoGreController::slotSetOwnerIndex()
{
  slotStatusMsg(i18n("Set index owner ..."));
  m_pView->setOwnerIndex();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER Index SET TABLESPACE indexspace_name Wizard 
void KPoGreController::slotSetTablespaceIndex()
{
  slotStatusMsg(i18n("Rename tablespace for index ..."));
  m_pView->setTablespaceIndex();
  slotStatusMsg(i18n("Ready."));
}

// Run Create Rule Wizard 
void KPoGreController::slotCreateRule()
{
  slotStatusMsg(i18n("Create rule ..."));
  m_pView->createRule();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Rule Wizard 
void KPoGreController::slotDropRule()
{
  slotStatusMsg(i18n("Drop rule ..."));
  m_pView->dropRule();
  slotStatusMsg(i18n("Ready."));
}

// Run Create Trigger Wizard 
void KPoGreController::slotCreateTrigger()
{
  slotStatusMsg(i18n("Create trigger ..."));
  m_pView->createTrigger();
  slotStatusMsg(i18n("Ready."));
}
  
// Run Drop Trigger Wizard 
void KPoGreController::slotDropTrigger()
{
  slotStatusMsg(i18n("Drop trigger ..."));
  m_pView->dropTrigger();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER table ENABLE/DISABLE trigger Wizard 
void KPoGreController::slotEnableTrigger()
{
  slotStatusMsg(i18n("Enable/disable trigger ..."));
  m_pView->enableTrigger();
  slotStatusMsg(i18n("Ready."));
}

// Run ALTER Trigger RENAME Wizard 
void KPoGreController::slotRenameTrigger()
{
  slotStatusMsg(i18n("Rename trigger ..."));
  m_pView->renameTrigger();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotCreateBaseType()
{
  slotStatusMsg(i18n("Create base type ..."));
  m_pView->createBaseType();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotCreateCompositeType()
{
  slotStatusMsg(i18n("Create composite type ..."));
  m_pView->createCompositeType();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotDropType()
{
  slotStatusMsg(i18n("Drop type ..."));
  m_pView->dropType();
  slotStatusMsg(i18n("Ready."));
}

void KPoGreController::slotSetOwnerType()
{
  slotStatusMsg(i18n("Set type owner ..."));
  m_pView->setOwnerType();
  slotStatusMsg(i18n("Ready."));
}  

void KPoGreController::slotSetDescription()
{
	slotStatusMsg("Set Description...");
	m_pView->setDescription();
	slotStatusMsg("Ready.");
}

/////////////////////////////////////////////////////////////////////
//                           OTHER SLOTS
/////////////////////////////////////////////////////////////////////


void KPoGreController::slotPathSelected( const QString & strPath )
{
	if(!m_pView->selectItemByPath(strPath))
	{ // node not found, remove item from combo
		m_pActPathCombo->removeItem(strPath);
		m_pActPathCombo->slotClearEdit();
	}
}

void KPoGreController::slotPathClear()
{
	m_pView->slotEditDeselect();
	m_pActPathCombo->slotFocusEdit();
}


void KPoGreController::slotSelectionChanged( const KPGTreeItem::eNodeType nodeType, KPGTreeItem * pItem)
{
	bool bActDatabaseWizard = false;
	bool bActDatabaseDisconnect = false;
	bool bAddBookmarkMenu = false;
		
	
	KActionCollection *pActionCollection = m_pView->actionCollection();
	
	switch(nodeType)
  	{
    	case KPGTreeItem::nodeUnselected:
        	m_pActDatabaseDisconnect->setEnabled(false);
        	break;

    	case KPGTreeItem::nodeServer:
      	{
        	bActDatabaseDisconnect = true;
        	bAddBookmarkMenu = true;
			bActDatabaseWizard = true;
				
        	KPGServer *pServer = static_cast <KPGServer *> (pItem);            
        	m_pView->getBookmarksButton()->bookmarkHandler()->setNewBookmarkName(pServer->text(0));
        	m_pView->getBookmarksButton()->bookmarkHandler()->setNewBookmarkUrl(pServer->url());
        
      	}
      	break;
				
		case KPGTreeItem::nodeFunction:
      	{
        	KPGFunction *pFunction = static_cast <KPGFunction *> (pItem);            
			KPGServer *pServer = static_cast <KPGServer *> (pFunction->getParentByType(KPGTreeItem::nodeServer));
			
			bool bVersion8_3 = false;
			if(pServer) bVersion8_3 = (((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 3))
						|| (pServer->versionMajor() > 8));
			
			KAction *pAct = pActionCollection->action("modify_function");
			if(pAct)
			{
				pAct->setEnabled(pFunction->langName() != "c"); // Don't allow modify C function
			}
			
			pAct = pActionCollection->action("debug_function");
			if(pAct)
			{
				pAct->setEnabled(bVersion8_3 && (pFunction->langName() == "plpgsql")); // Allow debug only plpgsql function
			}
			
			pAct = pActionCollection->action("debug_function_attach");
			if(pAct)
			{
				pAct->setEnabled(bVersion8_3 && (pFunction->langName() == "plpgsql")); // Allow debug only plpgsql function
			}
      	}
      	break;
      
    	case KPGTreeItem::nodeTablespace:
      	{
			KPGTablespace *pTablespace = static_cast <KPGTablespace *> (pItem);            
			
			KAction *pActModify = pActionCollection->action("modify_tablespace");
			if(pActModify)
			{
			pActModify->setEnabled(!pTablespace->isSystemObject()); // Don't allow modify system tablespaces
			}
			
			KAction *pActDrop = pActionCollection->action("drop_tablespace");
			if(pActDrop)
			{
			pActDrop->setEnabled(!pTablespace->isSystemObject()); // Don't allow drop system tablespaces
			}
      	}
      	break;
		      
		case KPGTreeItem::nodeDatabase:
      	{
			bActDatabaseWizard = true;
			
			KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem);            
			
			KAction *pActModify = pActionCollection->action("modify_database");
			if(pActModify)
			{
				pActModify->setEnabled(!pDatabase->isSystemObject() && !pDatabase->isTemplate()); // Don't allow modify system databases
			}
			
			KAction *pActDrop = pActionCollection->action("drop_database");
			if(pActDrop)
			{
				pActDrop->setEnabled(!pDatabase->isSystemObject() && !pDatabase->isTemplate()); // Don't allow drop system databases
			}
      	}
     	break;  
    
    	case KPGTreeItem::nodeSchema:
      	{
			bActDatabaseWizard = true;
			
			KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);            
			
			KAction *pActModify = pActionCollection->action("rename_schema");
			if(pActModify)
			{
			pActModify->setEnabled(!pSchema->isSystemObject()); // Don't allow rename system schema
			}
			
			KAction *pActDrop = pActionCollection->action("drop_schema");
			if(pActDrop)
			{
			pActDrop->setEnabled(!pSchema->isSystemObject()); // Don't allow drop system schema
			}
			
			KAction *pActSetOwner = pActionCollection->action("set_owner_schema");
			if(pActSetOwner)
			{
				pActSetOwner->setEnabled(!pSchema->isSystemObject()); // Don't allow reowner system schema
			}
      	}
        break;
    
    	case KPGTreeItem::nodeTable:
      	{
			bActDatabaseWizard = true;
			
			KPGTable *pTable = static_cast <KPGTable *> (pItem);
			KPGServer *pServer = static_cast <KPGServer *> (pTable->getParentByType(KPGTreeItem::nodeServer));
			
			bool bVersion8 = false;
			if(pServer) bVersion8 = (pServer->versionMajor() >= 8);
			
			pActionCollection->action("set_tblspace_table")->setEnabled(bVersion8);
      	}
      	break;     
            	
      
    	case KPGTreeItem::nodeTableColumn:
      	{
			KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pItem);
			KPGServer *pServer = static_cast <KPGServer *> (pColumn->getParentByType(KPGTreeItem::nodeServer));
			
			bool bEnableModifyAct = (pColumn->attNum() > 0); // don't allow modify system columns
			bool bVersion8 = false;
			
			if(pServer) bVersion8 = (pServer->versionMajor() >= 8);
			
			pActionCollection->action("drop_column")->setEnabled(bEnableModifyAct);
			pActionCollection->action("rename_column")->setEnabled(bEnableModifyAct);
			KAction *pActSetNull = pActionCollection->action("set_column_null");
			pActSetNull->setEnabled(bEnableModifyAct);
			pActionCollection->action("set_column_default")->setEnabled(bEnableModifyAct);
			pActionCollection->action("drop_column_default")->setEnabled(bEnableModifyAct && pColumn->hasDefault());
			pActionCollection->action("change_column_type")->setEnabled(bEnableModifyAct && bVersion8);
			pActionCollection->action("set_column_storage")->setEnabled(bEnableModifyAct);
			pActionCollection->action("set_column_stat")->setEnabled(bEnableModifyAct);
			
			if(!pColumn->isNotNull())
			pActSetNull->setText(i18n("Set &NOT NULL..."));
			else
			pActSetNull->setText(i18n("Drop &NOT NULL..."));
      	}
      	break;
      
		case KPGTreeItem::nodePrimaryKey:
		case KPGTreeItem::nodeIndex:
      	{
			KPGTableIndex *pTableIndex = static_cast <KPGTableIndex *> (pItem);
			KPGServer *pServer = static_cast <KPGServer *> (pTableIndex->getParentByType(KPGTreeItem::nodeServer));
			
			bool bVersion8 = false;
			if(pServer) bVersion8 = (pServer->versionMajor() >= 8);
			
			pActionCollection->action("set_owner_index")->setEnabled(bVersion8);
			pActionCollection->action("set_tblspace_index")->setEnabled(bVersion8);
      	}
      	break;  
    
    	case KPGTreeItem::nodeDomain:
      	{
			KPGDomain *pDomain = static_cast <KPGDomain *> (pItem);
			
			KAction *pActSetNull = pActionCollection->action("set_domain_null");
			pActionCollection->action("drop_domain_default")->setEnabled(pDomain->hasDefault());
			
			if(!pDomain->isNotNull())
				pActSetNull->setText(i18n("Set &NOT NULL..."));
			else
				pActSetNull->setText(i18n("Drop &NOT NULL..."));
      	}
      	break;
               
        case KPGTreeItem::nodeTrigger:
      	{
			KPGTrigger *pTrigger = static_cast <KPGTrigger *> (pItem);
			
			KAction *pActEnableTrigger = pActionCollection->action("enable_trigger");
			
			if(!pTrigger->isEnabled())
				pActEnableTrigger->setText(i18n("&Enable trigger..."));
			else
				pActEnableTrigger->setText(i18n("&Disable trigger..."));
      	}
      	break;
               
      
		default:	
				break;
  }
	
	m_pActDatabaseDisconnect->setEnabled(bActDatabaseDisconnect);
	m_pActDatabaseWizard->setEnabled(bActDatabaseWizard);
	m_pView->getBookmarksButton()->enableAddBookmarkMenu(bAddBookmarkMenu);
	
	// change path combo text
	if(pItem)
		{ 
			QString strPath(pItem->path());
			
			if((pItem->hasOid()))
			{
				KPGObject *pObject = static_cast <KPGObject *> (pItem);
				
				strPath.append(QString("[%1]").arg(pObject->oid()));
			}
		  m_pActPathCombo->insertItem(* pItem->pixmap(0), strPath);
		}
	else
		m_pActPathCombo->slotClear();
	
}

// Called, when document is modified. Enable Save button. */
void KPoGreController::slotDocumentModified()
{
	//m_pActFileSave->setEnabled(true);
	//setCaption(doc->URL().fileName(), true);
}

void KPoGreController::slotStatusMsg(const QString &text)
{
	// change status message permanently
  	m_pView->statusBar()->clear();
  	m_pView->statusBar()->changeItem(text, ID_STATUS_MSG);
}

