//
// C++ Implementation: kpgutil
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgutil.h"


#include <qtable.h>
#include <qtextcodec.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qinputdialog.h>

// include files for KDE
#include <kdebug.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <klocale.h>

#include "kpglinklabel.h"
#include "DbObjects/kpgdatabase.h"
#include "DbObjects/kpgschema.h"


QPixmap * KPGUtil::m_pIconTrue = 0;
QPixmap * KPGUtil::m_pIconFalse = 0;

KPGUtil::KPGUtil()
{
}

KPGUtil::~KPGUtil()
{
}

const QString KPGUtil::quotedName(const QString &strName)
{
	if(strName.contains('\"'))
	{
		kdError() << k_funcinfo << "Name already contain quote: " << strName << endl;
	}
	
	if(strName.contains('('))
	{
		int indexOfLeftParenthesis = strName.find('(');
		QString strNamePart1 = strName.left(indexOfLeftParenthesis);
		QString strNamePart2 = strName.mid(indexOfLeftParenthesis, strName.length() - indexOfLeftParenthesis);
		
		kdDebug() << strName << endl;
		kdDebug() << strNamePart1 << endl;
		kdDebug() << strNamePart2 << endl;
		
		if(strNamePart1.contains(' ') || containsUpperCase(strNamePart1))
		{
			return QString("\"" + strNamePart1 + "\"" + strNamePart2);
		}
	}
	else
	{
		if(strName.contains(' ') || containsUpperCase(strName))
		{
			return QString("\"" + strName + "\"");
		}
	}
	
	return strName;
}

const QString KPGUtil::unspacedName(const QString &strName)
{
	QString strNameUnspaced = strName;
	strNameUnspaced.replace(" ", "_");
	return strNameUnspaced;
}

const QString KPGUtil::unquotedName(const QString &strName)
{
	QString strNameUnquoted = strName;
	strNameUnquoted.replace("\"", "");
	return strNameUnquoted;
}

const QString KPGUtil::fullyQualifiedName(
	const QString &strNamespaceName, 
	const QString &strObjectName)
{
	return QString(quotedName(strNamespaceName) + "." + quotedName(strObjectName));
}

// Return true, if given string contains Upper-case character
bool KPGUtil::containsUpperCase(const QString &strName)
{
	for(unsigned int i = 0; i < strName.length(); i++)
	{
		if(strName[i].category() == QChar::Letter_Uppercase)
		{
			return true;
		}
	}
	return false;
}

int KPGUtil::fillPropertiesTable(const pqxx::result &pqxxResult, 
	QTable *pTable,
 	QTextCodec *pTextCodec, 
 	bool bAllowOidOnlyIn1stCol, 
  	int nMaxColumn)
{
	// Fill output area with query result
	int nRows = pqxxResult.size();
	int nCols = pqxxResult.columns();
	
	// Compute table columns. OIDs, that aren't 1.st in tuple are NOT displayed
	int nTableCols = 0;
	int nCol;
  	for(nCol = 0; nCol < nCols; nCol++)
  	{
  		if(pqxxResult.column_type(nCol) == 26) // OID ?
	  	{ ; /* do not count OIDs */ }
		else
		{
			nTableCols++;
		}
		
		if((nMaxColumn > 0) && (nTableCols >= nMaxColumn))
			break;
  	}
	
	// Set table size
	pTable->setNumRows(nRows);
  	pTable->setNumCols(nTableCols);

	// fill table with result data
	for(int nRow = 0; nRow < nRows; nRow++)
  	{
    	int nCol = 0;
		for(int nTableCol = 0; nTableCol < nTableCols; nTableCol++)
		{
			if((!bAllowOidOnlyIn1stCol || (nCol == 0)) && (pqxxResult.column_type(nCol) == 26)) // OID ?
			{
				pqxx::oid oid = 0;
				pqxxResult[nRow][nCol].to(oid);
				nCol++;
					
				KPGLinkLabel *pLabel = new KPGLinkLabel( pTable/*, QString("%1").arg(oid) */);
				pLabel->setValues(oid, pqxxResult[nRow][nCol].c_str());
				pTable->setCellWidget(nRow, nTableCol, pLabel);
			}
			else
			{
				if(pqxxResult.column_type(nCol) != 26)
				{
					if(pqxxResult.column_type(nCol) == 16) // boolean
					{
					   bool bValue;
					   pqxxResult[nRow][nCol].to(bValue);
					   
					   pTable->setPixmap(nRow, nTableCol, bValue ? *m_pIconTrue : *m_pIconFalse);
					}
					else
					{
						QString strValue(pTextCodec->toUnicode(pqxxResult[nRow][nCol].c_str()));
					   	pTable->setText(nRow, nTableCol, strValue);
					}
					//kdDebug() << strValue << QString(" %1 ").arg(pqxxResult.column_type(nCol)) << endl;
				}
				else
				{
				    nCol++; // skip OID
				    
					QString strValue(pTextCodec->toUnicode(pqxxResult[nRow][nCol].c_str()));
					pTable->setText(nRow, nTableCol, strValue);
				}
			}
			nCol++;
		}
  	}
  	
  	//--- Adjust DataTable columns size
    for(int nCol = 0; nCol < nTableCols; nCol++)
    {
        pTable->adjustColumn(nCol);
    }

	return nTableCols;
}

void KPGUtil::fillComboBoxWithDatabaseSchemas(KPGDatabase *pDatabase, KComboBox *m_pComboBox, bool bOnlyUserSchemas)
{
	QListViewItem * pItem = pDatabase->firstChild();
	while(pItem)
	{
		KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
		
		if(pTreeItem->type() == KPGTreeItem::nodeSchema)
		{
		  KPGSchema *pSchema = static_cast <KPGSchema *> (pTreeItem);
		
		  if(!bOnlyUserSchemas || !pSchema->isSystemObject())
			m_pComboBox->insertItem(* pTreeItem->pixmap(0), pTreeItem->text(0));
		}
		
		pItem = pItem->nextSibling();
	}
}

void KPGUtil::copyCell(QTable *pTable)
{
	if(pTable)
	{
		int currentRow = pTable->currentRow();
		int currentCol = pTable->currentColumn();
		
		if((currentRow >= 0) && (currentCol >= 0))
		{	
			QWidget *w = pTable->cellWidget(currentRow, currentCol);
			if((w != 0) && (w->className() == QString("KPGLinkLabel")))
			{
				KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
				QApplication::clipboard()->setText(pLabel->text());
			}
			else
			{
				QApplication::clipboard()->setText(pTable->text(currentRow, currentCol));
			}
		}
	}
}

void KPGUtil::copyRow(QTable *pTable)
{
	if(pTable)
	{
		int currentRow = pTable->currentRow();
		if(currentRow >= 0)
		{
			QStringList strListSeparators;
			strListSeparators << "," << ";" << "|" << " ";
			QString strSeparator = QInputDialog::getItem( i18n("Field Separator ?"), i18n("Please choose a field separator !"), strListSeparators);
					
			QString strRow;
			
			for(int currentCol = 0; currentCol < pTable->numCols(); currentCol++)
			{
				if(currentCol > 0)
				{
					strRow.append(strSeparator);
				}
				strRow.append("\"");
				
				QWidget *w = pTable->cellWidget(currentRow, currentCol);
				if((w != 0) && (w->className() == QString("KPGLinkLabel")))
				{
					KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
					strRow.append(pLabel->text());
				}
				else
				{
					strRow.append(pTable->text(currentRow, currentCol));
				}
								
				strRow.append("\"");
			}
		
			QApplication::clipboard()->setText(strRow);
		}
	}
}

void KPGUtil::copyTableCsv(QTable *pTable)
{
    if(pTable)
	{
		QStringList strListSeparators;
		strListSeparators << "," << ";" << "|" << " ";
		QString strSeparator = QInputDialog::getItem( i18n("Field Separator ?"), i18n("Please choose a field separator !"), strListSeparators);
				
		int cols = pTable->numCols();
		int rows = pTable->numRows();
		QString strTable;
		
		for(int currentRow = 0 ; currentRow < rows ; currentRow++)
		{
			for(int currentCol=0 ; currentCol < cols ; currentCol++)
			{
				if(currentCol > 0)
				{
					strTable.append(strSeparator);
				}
				strTable.append("\"");
				
				QWidget *w = pTable->cellWidget(currentRow, currentCol);
				if((w != 0) && (w->className() == QString("KPGLinkLabel")))
				{
					KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
					strTable.append(pLabel->text());
				}
				else
				{
					strTable.append(pTable->text(currentRow, currentCol).stripWhiteSpace());
				}
				
				strTable.append("\"");
			}
			strTable.append("\n");
    	}
    
    	QApplication::clipboard()->setText(strTable);
	}
}

void KPGUtil::copyTableXml(QTable *pTable)
{
	if(pTable)
	{
		int cols = pTable->numCols();
		int rows = pTable->numRows();
		
		// field names
		QHeader* hHeader = pTable->horizontalHeader();
		
		QString strTable("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		
		strTable.append("<table>\n");
		
		for(int currentRow = 0 ; currentRow < rows ; currentRow++)
		{
			strTable.append("<row");
			
			for(int currentCol=0 ; currentCol < cols ; currentCol++)
			{
				strTable.append(" ");
				
				QString strAttributeName(hHeader->label(currentCol));
				strAttributeName = strAttributeName.replace(' ', '_');
				
				strTable.append(strAttributeName);
				strTable.append("=\"");
					
				QString strValue;
				
				QWidget *w = pTable->cellWidget(currentRow, currentCol);
				if((w != 0) && (w->className() == QString("KPGLinkLabel")))
				{
					KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
					strValue =  pLabel->text();
				}
				else
				{
					strValue = pTable->text(currentRow, currentCol).stripWhiteSpace();
				}
				
				strValue = strValue.replace("<", "&lt;");
				strValue = strValue.replace(">", "&gt;");
				strValue = strValue.replace("\"", "");
				
				strTable.append(strValue);
				strTable.append("\"");
			}
			
			strTable.append(" />\n");
		}
		strTable.append("</table>\n");
		
		QApplication::clipboard()->setText(strTable);
	}
}
