//
// C++ Implementation: kpglinklabel
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpglinklabel.h"

#include <qtooltip.h>
#include <qstring.h>

#include <kcursor.h>

KPGLinkLabel::KPGLinkLabel(QWidget *parent, const char *name)
 : QLabel(parent, name) // KActiveLabel 
{
	setPaletteForegroundColor( QColor( 0, 0, 128 ) );
	setPaletteBackgroundColor( QColor( 244, 238, 215 ) );
	setCursor(KCursor::handCursor());
	setTextFormat( QLabel::PlainText );
	m_oid = 0;
}


KPGLinkLabel::~KPGLinkLabel()
{
}

void KPGLinkLabel::setValues(pqxx::oid _oid, const QString &strObjectName)
{
	//setText("<a href='#" + strObjectName + "'>" + strObjectName + "</a>");
  	setText(strObjectName);
	QToolTip::add( this, QString("OID: %1").arg(_oid));
	m_oid = _oid;
}

/*
void KPGLinkLabel::openLink(const QString &)
{
  // do nothing
}*/

#include "kpglinklabel.moc"
