//
// C++ Implementation: kpgmodifygroupwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifygroupwidget1.h"

// include files for KDE
#include <klineedit.h>
#include <kactionselector.h> 

// application specific includes
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroup.h"


KPGModifyGroupWidget1::KPGModifyGroupWidget1(QWidget *parent, const char *name, KPGGroup *pGroup, KPGUsersFolder *pUsersFolder)
 : KPGCreateGroupWidget1(parent, name)
{
	m_pGroup = pGroup;
	
	m_pLineEditGroupName->setText(pGroup->text(0));
	
	m_pLineEditSysId->setEnabled(false);
	m_pLineEditSysId->setText(QString("%1").arg(pGroup->sysId()));
	
	pUsersFolder->fillListBoxWithChildItems(m_pActionSelectorUsers->availableListBox());
	
	QStringList strListOfUsers =  pGroup->getListOfUsers();
	
	// Move users in group to their listbox
	for ( QStringList::Iterator it = strListOfUsers.begin(); it != strListOfUsers.end(); ++it ) 
	{
   	QString strUserName(*it);
		
		QListBoxItem *pItem = m_pActionSelectorUsers->availableListBox()->findItem(strUserName);
		if(pItem)
		{
			// Move group from available list to user list 
			m_pActionSelectorUsers->selectedListBox()->insertItem(* pItem->pixmap(), pItem->text());
			m_pActionSelectorUsers->availableListBox()->setCurrentItem(pItem);
			m_pActionSelectorUsers->availableListBox()->removeItem(m_pActionSelectorUsers->availableListBox()->currentItem());
		}
  }
  
  // This is here, instead of making connection in Qt Designer due to bug - forward declaration
  // class QListBoxItem; is not added to h file.
  connect( m_pActionSelectorUsers, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotUserAdded(QListBoxItem*) ) );
  connect( m_pActionSelectorUsers, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotUserRemoved(QListBoxItem*) ) );
}


KPGModifyGroupWidget1::~KPGModifyGroupWidget1()
{
}

void KPGModifyGroupWidget1::slotLineEditGroupNameChanged(const QString &strGroupName)
{
   emit sigEnableNextButton((getSQL().length() > 0) && (strGroupName.length() > 0));
}

void KPGModifyGroupWidget1::slotUserAdded(QListBoxItem*)
{
  emit sigEnableNextButton((getSQL().length() > 0) && (m_pLineEditGroupName->text().length() > 0));
}

void KPGModifyGroupWidget1::slotUserRemoved(QListBoxItem*)
{
  emit sigEnableNextButton((getSQL().length() > 0) && (m_pLineEditGroupName->text().length() > 0));
}

// Return part of SQL statement for ALTER GROUP
const QString KPGModifyGroupWidget1::getSQL() const
{
	QString strSQL;
	QString strSQLAdd("ALTER GROUP " + m_pGroup->text(0)); // group name
	QString strSQLDrop("ALTER GROUP " + m_pGroup->text(0)); // group name
		
	QStringList strListOfUsersAdd;
	QStringList strListOfUsersDrop;
	
	//---------------------------------------------------------------------------------
	// check users needs add to group
	QStringList strListOfUsers =  m_pGroup->getListOfUsers();
	
	for(unsigned int i = 0; i < m_pActionSelectorUsers->selectedListBox()->count(); i++)
	{
		// check if this user already exists in group
		bool bIsMember = false;
		for ( QStringList::Iterator it = strListOfUsers.begin(); it != strListOfUsers.end(); ++it ) 
		{
   		QString strUserName(*it);
			if(strUserName == m_pActionSelectorUsers->selectedListBox()->item(i)->text())
			{
				bIsMember = true;
				break;
			}
		}
		if(!bIsMember)
			strListOfUsersAdd.append(m_pActionSelectorUsers->selectedListBox()->item(i)->text());
	}
	
	unsigned int i = 0;
	for ( QStringList::Iterator it = strListOfUsersAdd.begin(); it != strListOfUsersAdd.end(); ++it ) 
	{
		QString strUserName(*it);
		
		if(i > 0)
			strSQLAdd.append(", ");
		else
			strSQLAdd.append(" ADD USER ");
			
		strSQLAdd.append(strUserName);
	}
	
	if(strListOfUsersAdd.count() > 0)
	{
		strSQL.append(strSQLAdd + ";\n");
	}
	
	//---------------------------------------------------------------------------------
	// check users needs drop from group
	for ( QStringList::Iterator it = strListOfUsers.begin(); it != strListOfUsers.end(); ++it ) 
	{
  	QString strUserName(*it);
		
		// check if this user is in group members list box 
		QListBoxItem *pItem = m_pActionSelectorUsers->selectedListBox()->findItem(strUserName);
		if(!pItem)
			strListOfUsersDrop.append(strUserName);	
	}
	
	i = 0;
	for ( QStringList::Iterator it = strListOfUsersDrop.begin(); it != strListOfUsersDrop.end(); ++it ) 
	{
		QString strUserName(*it);
		
		if(i > 0)
			strSQLDrop.append(", ");
		else
			strSQLDrop.append(" DROP USER ");
			
		strSQLDrop.append(strUserName);
	}
	
	if(strListOfUsersDrop.count() > 0)
	{
		strSQL.append(strSQLDrop + ";\n");
	}
	//---------------------------------------------------------------------------------
	
	if(m_pLineEditGroupName->text() != m_pGroup->text(0))
  {
    strSQL.append("ALTER GROUP ");
    strSQL.append(m_pGroup->text(0));
    strSQL.append(" RENAME TO ");
    strSQL.append(m_pLineEditGroupName->text());
    strSQL.append(";");
  } 
	
	return strSQL;
}


#include "kpgmodifygroupwidget1.moc"
