//
// C++ Interface: kpgcreateviewwidget3
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATEVIEWWIDGET3_H
#define KPGCREATEVIEWWIDGET3_H

#include "kpgcreateviewwidget3base.h"

#include "kpgcreateviewwizard.h"

class KPGDatabase;

/**
Widget for create view Wizard

@author Lumir Vanek
*/

class KPGCreateViewWidget3 : public KPGCreateViewWidget3Base
{
	Q_OBJECT
public:
    KPGCreateViewWidget3(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGCreateViewWidget3();
		
	void setNamespace(const QString &strNamespace) { m_strNamespace = strNamespace; }
		
	void setMapTableNameAlias(const MapTableNameAlias &mapTableNameAlias)
	{
		m_MapTableNameAlias = mapTableNameAlias;
	}
	
	const QString getSQL() const;
	void refreshAvailColumnsList(const QString &, bool);
		
	enum eJoinType { joinInner = 0, joinLeft, joinRight, joinFull };

protected slots:

	virtual void slotCheckBoxShowSysColumnsToggled(bool);
	virtual void slotComboBoxLeftTableActivated(const QString &);
	virtual void slotComboBoxRightTableActivated(const QString &);
	virtual void slotViewColumnsLeftSelectChanged(QListBoxItem*);
	virtual void slotViewColumnsRightSelectChanged(QListBoxItem*);
	virtual void slotRadioButtonInnerJoinClicked();
	virtual void slotRadioButtonLeftJoinClicked();
	virtual void slotRadioButtonRigthtJoinClicked();
	virtual void slotRadioButtonFullJoinClicked();
    
    virtual void slotJoinsSelectionChanged(QListViewItem *);
    virtual void slotJoinsCurrentChanged(QListViewItem *);
		
	virtual void slotJoinAdd();
    virtual void slotJoinDelete();
				
protected:
	bool m_bCheckBoxShowSysColumns;
	eJoinType m_eJoinType;
	KPGDatabase *m_pDatabase;
    QString m_strNamespace; // name of the namespace
    
    // Map of pair of <QString strTableName, QString strAlias> 	
    MapTableNameAlias m_MapTableNameAlias; 
				
signals:
	void sigEnableNextButton(bool);	
};

#endif
