//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablecolumnwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "kpgcreatetablewidget2.h"
#include "../kpgutil.h"


KPGCreateTableColumnWizard::KPGCreateTableColumnWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, const QString &strNamespace, const QString& strTableName)
 : KPG3StepsWizard(parent, name)
{
  m_strTableName = strTableName;
  m_strNamespace = strNamespace; 
  
  KPGCreateTableWidget2 *pCreateTableWidget2 = new KPGCreateTableWidget2(WizardPage1, "KPGCreateTableWidget2", pDatabase);
  m_pPageWidget1 = pCreateTableWidget2;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTableWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
        
  // default schema in page 2 is the same as in page 1
  pCreateTableWidget2->refreshListOfDatatypes();
  
  pCreateTableWidget2->m_pLineEditColumnName->setFocus();
  
  languageChange();
}


KPGCreateTableColumnWizard::~KPGCreateTableColumnWizard()
{
}


void KPGCreateTableColumnWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Add Column to Table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Define table column(s)" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTableColumnWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    KPGCreateTableWidget2 *pCreateTableWidget2 = static_cast <KPGCreateTableWidget2 *> (m_pPageWidget1);
    
    // prepare SQL statement
    QString strSQL;
    
    QListViewItem * pItem = pCreateTableWidget2->m_pListViewColumns->firstChild();
    while(pItem)
    {
      strSQL.append("ALTER TABLE ");
      strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
      strSQL.append(" ADD COLUMN ");
      strSQL.append(KPGUtil::quotedName(pItem->text(0))); // name
      strSQL.append(" ");
      strSQL.append(pItem->text(1)); // definition
      strSQL.append(";\n");
      
      pItem = pItem->nextSibling();
    }
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreatetablecolumnwizard.moc"
