//
// C++ Implementation: kpgcreateschemawizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateschemawizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <klineedit.h>
#include <kcombobox.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgcreateschemawidget1.h"
#include "kpgcreateschemawidget2.h"


KPGCreateSchemaWizard::KPGCreateSchemaWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPG4StepsWizard(parent, name)
{
  KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
  
	KPGCreateSchemaWidget1 *pCreateSchemaWidget1 = new KPGCreateSchemaWidget1(WizardPage1, "KPGCreateSchemaWidget1", pServer->getUsersFolder());
	m_pPageWidget1 = pCreateSchemaWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateSchemaWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
  KPGCreateSchemaWidget2 *pCreateSchemaWidget2 = new KPGCreateSchemaWidget2(WizardPage2, "KPGCreateSchemaWidget2");
  m_pPageWidget2 = pCreateSchemaWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  //connect(pCreateSchemaWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateSchemaWidget2->m_pListBoxUsersGroups);
  pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateSchemaWidget2->m_pListBoxUsersGroups);
  
  if(pServer->versionMajor() >= 8)
  	pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateSchemaWidget1->m_pComboBoxTablespace);
  else
    pCreateSchemaWidget1->m_pComboBoxTablespace->setEnabled(false);
    
	languageChange();
  
  setNextEnabled(WizardPage2, true);
}


KPGCreateSchemaWizard::~KPGCreateSchemaWizard()
{
}

void KPGCreateSchemaWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
		
		setCaption( i18n( "Create new schema" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Schema name and owner" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Define user rights" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateSchemaWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Define user rights
  {
    KPGCreateSchemaWidget1 *pCreateSchemaWidget1 = static_cast <KPGCreateSchemaWidget1 *> (m_pPageWidget1);
    KPGCreateSchemaWidget2 *pCreateSchemaWidget2 = static_cast <KPGCreateSchemaWidget2 *> (m_pPageWidget2);
        
    // Set schema name
    pCreateSchemaWidget2->setSchemaName(pCreateSchemaWidget1->m_pLineEditSchemaName->text());
  }
  
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL;
		strSQL.append((static_cast <KPGCreateSchemaWidget1 *> (m_pPageWidget1))->getSQL());
		strSQL.append(";\n\n");
    strSQL.append((static_cast <KPGCreateSchemaWidget2 *> (m_pPageWidget2))->getSQL());
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage4) // Step 4 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreateschemawizard.moc"
