//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatelanguagewidget1.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgfunction.h"


KPGCreateLanguageWidget1::KPGCreateLanguageWidget1(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateLanguageWidget1Base(parent, name)
{
  refreshListOfFunctions(pDatabase);
  m_pLineEditLanguageName->setFocus();
}


KPGCreateLanguageWidget1::~KPGCreateLanguageWidget1()
{
}

void KPGCreateLanguageWidget1::refreshListOfFunctions(KPGDatabase *pDatabase)
{
  m_pComboBoxHandlerFunction->clear();
  m_pComboBoxValidatorFunction->clear();
  
  m_pComboBoxValidatorFunction->insertItem(i18n("None"));
  
  //--- Obtain list of functions
  
  // First find schema - this same as created table
  KPGTreeItem *pItem = pDatabase->getChildByName("public");
  if(!pItem)
  {
    kdDebug() << k_funcinfo << " no item found: public" << endl;
    return;
  }
  
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
  KPGFunctionsFolder *pFunctionsFolder = pSchema->getFunctionsFolder();
  
  // traverse list of functions
  QListViewItem * pLvItem = pFunctionsFolder->firstChild();
  while(pLvItem)
  {
    KPGFunction *pFunction = static_cast <KPGFunction *> (pLvItem);
      
    if((pFunction->getVolatile() == "v") && (pFunction->nArgs() == 0) && (pFunction->langName() == "c"))
      {
        m_pComboBoxHandlerFunction->insertItem(* pFunction->pixmap(0), pFunction->text(0)); 
        m_pComboBoxValidatorFunction->insertItem(* pFunction->pixmap(0), pFunction->text(0));
      }
    pLvItem = pLvItem->nextSibling();
  }
}

void KPGCreateLanguageWidget1::slotLanguageNameChanged(const QString &strText)
{
  emit sigEnableNextButton(! strText.isEmpty() && (m_pComboBoxHandlerFunction->currentText().isEmpty() == false));
}

void KPGCreateLanguageWidget1::slotCurrentHandlerFunctionChanged(int)
{
  emit sigEnableNextButton(! m_pLineEditLanguageName->text().isEmpty() && (m_pComboBoxHandlerFunction->currentText().isEmpty() == false));
}

// Return part of SQL statement for CREATE LANGUAGE
const QString KPGCreateLanguageWidget1::getSQL() const
{
  QString strSQL("CREATE");
  
  if(m_pCheckBoxTrusted->isChecked())
    strSQL.append(" TRUSTED");
    
  strSQL.append(" PROCEDURAL LANGUAGE '");
  strSQL.append(m_pLineEditLanguageName->text());
  strSQL.append("'\n");
  
  strSQL.append("HANDLER ");
  strSQL.append(m_pComboBoxHandlerFunction->currentText());
  
  if(m_pComboBoxValidatorFunction->currentItem() > 0)
  {
    strSQL.append("\nVALIDATOR ");
    strSQL.append(m_pComboBoxValidatorFunction->currentText());
  }
  
  return strSQL;
}

#include "kpgcreatelanguagewidget1.moc"
