//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATEFUNCTIONWIDGET5_H
#define KPGCREATEFUNCTIONWIDGET5_H

#include "kpgcreatefunctionwidget5base.h"

/**
Widget for create function wizard

@author Lumir Vanek
*/

class KPGCreateFunctionWidget5 : public KPGCreateFunctionWidget5Base
{
Q_OBJECT
public:
    KPGCreateFunctionWidget5(QWidget *parent, const char *name, bool = true);
    ~KPGCreateFunctionWidget5();

    void setFunctionName(const QString &strFunctionName, const QString& strFunctionArguments) 
    { 
    	m_strFunctionName = strFunctionName;
    	m_strFunctionArguments = strFunctionArguments;
    	m_strFunctionArguments.replace('\n', ' '); // remove newlines from arguments 
    }
    void setNamespace(const QString &strNamespace) { m_strNamespace = strNamespace; }
    const QString getSQL() const;

protected:
    void enableAddGrantButton();
    
protected:
    QString m_strFunctionName;      // name of the created function
    QString m_strFunctionArguments; // Function arguments
    QString m_strNamespace;         // name of the namespace
            
    QString strGR; // contain GRANT or REVOKE
    QString strTF; // contain TO or FROM
    
    bool m_bGrantOrRevoke;
    
protected slots:

    virtual void slotCheckBoxPublicToggled(bool);
    virtual void slotListBoxUsersSelectionChanged();
    
    virtual void slotGrantOptionsToggled(bool);
    
    virtual void slotGrantsSelectionChanged(QListViewItem *);
    virtual void slotGrantsCurrentChanged(QListViewItem *);
    
    virtual void slotGrantAdd();
    virtual void slotGrantDelete();
            
signals:
    void sigEnableNextButton(bool);   
};

#endif
