//
// C++ Implementation: kpgcreatefunctionwidget4
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatefunctionwidget4.h"

// include files for Qt
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qlabel.h>


// include files for KDE
#include <kurlrequester.h>
#include <klineedit.h>
#include <ktextedit.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../kpggeneralsettings.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"

KPGCreateFunctionWidget4::KPGCreateFunctionWidget4(QWidget *parent, const char *name)
 : KPGCreateFunctionWidget4Base(parent, name)
{
  m_pTextEditFunctionDefinition->setFont( KPoGreView::configuration()->sqleditor()->font() );
    
  m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditFunctionDefinition);
  
  m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
  m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
  m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
  m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
  m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
  m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
  m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
  
  m_pSyntaxHighlighter->rehighlight();
}

KPGCreateFunctionWidget4::~KPGCreateFunctionWidget4()
{
  delete m_pSyntaxHighlighter;
}

void KPGCreateFunctionWidget4::switchToPage(int nPage)
{
  m_pWidgetStack->raiseWidget(nPage);
  
  if(nPage == 0)
  {
    // C function
    emit sigEnableNextButton(! m_pURLRequesterLibraryPath->url().isEmpty() );
  }
  else
  {
    // SQL, plpgsql ...
    emit sigEnableNextButton( m_pTextEditFunctionDefinition->length() > 0);
  }
}

void KPGCreateFunctionWidget4::slotLibraryPathChanged(const QString &strText)
{
  emit sigEnableNextButton(! strText.isEmpty() );
}
  
void KPGCreateFunctionWidget4::slotDefinitionChanged()
{
  emit sigEnableNextButton(! m_pTextEditFunctionDefinition->text().isEmpty() );
}
    
// Return part of SQL statement for CREATE FUNCTION
const QString KPGCreateFunctionWidget4::getSQL() const
{
	bool bUseDollarsForFncBody = KPoGreView::configuration()->general()->useDollarsForFncBody();
	if(m_pWidgetStack->visibleWidget() == m_pWStackPage0)
	{
		bUseDollarsForFncBody = false; // For C function use apostrophes
	}
	
	QString strSQL("AS");
	strSQL.append(bUseDollarsForFncBody ? "\n$$" : " '");
	
	if(m_pWidgetStack->visibleWidget() == m_pWStackPage0)
	{
		strSQL.append(m_pURLRequesterLibraryPath->url());
		
		if(m_pLineEditLinkSymbol->text().isEmpty() == false)
		{
		strSQL.append("', '");
		strSQL.append(m_pLineEditLinkSymbol->text());
		}
	}
	else
	{
		bool bMultiline = false;
		if((KPoGreView::configuration()->general()->useDollarsForFncBody())
			|| (m_pTextEditFunctionDefinition->text().find('\n') >= 0))
		{
			bMultiline = true;
		}
		
		if(bMultiline) strSQL.append("\n");
		strSQL.append(m_pTextEditFunctionDefinition->text());
		if(bMultiline) strSQL.append("\n");
	}
		
	strSQL.append(bUseDollarsForFncBody ? "$$\n" : "'");
		
	return strSQL;
}


#include "kpgcreatefunctionwidget4.moc"
