//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcopytablewidget2.h"

// include files for Qt
#include <qcheckbox.h>

// include files for KDE
#include <klineedit.h> 


KPGCopyTableWidget2::KPGCopyTableWidget2(QWidget *parent, const char *name)
 : KPGCopyTableWidget2Base(parent, name)
{
}

KPGCopyTableWidget2::~KPGCopyTableWidget2()
{
}

void KPGCopyTableWidget2::setCvsMode(bool bCvsMode)
{
  m_bCvsMode = bCvsMode;
  m_pCheckBoxCsvQuote->setEnabled(bCvsMode);
  m_pCheckBoxCsvEscape->setEnabled(bCvsMode);
  
  if(!bCvsMode)
  {
    m_pCheckBoxCsvQuote->setChecked(false);
    m_pCheckBoxCsvEscape->setChecked(false);
  }
  
  emit sigEnableNextButton(true);
}

void KPGCopyTableWidget2::slotBinaryToggled(bool bChecked)
{
  m_pCheckBoxDelimiter->setEnabled(!bChecked);
  m_pCheckBoxNullString->setEnabled(!bChecked);
  
  if(bChecked)
  {
    m_pCheckBoxDelimiter->setChecked(false);
    m_pCheckBoxNullString->setChecked(false);
  }
}

void KPGCopyTableWidget2::slotDelimiterToggled(bool bChecked)
{
  m_pLineEditDelimiter->setEnabled(bChecked);
}
    
void KPGCopyTableWidget2::slotNullStringToggled(bool bChecked)
{
  m_pLineEditNullString->setEnabled(bChecked);
}
    
void KPGCopyTableWidget2::slotCsvQuoteToggled(bool bChecked)
{
  m_pLineEditCsvQuote->setEnabled(bChecked);
}

void KPGCopyTableWidget2::slotCsvEscapeToggled(bool bChecked)
{
  m_pLineEditCsvEscape->setEnabled(bChecked);
}  

const QString KPGCopyTableWidget2::getSQL() const
{
  QString strSQL(" WITH\n");
 
  unsigned int iBasicLength = strSQL.length(); // store this value to decide, if any changes maded
  
  if(m_pCheckBoxBinary->isChecked())
    strSQL.append("BINARY\n");
        
  if(m_pCheckBoxOIDs->isChecked())
    strSQL.append("OIDS\n");
  
  if(m_pCheckBoxDelimiter->isChecked())
    {
      strSQL.append("DELIMITER AS '");
      strSQL.append(m_pLineEditDelimiter->text());
      strSQL.append("'\n");
    }
    
  if(m_pCheckBoxNullString->isChecked())
    {
      strSQL.append("NULL AS '");
      strSQL.append(m_pLineEditNullString->text());
      strSQL.append("'\n");
    }
    
  if(m_bCvsMode)
  {
    strSQL.append("CSV");
    
    if(m_pCheckBoxCsvQuote->isChecked())
    {
      strSQL.append(" QUOTE AS '");
      strSQL.append(m_pLineEditCsvQuote->text());
      strSQL.append("'");
    }
    
    if(m_pCheckBoxCsvEscape->isChecked())
    {
      strSQL.append(" ESCAPE AS '");
      strSQL.append(m_pLineEditCsvEscape->text());
      strSQL.append("'\n");
    }
  }
  
  if(iBasicLength == strSQL.length())
    return ""; // no changes maded  
    
  return strSQL;
}

#include "kpgcopytablewidget2.moc"
