//
// C++ Implementation: kpg4stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpg4stepswizard.h"

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kcursor.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgdatabase.h"


KPG4StepsWizard::KPG4StepsWizard(QWidget *parent, const char *name)
 : KPG4StepsWizardBase(parent, name)
{
	m_pConnection = 0;
    m_pTextEditSQL->setFont( KPoGreView::configuration()->sqleditor()->font() );   
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditSQL);
	
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
		
	setNextEnabled(WizardPage1, false);
	setNextEnabled(WizardPage2, false);
}


KPG4StepsWizard::~KPG4StepsWizard()
{
	delete m_pSyntaxHighlighter;
	
	if(m_pConnection)
	{
		KPGNoticer * pPgNoticer = m_pConnection->kpgNoticer();
        disconnect(pPgNoticer, SIGNAL(sigNotice(const QString &)), this, SLOT(slotProcessNotice(const QString &)));
	}
}

// Set connection for wizard operation
void KPG4StepsWizard::setConnection(KPGConnection * pConnection)
{
	m_pConnection = pConnection;
	KPGNoticer * pPgNoticer = pConnection->kpgNoticer();
    connect(pPgNoticer, SIGNAL(sigNotice(const QString &)), this, SLOT(slotProcessNotice(const QString &)));
}

// Run SQL query - as final Wizard operation
void KPG4StepsWizard::runQuery(bool bWithTransaction) 
{
	m_listOfNotifications.clear();
	m_pTextEditResult->clear();
	 
   	// Run SQL statement
   	if(m_pConnection == 0)
    {
      kdError() << k_funcinfo << " Database not connected to server !" << endl;
      m_pTextEditResult->setText("Database not connected to server !");
    }
    else
    { 
      try
      { 
        setCursor(KCursor::waitCursor());
        
        pqxx::result R = m_pConnection->runQuery(m_pTextEditSQL->text(), bWithTransaction ? KPGConnection::eTransNormal : KPGConnection::eTransNone);
        
		if(m_listOfNotifications.count() > 0)
		{
			m_pTextEditResult->setText(m_listOfNotifications.join(""));
			m_listOfNotifications.clear();
		}
        
		m_pTextEditResult->append(i18n("\nOperation finished"));
        
        setFinishEnabled(WizardPage4, true);
        setCursor(KCursor::arrowCursor());
      }
      catch(const std::exception &e)
      {
          m_pTextEditResult->append(m_pConnection->toUnicode(e.what()));
          setCursor(KCursor::arrowCursor());
      } 
    }
}

// Enable/disable next button for 1st page
void KPG4StepsWizard::slotEnableNextButton1(bool bEnable)
{
	  setNextEnabled(WizardPage1, bEnable);
}

// Enable/disable next button for 2nd page
void KPG4StepsWizard::slotEnableNextButton2(bool bEnable)
{
	  setNextEnabled(WizardPage2, bEnable);
}

// Process notice from connection
void KPG4StepsWizard::slotProcessNotice(const QString & strNotice)
{
	m_listOfNotifications << strNotice;
}

#include "kpg4stepswizard.moc"
