//
// C++ Implementation: kpguniqueconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpguniqueconstrproppage.h"

#include <qtable.h>

#include <klocale.h>


#include "../kpgutil.h"
#include "../DbObjects/kpguniqueconstr.h"

KPGUniqueConstrPropPage::KPGUniqueConstrPropPage(QWidget *parent, KPGUniqueConstr * pUniqueConstr)
 : KPGUniqueConstrPropPageBase(parent, "KPGUniqueConstrPropPage")
{
	m_pUniqueConstr = pUniqueConstr;
	displayProperties();
}


KPGUniqueConstrPropPage::~KPGUniqueConstrPropPage()
{
}

void KPGUniqueConstrPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pUniqueConstr->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pUniqueConstr->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Constraint name (not necessarily unique!)"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
    m_pTableProperties->setText(iRow, 1, m_pUniqueConstr->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the constraint"));
	
	//--- Is Deferrable
	m_pTableProperties->setText(iRow, 0, i18n("Is Deferrable"));
    m_pTableProperties->setPixmap(iRow, 1, m_pUniqueConstr->isDeferrable() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Is the constraint deferrable ?"));
	
	//--- Is Deferred
	m_pTableProperties->setText(iRow, 0, i18n("Is Deferred"));
    m_pTableProperties->setPixmap(iRow, 1, m_pUniqueConstr->isDeferred()  ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Is the constraint deferred by default ?"));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
    m_pTableProperties->setText(iRow, 1, m_pUniqueConstr->nspName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
			
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

// Consumes request for context menu for property table
void KPGUniqueConstrPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpguniqueconstrproppage.moc"
