//
// C++ Implementation: kpgtypeattributeproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtypeattributeproppage.h"

#include <qtable.h>  

#include <kdebug.h>
#include <klocale.h>

#include "../DbObjects/kpgtypeattribute.h"
#include "../kpglinklabel.h"


KPGTypeAttributePropPage::KPGTypeAttributePropPage(QWidget *parent, KPGTypeAttribute * pTypeAttribute)
 : KPGTypeAttributePropPageBase(parent, "KPGTypeAttributePropPage")
{
	m_pTypeAttribute = pTypeAttribute;
	displayProperties();
}

KPGTypeAttributePropPage::~KPGTypeAttributePropPage()
{
}

void KPGTypeAttributePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pTypeAttribute->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("The attribute name"));
	
	//--- Type Name
	m_pTableProperties->setText(iRow, 0, i18n("Type"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel(m_pTableProperties, "Type" );
	pLabel->setValues(m_pTypeAttribute->oidType(), m_pTypeAttribute->typName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("The attribute type"));
	
	//--- Type length
	m_pTableProperties->setText(iRow, 0, i18n("Type length"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTypeAttribute->attLen()));
	m_pTableProperties->setText(iRow++, 2, i18n("For a fixed-size type, typlen is the number of bytes in the internal representation of the type. But for a variable-length\
type, typlen is negative. -1 indicates a \"varlena\" type (one that has a length word), -2 indicates a null-terminated C string."));
	
	//--- Attribute number
	m_pTableProperties->setText(iRow, 0, i18n("Attribute number"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTypeAttribute->attNum()));
	m_pTableProperties->setText(iRow++, 2, i18n("The number of the attribute. Ordinary columns are numbered from 1 up. System columns, such as oid, have (arbitrary) negative \
numbers."));
	
	//--- Number of dimensions
	m_pTableProperties->setText(iRow, 0, i18n("Number of dimensions"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTypeAttribute->attNdims()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of dimensions, if the attribute is an array type; otherwise 0. (Presently, the number of dimensions of an array is not \
enforced, so any nonzero value effectively means \"it's an array\".) "));
	
	//--- Type mode
	m_pTableProperties->setText(iRow, 0, i18n("Type mode"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTypeAttribute->attTypmod()));
	m_pTableProperties->setText(iRow++, 2, i18n("Records type-specific data supplied at table creation time (for example, the maximum length of a varchar attribute). It is \
	passed to type-specific input functions and length coercion functions. The value will generally be -1 for types that do not need atttypmod. "));

	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
  	m_pTableProperties->setText(iRow, 1, m_pTypeAttribute->nspName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the datatype namespace"));

			
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGTypeAttributePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGTypeAttributePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgtypeattributeproppage.moc"

