//
// C++ Implementation: kpgfunctionsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgfunctionsfolderproppage.h"

#include <qtable.h>

#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgconnection.h"

KPGFunctionsFolderPropPage::KPGFunctionsFolderPropPage(QWidget *pParent, KPGFunctionsFolder * pFunctionsFolder)
 : KPGPropertyPage(pParent, "KPGFunctionsFolderPropPage")
{
	m_pFunctionsFolder = pFunctionsFolder;
	displayProperties();
}


KPGFunctionsFolderPropPage::~KPGFunctionsFolderPropPage()
{
}

void KPGFunctionsFolderPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Is Aggregate"));
  	pHeader->setLabel(nCol++, i18n("Is Security definer"));
	pHeader->setLabel(nCol++, i18n("Is Strict"));
	pHeader->setLabel(nCol++, i18n("Return Set"));
	pHeader->setLabel(nCol++, i18n("Volatile"));
	pHeader->setLabel(nCol++, i18n("Number of arguments"));
	pHeader->setLabel(nCol++, i18n("Bin"));
	pHeader->setLabel(nCol++, i18n("ACL"));
	pHeader->setLabel(nCol++, i18n("Type name"));
	pHeader->setLabel(nCol++, i18n("Language name"));
	pHeader->setLabel(nCol++, i18n("Owner"));

	QTextCodec * pTextCodec = m_pFunctionsFolder->connection()->textCodec();
	
    KPGUtil::fillPropertiesTable(m_pFunctionsFolder->resultFunctions(), m_pTableItems, pTextCodec, true, 13);
}

