//
// C++ Interface: kpgconversionproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCONVERSIONPROPPAGE_H
#define KPGCONVERSIONPROPPAGE_H

#include "kpgconversionproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGConversion;

/**
  * Conversion properties
  *
  * @author Lumir Vanek
  */
class KPGConversionPropPage : public KPGConversionPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGConversionPropPage(QWidget *parent, KPGConversion *);
    ~KPGConversionPropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
	// Display properties of underlying database object
	virtual void displayProperties();
	
protected:

	KPGConversion *m_pConversion;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	                 
    // Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    	
signals:
	void sigSearchObject(pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
